/*
 * Decompiled with CFR 0.152.
 */
package xyz.maow.jsource.text;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import xyz.maow.jsource.internal.Conditions;
import xyz.maow.jsource.io.Sink;
import xyz.maow.jsource.io.StreamSink;
import xyz.maow.jsource.io.StringSink;
import xyz.maow.jsource.text.component.Component;

public class SourceWriter
implements Closeable {
    protected final Sink sink;
    protected final String indent;
    protected int level;

    public SourceWriter(Sink sink, String indent) {
        this.sink = Conditions.nonNull(sink, "sink");
        this.indent = Conditions.nonNull(indent, "indent");
        this.level = 0;
    }

    public SourceWriter(StringBuilder builder, String indent) {
        this(new StringSink(builder), indent);
    }

    public SourceWriter(String s, String indent) {
        this(new StringSink(s), indent);
    }

    public SourceWriter(String indent) {
        this(new StringSink(new StringBuilder()), indent);
    }

    public SourceWriter(OutputStream stream, String indent) {
        this(new StreamSink(stream), indent);
    }

    protected void indents() {
        for (int i = 0; i < this.level; ++i) {
            try {
                this.sink.write(this.indent);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void accept(Component component) {
        component.accept(this);
    }

    public void write(Object o) {
        try {
            this.sink.write(o);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write_l(Object o) {
        this.write(o);
        this.indent();
    }

    public void write_r(Object o) {
        this.unindent();
        this.write(o);
    }

    public void write_lr(Object o) {
        this.indent();
        this.write(o);
        this.unindent();
    }

    public void newline() {
        this.write("\n");
    }

    public void writeln(Object o) {
        this.indents();
        this.write(o);
        this.newline();
    }

    public void writeln(Object ... objs) {
        this.indents();
        for (Object o : objs) {
            this.write(o);
        }
        this.newline();
    }

    public void writeln_l(Object o) {
        this.writeln(o);
        this.indent();
    }

    public void writeln_l(Object ... objs) {
        this.writeln(objs);
        this.indent();
    }

    public void writeln_r(Object o) {
        this.unindent();
        this.writeln(o);
    }

    public void writeln_r(Object ... objs) {
        this.unindent();
        this.writeln(objs);
    }

    public void writeln_lr(Object o) {
        this.indent();
        this.writeln(o);
        this.unindent();
    }

    public void writeln_lr(Object ... objs) {
        this.indent();
        this.writeln(objs);
        this.unindent();
    }

    public void indent() {
        ++this.level;
    }

    public void unindent() {
        --this.level;
    }

    @Override
    public void close() {
        if (this.sink instanceof Closeable) {
            try {
                ((Closeable)((Object)this.sink)).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.sink.toString();
    }
}

