/*
 * Decompiled with CFR 0.152.
 */
package xyz.maow.jsource.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import xyz.maow.jsource.internal.Conditions;
import xyz.maow.jsource.io.StreamSink;

public final class Sinks {
    private Sinks() {
        throw new UnsupportedOperationException();
    }

    public static StreamSink fromFile(File file) throws FileNotFoundException {
        return new StreamSink(new FileOutputStream(Conditions.nonNull(file, "file")));
    }

    public static StreamSink fromFile(String fileName) throws FileNotFoundException {
        return new StreamSink(new FileOutputStream(Conditions.nonNull(fileName, "fileName")));
    }

    public static StreamSink fromPath(Path path) throws IOException {
        return new StreamSink(Files.newOutputStream(Conditions.nonNull(path, "path"), new OpenOption[0]));
    }

    public static StreamSink fromPath(String path) throws IOException {
        return new StreamSink(Files.newOutputStream(Paths.get(Conditions.nonNull(path, "path"), new String[0]), new OpenOption[0]));
    }

    public static StreamSink fromFiler(Filer filer, String fileName, Element ... originatingElements) throws IOException {
        JavaFileObject file = filer.createSourceFile(Conditions.nonNull(fileName, "fileName"), originatingElements);
        return new StreamSink(file.openOutputStream());
    }
}

