/*
 * Decompiled with CFR 0.152.
 */
package xyz.junerver.analytics_plugin;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import xyz.junerver.analytics_plugin.AnalyticsExtension;
import xyz.junerver.analytics_plugin.ext.CommonExtKt;
import xyz.junerver.analytics_plugin.vistor.CommonClassVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0010H\u0016J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lxyz/junerver/analytics_plugin/AnalyticsTransform;", "Lcom/android/build/api/transform/Transform;", "params", "Lxyz/junerver/analytics_plugin/AnalyticsExtension;", "(Lxyz/junerver/analytics_plugin/AnalyticsExtension;)V", "getParams", "()Lxyz/junerver/analytics_plugin/AnalyticsExtension;", "disablePlugin", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "filterFile", "", "fileName", "", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "getScopes", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "handlerDirInput", "dirInput", "Lcom/android/build/api/transform/DirectoryInput;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "incremental", "handlerFullDirInput", "handlerJarInput", "jarInput", "Lcom/android/build/api/transform/JarInput;", "handlerJarInputInsert", "isIncremental", "transform", "analytics-plugin"})
public final class AnalyticsTransform
extends Transform {
    @NotNull
    private final AnalyticsExtension params;

    public AnalyticsTransform(@NotNull AnalyticsExtension params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.params = params;
    }

    @NotNull
    public final AnalyticsExtension getParams() {
        return this.params;
    }

    @NotNull
    public String getName() {
        return "AnalyticsPlugin";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        Set set = TransformManager.CONTENT_CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"CONTENT_CLASS");
        return set;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        Set set = TransformManager.SCOPE_FULL_PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SCOPE_FULL_PROJECT");
        return set;
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        super.transform(transformInvocation);
        if (!this.params.getEnable()) {
            this.disablePlugin(transformInvocation);
            return;
        }
        CommonExtKt.log("Analytics \u5b57\u8282\u7801\u63d2\u6869\u5f00\u59cb>>>>>>>>>>>>>>>>>");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Collection inputs = transformInvocation.getInputs();
        TransformOutputProvider outputProvider = transformInvocation.getOutputProvider();
        boolean incremental = transformInvocation.isIncremental();
        if (outputProvider != null && !incremental) {
            outputProvider.deleteAll();
        }
        Intrinsics.checkNotNullExpressionValue((Object)inputs, (String)"inputs");
        Iterable $this$forEach$iv = inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransformInput it = (TransformInput)element$iv;
            boolean bl2 = false;
            Collection collection = it.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.directoryInputs");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput dirInput = (DirectoryInput)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dirInput, (String)"dirInput");
                Intrinsics.checkNotNullExpressionValue((Object)outputProvider, (String)"outputProvider");
                this.handlerDirInput(dirInput, outputProvider, incremental);
            }
            Collection collection2 = it.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"it.jarInputs");
            $this$forEach$iv2 = collection2;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File file;
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl4 = false;
                if (!this.params.getIgnoreJar()) {
                    Intrinsics.checkNotNullExpressionValue((Object)jarInput, (String)"jarInput");
                    Intrinsics.checkNotNullExpressionValue((Object)outputProvider, (String)"outputProvider");
                    this.handlerJarInput(jarInput, outputProvider, incremental);
                    continue;
                }
                File dest = file = transformInvocation.getOutputProvider().getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                boolean bl5 = false;
                FileUtils.copyFile((File)jarInput.getFile(), (File)dest);
            }
        }
        long time = System.currentTimeMillis() - start$iv;
        CommonExtKt.log("Analytics \u5b57\u8282\u7801\u63d2\u6869\u7ed3\u675f<<<<<<<<<<<<<<<<<<<< " + time);
    }

    private final void handlerJarInput(JarInput jarInput, TransformOutputProvider outputProvider, boolean incremental) {
        block8: {
            block7: {
                if (!incremental) break block7;
                File dest = outputProvider.getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                Status status = jarInput.getStatus();
                switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.handlerJarInputInsert(jarInput, outputProvider);
                        break;
                    }
                    case 4: {
                        if (!dest.exists()) break block8;
                        FileUtils.forceDelete((File)dest);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block8;
            }
            this.handlerJarInputInsert(jarInput, outputProvider);
        }
    }

    private final void handlerJarInputInsert(JarInput jarInput, TransformOutputProvider outputProvider) {
        String string = jarInput.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarInput.file.absolutePath");
        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            return;
        }
        String jarName = jarInput.getName();
        String md5Name = DigestUtils.md5Hex((String)jarInput.getFile().getAbsolutePath());
        String string2 = jarName;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jarName");
        if (StringsKt.endsWith$default((String)string2, (String)".jar", (boolean)false, (int)2, null)) {
            String string3 = jarName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jarName");
            String string4 = string3;
            int n = 0;
            int n2 = jarName.length() - 4;
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarName = string5;
        }
        JarFile jarFile = new JarFile(jarInput.getFile());
        Enumeration<JarEntry> enumeration = jarFile.entries();
        File tempFile = new File(jarInput.getFile().getParent() + File.separator + "class_temp.jar");
        if (tempFile.exists()) {
            tempFile.delete();
        }
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(tempFile));
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry;
            if (enumeration.nextElement() == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.jar.JarEntry");
            }
            String entryName = jarEntry.getName();
            ZipEntry zipEntry = new ZipEntry(entryName);
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            Intrinsics.checkNotNullExpressionValue((Object)entryName, (String)"entryName");
            if (this.filterFile(entryName)) {
                jarOutputStream.putNextEntry(zipEntry);
                ClassReader classReader = new ClassReader(IOUtils.toByteArray((InputStream)inputStream));
                ClassWriter classWriter = new ClassWriter(classReader, 1);
                CommonClassVisitor trackPageClassNode = new CommonClassVisitor(classWriter, classReader);
                classReader.accept((ClassVisitor)trackPageClassNode, 8);
                trackPageClassNode.accept((ClassVisitor)classWriter);
                jarOutputStream.write(classWriter.toByteArray());
            } else {
                jarOutputStream.putNextEntry(zipEntry);
                jarOutputStream.write(IOUtils.toByteArray((InputStream)inputStream));
            }
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        jarFile.close();
        File dest = outputProvider.getContentLocation(jarName + md5Name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
        FileUtils.copyFile((File)tempFile, (File)dest);
        tempFile.delete();
    }

    private final void handlerDirInput(DirectoryInput dirInput, TransformOutputProvider outputProvider, boolean incremental) {
        if (incremental) {
            File dest = outputProvider.getContentLocation(dirInput.getName(), dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY);
            FileUtils.forceMkdir((File)dest);
            String srcDirPath = dirInput.getFile().getAbsolutePath();
            String destDirPath = dest.getAbsolutePath();
            Map map = dirInput.getChangedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"dirInput.changedFiles");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry changeFile = element$iv = iterator.next();
                boolean bl = false;
                String string = ((File)changeFile.getKey()).getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"changeFile.key.absolutePath");
                Intrinsics.checkNotNullExpressionValue((Object)srcDirPath, (String)"srcDirPath");
                Intrinsics.checkNotNullExpressionValue((Object)destDirPath, (String)"destDirPath");
                File destFile = new File(StringsKt.replace$default((String)string, (String)srcDirPath, (String)destDirPath, (boolean)false, (int)4, null));
                Status status = (Status)changeFile.getValue();
                switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (!destFile.exists()) break;
                        destFile.delete();
                        break;
                    }
                    case 2: 
                    case 3: {
                        try {
                            FileUtils.touch((File)destFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String string2 = ((File)changeFile.getKey()).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"changeFile.key.name");
                        if (this.filterFile(string2)) {
                            FileOutputStream fileOutputStream;
                            CommonExtKt.log("dir file->" + ((File)changeFile.getKey()).getAbsolutePath());
                            Object k = changeFile.getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"changeFile.key");
                            ClassReader classReader = new ClassReader(FilesKt.readBytes((File)((File)k)));
                            ClassWriter classWriter = new ClassWriter(classReader, 1);
                            CommonClassVisitor trackPageClassNode = new CommonClassVisitor(classWriter, classReader);
                            classReader.accept((ClassVisitor)trackPageClassNode, 8);
                            trackPageClassNode.accept((ClassVisitor)classWriter);
                            FileOutputStream $this$handlerDirInput_u24lambda_u2d6_u24lambda_u2d5 = fileOutputStream = new FileOutputStream(destFile);
                            boolean bl2 = false;
                            $this$handlerDirInput_u24lambda_u2d6_u24lambda_u2d5.write(classWriter.toByteArray());
                            $this$handlerDirInput_u24lambda_u2d6_u24lambda_u2d5.close();
                            break;
                        }
                        if (!((File)changeFile.getKey()).isFile()) break;
                        FileUtils.touch((File)destFile);
                        FileUtils.copyFile((File)((File)changeFile.getKey()), (File)destFile);
                    }
                }
            }
        } else {
            this.handlerFullDirInput(dirInput, outputProvider);
        }
    }

    private final void handlerFullDirInput(DirectoryInput dirInput, TransformOutputProvider outputProvider) {
        if (dirInput.getFile().isDirectory()) {
            boolean index = false;
            FluentIterable fluentIterable = com.android.utils.FileUtils.getAllFiles((File)dirInput.getFile());
            Intrinsics.checkNotNullExpressionValue((Object)fluentIterable, (String)"getAllFiles(dirInput.file)");
            Iterable $this$forEach$iv = (Iterable)fluentIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileOutputStream fileOutputStream;
                File file = (File)element$iv;
                boolean bl = false;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!this.filterFile(string)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                ClassReader classReader = new ClassReader(FilesKt.readBytes((File)file));
                ClassWriter classWriter = new ClassWriter(classReader, 1);
                CommonClassVisitor trackPageClassNode = new CommonClassVisitor(classWriter, classReader);
                classReader.accept((ClassVisitor)trackPageClassNode, 8);
                trackPageClassNode.accept((ClassVisitor)classWriter);
                FileOutputStream $this$handlerFullDirInput_u24lambda_u2d8_u24lambda_u2d7 = fileOutputStream = new FileOutputStream(file.getParentFile().getAbsolutePath() + File.separator + file.getName());
                boolean bl2 = false;
                $this$handlerFullDirInput_u24lambda_u2d8_u24lambda_u2d7.write(classWriter.toByteArray());
                $this$handlerFullDirInput_u24lambda_u2d8_u24lambda_u2d7.close();
            }
        }
        File dest = outputProvider.getContentLocation(dirInput.getName(), dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY);
        FileUtils.copyDirectory((File)dirInput.getFile(), (File)dest);
    }

    private final void disablePlugin(TransformInvocation transformInvocation) {
        Collection collection = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"transformInvocation.inputs");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dest;
            File file;
            TransformInput it = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = it.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"it.directoryInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput dirInput = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                dest = file = transformInvocation.getOutputProvider().getContentLocation(dirInput.getName(), dirInput.getContentTypes(), dirInput.getScopes(), Format.DIRECTORY);
                boolean bl3 = false;
                FileUtils.copyDirectory((File)dirInput.getFile(), (File)dest);
            }
            Collection collection3 = it.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"it.jarInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl4 = false;
                dest = file = transformInvocation.getOutputProvider().getContentLocation(jarInput.getName(), jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                boolean bl5 = false;
                FileUtils.copyFile((File)jarInput.getFile(), (File)dest);
            }
        }
    }

    private final boolean filterFile(String fileName) {
        return StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fileName, (String)"R$", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fileName, (String)"android/support", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fileName, (String)"androidx/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fileName, (String)"com/google", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)fileName, (Object)"R.class") && !Intrinsics.areEqual((Object)fileName, (Object)"R2.class") && !Intrinsics.areEqual((Object)fileName, (Object)"BuildConfig.class");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.NOTCHANGED.ordinal()] = 1;
            nArray[Status.ADDED.ordinal()] = 2;
            nArray[Status.CHANGED.ordinal()] = 3;
            nArray[Status.REMOVED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

