/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api.marker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.marker.Marker;

public final class Polyline
extends Marker {
    private final List<List<Point>> points;

    Polyline(@NonNull List<List<Point>> points) {
        this.points = new ArrayList<List<Point>>(points);
    }

    public @NonNull List<List<Point>> points() {
        return this.points;
    }

    public void points(@NonNull List<Point> points) {
        this.multiPoints(new List[]{Collections.unmodifiableList(new ArrayList<Point>(points))});
    }

    public void points(Point ... points) {
        this.points(Arrays.asList(points));
    }

    public void multiPoints(@NonNull List<List<Point>> points) {
        this.points.clear();
        this.points.addAll(points);
    }

    @SafeVarargs
    public final void multiPoints(List<Point> ... points) {
        this.points.clear();
        this.points.addAll(Arrays.asList(points));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @Nullable Polyline polyline = (Polyline)o;
        return this.markerOptionsMatch(polyline) && this.points.equals(polyline.points);
    }

    public int hashCode() {
        return Objects.hash(this.markerOptions(), this.points);
    }
}

