/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Actual transaction data of multisig transactions")
public class TxData {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private Long gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;

    public TxData from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="594829357172156062717399305168168515568698243350", required=true, description="Multisig account address")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TxData gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", required=true, description="Transaction gas limit")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public TxData gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="25000000000", required=true, description="Transaction gas price")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public TxData input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="208174920243", description="Transaction input data")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public TxData nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="1", required=true, description="Transaction nonce")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public TxData to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="552714228230442729489415054454372803633806727088", description="KLAY receiver's Klaytn account or contract address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TxData typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="16", required=true, description="Type of the transaction")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public TxData value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="333271176265019232529", description="Amount of balance to be sent in the transaction")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxData txData = (TxData)o;
        return Objects.equals(this.from, txData.from) && Objects.equals(this.gas, txData.gas) && Objects.equals(this.gasPrice, txData.gasPrice) && Objects.equals(this.input, txData.input) && Objects.equals(this.nonce, txData.nonce) && Objects.equals(this.to, txData.to) && Objects.equals(this.typeInt, txData.typeInt) && Objects.equals(this.value, txData.value);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.gas, this.gasPrice, this.input, this.nonce, this.to, this.typeInt, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TxData {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

