/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="RLP transaction request schema")
public class ProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="from")
    private String from = null;

    public ProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="36636960834986909204386510951737568209451298378119770790597016664511466577461190413930589496288999826319374740461791822231372202637595742639086952095093389737031470023579927141097357681221099118388772499665655414142573959852689616601441899164751998778484065593064879347521456291611634333214407714696966625362483416395516049474694791866144211154484039417769340169742998414538900490093758082112509854793382124021299263048129379990877749213807740823950506952763192839042789827960499294457336318551062347600514007753988594378432627217013642397645624024768806554141811882571455078518974415562436602085986064269322370181512971854276772608593701906829674790855224580205823641579060580454332587833609311444634603642893866328485754567390776588781613154424727887751408575285264187309917842436618509540318440511673103118851004555483577317289153859498444857529670986659034771768333876404405132346683147010906378759035463622969655537057840806045925588463625550511092958442620784345996731210958832691470281158745901435604944680113313715473822217310131780", required=true, description="The Klaytn RLP formats SigRLP or TxHashRLP are accepted as RLP values and only legacy and basic transactions are allowed.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public ProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public ProcessRLPRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(description="From Klaytn account address. This field is required only when sending legacy transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessRLPRequest processRLPRequest = (ProcessRLPRequest)o;
        return Objects.equals(this.rlp, processRLPRequest.rlp) && Objects.equals(this.submit, processRLPRequest.submit) && Objects.equals(this.from, processRLPRequest.from);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.from);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

