/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Current status of multisig transaction")
public class MultisigTransactionStatus {
    @SerializedName(value="signedWeight")
    private Long signedWeight = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="threshold")
    private Long threshold = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="weight")
    private Long weight = null;
    @SerializedName(value="reminders")
    private List<String> reminders = null;

    public MultisigTransactionStatus signedWeight(Long signedWeight) {
        this.signedWeight = signedWeight;
        return this;
    }

    @Schema(example="4", required=true, description="The threshold of the signatures that the transaction received")
    public Long getSignedWeight() {
        return this.signedWeight;
    }

    public void setSignedWeight(Long signedWeight) {
        this.signedWeight = signedWeight;
    }

    public MultisigTransactionStatus status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Submitted", required=true, description="Current status of the transaction")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public MultisigTransactionStatus threshold(Long threshold) {
        this.threshold = threshold;
        return this;
    }

    @Schema(example="4", required=true, description="Threshold required to send this transaction.")
    public Long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }

    public MultisigTransactionStatus transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="19548504702668825318046347611389508417932250026983132325495191128646072277648", description="Hash value of the transaction")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public MultisigTransactionStatus transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="10286140475633631630575752406078627178715539610517233680909155282838290432890", required=true, description="ID for multisig transaction")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public MultisigTransactionStatus weight(Long weight) {
        this.weight = weight;
        return this;
    }

    @Schema(example="1", required=true, description="Weighted value of the signer")
    public Long getWeight() {
        return this.weight;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }

    public MultisigTransactionStatus reminders(List<String> reminders) {
        this.reminders = reminders;
        return this;
    }

    public MultisigTransactionStatus addRemindersItem(String remindersItem) {
        if (this.reminders == null) {
            this.reminders = new ArrayList<String>();
        }
        this.reminders.add(remindersItem);
        return this;
    }

    @Schema(description="")
    public List<String> getReminders() {
        return this.reminders;
    }

    public void setReminders(List<String> reminders) {
        this.reminders = reminders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigTransactionStatus multisigTransactionStatus = (MultisigTransactionStatus)o;
        return Objects.equals(this.signedWeight, multisigTransactionStatus.signedWeight) && Objects.equals(this.status, multisigTransactionStatus.status) && Objects.equals(this.threshold, multisigTransactionStatus.threshold) && Objects.equals(this.transactionHash, multisigTransactionStatus.transactionHash) && Objects.equals(this.transactionId, multisigTransactionStatus.transactionId) && Objects.equals(this.weight, multisigTransactionStatus.weight) && Objects.equals(this.reminders, multisigTransactionStatus.reminders);
    }

    public int hashCode() {
        return Objects.hash(this.signedWeight, this.status, this.threshold, this.transactionHash, this.transactionId, this.weight, this.reminders);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigTransactionStatus {\n");
        sb.append("    signedWeight: ").append(this.toIndentedString(this.signedWeight)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    threshold: ").append(this.toIndentedString(this.threshold)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    reminders: ").append(this.toIndentedString(this.reminders)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

