/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.ApproveAllKip17Request;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.ApproveKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.BurnKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.GetKip17TokenHistoryResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.GetKip17TokenResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.GetOwnerKip17TokensResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17TokenListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.Kip17TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.MintKip17TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip17.model.TransferKip17TokenRequest;

public class Kip17TokenApi {
    private ApiClient apiClient;

    public Kip17TokenApi() {
        this(Configuration.getDefaultApiClient());
    }

    public Kip17TokenApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call approveAllCall(String xChainId, String contractAddressOrAlias, ApproveAllKip17Request body, String xKrn, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApproveAllKip17Request localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/approveall".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        if (xKrn != null) {
            localVarHeaderParams.put("x-krn", this.apiClient.parameterToString(xKrn));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call approveAllValidateBeforeCall(String xChainId, String contractAddressOrAlias, ApproveAllKip17Request body, String xKrn, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling approveAll(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling approveAll(Async)");
        }
        Call call = this.approveAllCall(xChainId, contractAddressOrAlias, body, xKrn, progressListener, progressRequestListener);
        return call;
    }

    public Kip17TransactionStatusResponse approveAll(String xChainId, String contractAddressOrAlias, ApproveAllKip17Request body, String xKrn) throws ApiException {
        ApiResponse<Kip17TransactionStatusResponse> resp = this.approveAllWithHttpInfo(xChainId, contractAddressOrAlias, body, xKrn);
        return resp.getData();
    }

    public ApiResponse<Kip17TransactionStatusResponse> approveAllWithHttpInfo(String xChainId, String contractAddressOrAlias, ApproveAllKip17Request body, String xKrn) throws ApiException {
        Call call = this.approveAllValidateBeforeCall(xChainId, contractAddressOrAlias, body, xKrn, null, null);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call approveAllAsync(String xChainId, String contractAddressOrAlias, ApproveAllKip17Request body, String xKrn, final ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.approveAllValidateBeforeCall(xChainId, contractAddressOrAlias, body, xKrn, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call approveTokenCall(String xChainId, String contractAddressOrAlias, String tokenId, ApproveKip17TokenRequest body, String xKrn, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApproveKip17TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/approve/{token-id}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        if (xKrn != null) {
            localVarHeaderParams.put("x-krn", this.apiClient.parameterToString(xKrn));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call approveTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, ApproveKip17TokenRequest body, String xKrn, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling approveToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling approveToken(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling approveToken(Async)");
        }
        Call call = this.approveTokenCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, progressListener, progressRequestListener);
        return call;
    }

    public Kip17TransactionStatusResponse approveToken(String xChainId, String contractAddressOrAlias, String tokenId, ApproveKip17TokenRequest body, String xKrn) throws ApiException {
        ApiResponse<Kip17TransactionStatusResponse> resp = this.approveTokenWithHttpInfo(xChainId, contractAddressOrAlias, tokenId, body, xKrn);
        return resp.getData();
    }

    public ApiResponse<Kip17TransactionStatusResponse> approveTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId, ApproveKip17TokenRequest body, String xKrn) throws ApiException {
        Call call = this.approveTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, null, null);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call approveTokenAsync(String xChainId, String contractAddressOrAlias, String tokenId, ApproveKip17TokenRequest body, String xKrn, final ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.approveTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call burnTokenCall(String xChainId, String contractAddressOrAlias, String tokenId, BurnKip17TokenRequest body, String xKrn, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BurnKip17TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/{token-id}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        if (xKrn != null) {
            localVarHeaderParams.put("x-krn", this.apiClient.parameterToString(xKrn));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call burnTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, BurnKip17TokenRequest body, String xKrn, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling burnToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling burnToken(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling burnToken(Async)");
        }
        Call call = this.burnTokenCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, progressListener, progressRequestListener);
        return call;
    }

    public Kip17TransactionStatusResponse burnToken(String xChainId, String contractAddressOrAlias, String tokenId, BurnKip17TokenRequest body, String xKrn) throws ApiException {
        ApiResponse<Kip17TransactionStatusResponse> resp = this.burnTokenWithHttpInfo(xChainId, contractAddressOrAlias, tokenId, body, xKrn);
        return resp.getData();
    }

    public ApiResponse<Kip17TransactionStatusResponse> burnTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId, BurnKip17TokenRequest body, String xKrn) throws ApiException {
        Call call = this.burnTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, null, null);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call burnTokenAsync(String xChainId, String contractAddressOrAlias, String tokenId, BurnKip17TokenRequest body, String xKrn, final ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.burnTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOwnerTokensCall(String xChainId, String contractAddressOrAlias, String ownerAddress, Long size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/owner/{owner-address}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{owner-address\\}", this.apiClient.escapeString(ownerAddress.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOwnerTokensValidateBeforeCall(String xChainId, String contractAddressOrAlias, String ownerAddress, Long size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getOwnerTokens(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getOwnerTokens(Async)");
        }
        if (ownerAddress == null) {
            throw new ApiException("Missing the required parameter 'ownerAddress' when calling getOwnerTokens(Async)");
        }
        Call call = this.getOwnerTokensCall(xChainId, contractAddressOrAlias, ownerAddress, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public GetOwnerKip17TokensResponse getOwnerTokens(String xChainId, String contractAddressOrAlias, String ownerAddress, Long size, String cursor) throws ApiException {
        ApiResponse<GetOwnerKip17TokensResponse> resp = this.getOwnerTokensWithHttpInfo(xChainId, contractAddressOrAlias, ownerAddress, size, cursor);
        return resp.getData();
    }

    public ApiResponse<GetOwnerKip17TokensResponse> getOwnerTokensWithHttpInfo(String xChainId, String contractAddressOrAlias, String ownerAddress, Long size, String cursor) throws ApiException {
        Call call = this.getOwnerTokensValidateBeforeCall(xChainId, contractAddressOrAlias, ownerAddress, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<GetOwnerKip17TokensResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOwnerTokensAsync(String xChainId, String contractAddressOrAlias, String ownerAddress, Long size, String cursor, final ApiCallback<GetOwnerKip17TokensResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOwnerTokensValidateBeforeCall(xChainId, contractAddressOrAlias, ownerAddress, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetOwnerKip17TokensResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenCall(String xChainId, String contractAddressOrAlias, String tokenId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/{token-id}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getToken(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling getToken(Async)");
        }
        Call call = this.getTokenCall(xChainId, contractAddressOrAlias, tokenId, progressListener, progressRequestListener);
        return call;
    }

    public GetKip17TokenResponse getToken(String xChainId, String contractAddressOrAlias, String tokenId) throws ApiException {
        ApiResponse<GetKip17TokenResponse> resp = this.getTokenWithHttpInfo(xChainId, contractAddressOrAlias, tokenId);
        return resp.getData();
    }

    public ApiResponse<GetKip17TokenResponse> getTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId) throws ApiException {
        Call call = this.getTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, null, null);
        Type localVarReturnType = new TypeToken<GetKip17TokenResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenAsync(String xChainId, String contractAddressOrAlias, String tokenId, final ApiCallback<GetKip17TokenResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetKip17TokenResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokenHistoryCall(String xChainId, String contractAddressOrAlias, String tokenId, Long size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/{token-id}/history".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenHistoryValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, Long size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTokenHistory(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getTokenHistory(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling getTokenHistory(Async)");
        }
        Call call = this.getTokenHistoryCall(xChainId, contractAddressOrAlias, tokenId, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public GetKip17TokenHistoryResponse getTokenHistory(String xChainId, String contractAddressOrAlias, String tokenId, Long size, String cursor) throws ApiException {
        ApiResponse<GetKip17TokenHistoryResponse> resp = this.getTokenHistoryWithHttpInfo(xChainId, contractAddressOrAlias, tokenId, size, cursor);
        return resp.getData();
    }

    public ApiResponse<GetKip17TokenHistoryResponse> getTokenHistoryWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId, Long size, String cursor) throws ApiException {
        Call call = this.getTokenHistoryValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<GetKip17TokenHistoryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenHistoryAsync(String xChainId, String contractAddressOrAlias, String tokenId, Long size, String cursor, final ApiCallback<GetKip17TokenHistoryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenHistoryValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetKip17TokenHistoryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listTokensCall(String xChainId, String contractAddressOrAlias, Long size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listTokensValidateBeforeCall(String xChainId, String contractAddressOrAlias, Long size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling listTokens(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling listTokens(Async)");
        }
        Call call = this.listTokensCall(xChainId, contractAddressOrAlias, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public Kip17TokenListResponse listTokens(String xChainId, String contractAddressOrAlias, Long size, String cursor) throws ApiException {
        ApiResponse<Kip17TokenListResponse> resp = this.listTokensWithHttpInfo(xChainId, contractAddressOrAlias, size, cursor);
        return resp.getData();
    }

    public ApiResponse<Kip17TokenListResponse> listTokensWithHttpInfo(String xChainId, String contractAddressOrAlias, Long size, String cursor) throws ApiException {
        Call call = this.listTokensValidateBeforeCall(xChainId, contractAddressOrAlias, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<Kip17TokenListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listTokensAsync(String xChainId, String contractAddressOrAlias, Long size, String cursor, final ApiCallback<Kip17TokenListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listTokensValidateBeforeCall(xChainId, contractAddressOrAlias, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17TokenListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call mintTokenCall(String xChainId, String contractAddressOrAlias, MintKip17TokenRequest body, String xKrn, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MintKip17TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        if (xKrn != null) {
            localVarHeaderParams.put("x-krn", this.apiClient.parameterToString(xKrn));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call mintTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, MintKip17TokenRequest body, String xKrn, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling mintToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling mintToken(Async)");
        }
        Call call = this.mintTokenCall(xChainId, contractAddressOrAlias, body, xKrn, progressListener, progressRequestListener);
        return call;
    }

    public Kip17TransactionStatusResponse mintToken(String xChainId, String contractAddressOrAlias, MintKip17TokenRequest body, String xKrn) throws ApiException {
        ApiResponse<Kip17TransactionStatusResponse> resp = this.mintTokenWithHttpInfo(xChainId, contractAddressOrAlias, body, xKrn);
        return resp.getData();
    }

    public ApiResponse<Kip17TransactionStatusResponse> mintTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, MintKip17TokenRequest body, String xKrn) throws ApiException {
        Call call = this.mintTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, xKrn, null, null);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call mintTokenAsync(String xChainId, String contractAddressOrAlias, MintKip17TokenRequest body, String xKrn, final ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mintTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, xKrn, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transferTokenCall(String xChainId, String contractAddressOrAlias, String tokenId, TransferKip17TokenRequest body, String xKrn, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TransferKip17TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/{token-id}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        if (xKrn != null) {
            localVarHeaderParams.put("x-krn", this.apiClient.parameterToString(xKrn));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transferTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, TransferKip17TokenRequest body, String xKrn, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling transferToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling transferToken(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling transferToken(Async)");
        }
        Call call = this.transferTokenCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, progressListener, progressRequestListener);
        return call;
    }

    public Kip17TransactionStatusResponse transferToken(String xChainId, String contractAddressOrAlias, String tokenId, TransferKip17TokenRequest body, String xKrn) throws ApiException {
        ApiResponse<Kip17TransactionStatusResponse> resp = this.transferTokenWithHttpInfo(xChainId, contractAddressOrAlias, tokenId, body, xKrn);
        return resp.getData();
    }

    public ApiResponse<Kip17TransactionStatusResponse> transferTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId, TransferKip17TokenRequest body, String xKrn) throws ApiException {
        Call call = this.transferTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, null, null);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transferTokenAsync(String xChainId, String contractAddressOrAlias, String tokenId, TransferKip17TokenRequest body, String xKrn, final ApiCallback<Kip17TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transferTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, xKrn, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip17TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

