/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class Transaction {
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Integer feeRatio = null;
    @SerializedName(value="fee")
    private String fee = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="timestamp")
    private Long timestamp = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="blockNumber")
    private Long blockNumber = null;
    @SerializedName(value="typeInt")
    private Integer typeInt = null;
    @SerializedName(value="value")
    private String value = null;

    public Transaction feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="1192693860661700396879673921856029630237486527498", required=true, description="Fee delegation account address (20-byte)")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public Transaction feeRatio(Integer feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="100", required=true, description="Fee delegation ratio")
    public Integer getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Integer feeRatio) {
        this.feeRatio = feeRatio;
    }

    public Transaction fee(String fee) {
        this.fee = fee;
        return this;
    }

    @Schema(example="42069", required=true, description="Gas fee")
    public String getFee() {
        return this.fee;
    }

    public void setFee(String fee) {
        this.fee = fee;
    }

    public Transaction from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="538243955260495079143208573429421427237585534683", required=true, description="EOA of the sender of transaction (20-byte)")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Transaction timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Schema(example="1592180992", required=true, description="Time of transaction (timestamp)")
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Transaction transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="88941640552803633154072611475047379401865108829661485995735632343373081359608", required=true, description="Transaction hash (32-byte)")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public Transaction blockNumber(Long blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    @Schema(example="5312105", required=true, description="Number of the block with the transaction")
    public Long getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(Long blockNumber) {
        this.blockNumber = blockNumber;
    }

    public Transaction typeInt(Integer typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="10", required=true, description="Transaction type")
    public Integer getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Integer typeInt) {
        this.typeInt = typeInt;
    }

    public Transaction value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="10", required=true, description="Amount of KLAY transferred (in hexadecimal)")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.feePayer, transaction.feePayer) && Objects.equals(this.feeRatio, transaction.feeRatio) && Objects.equals(this.fee, transaction.fee) && Objects.equals(this.from, transaction.from) && Objects.equals(this.timestamp, transaction.timestamp) && Objects.equals(this.transactionHash, transaction.transactionHash) && Objects.equals(this.blockNumber, transaction.blockNumber) && Objects.equals(this.typeInt, transaction.typeInt) && Objects.equals(this.value, transaction.value);
    }

    public int hashCode() {
        return Objects.hash(this.feePayer, this.feeRatio, this.fee, this.from, this.timestamp, this.transactionHash, this.blockNumber, this.typeInt, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    blockNumber: ").append(this.toIndentedString(this.blockNumber)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

