/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class TransferKip7TokenFromRequest {
    @SerializedName(value="spender")
    private String spender = null;
    @SerializedName(value="owner")
    private String owner = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="amount")
    private String amount = null;

    public TransferKip7TokenFromRequest spender(String spender) {
        this.spender = spender;
        return this;
    }

    @Schema(example="1224943311509860752118718913702900079034625498283", required=true, description="The Klaytn account address to send tokens on behalf of the `owner`.")
    public String getSpender() {
        return this.spender;
    }

    public void setSpender(String spender) {
        this.spender = spender;
    }

    public TransferKip7TokenFromRequest owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Schema(example="175224902929872758239811531255736711146941009517", required=true, description="The Klaytn account address of the owner granting the authority to send tokens on his or her behalf.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TransferKip7TokenFromRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="361035695825504109740984612991529297972311119991", required=true, description="Klaytn account address to receive tokens")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TransferKip7TokenFromRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Schema(example="80", required=true, description="Transfer amount (in hex.)")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferKip7TokenFromRequest transferKip7TokenFromRequest = (TransferKip7TokenFromRequest)o;
        return Objects.equals(this.spender, transferKip7TokenFromRequest.spender) && Objects.equals(this.owner, transferKip7TokenFromRequest.owner) && Objects.equals(this.to, transferKip7TokenFromRequest.to) && Objects.equals(this.amount, transferKip7TokenFromRequest.amount);
    }

    public int hashCode() {
        return Objects.hash(this.spender, this.owner, this.to, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferKip7TokenFromRequest {\n");
        sb.append("    spender: ").append(this.toIndentedString(this.spender)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

