/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.BurnKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.CreateKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37TokenInfoListResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.Kip37TransactionStatusResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.MintKip37TokenRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.OperateKip37ContractRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model.TransferKip37TokenRequest;

public class Kip37TokenApi {
    private ApiClient apiClient;

    public Kip37TokenApi() {
        this(Configuration.getDefaultApiClient());
    }

    public Kip37TokenApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call burnTokenCall(String xChainId, String contractAddressOrAlias, BurnKip37TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BurnKip37TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call burnTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, BurnKip37TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling burnToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling burnToken(Async)");
        }
        Call call = this.burnTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TransactionStatusResponse burnToken(String xChainId, String contractAddressOrAlias, BurnKip37TokenRequest body) throws ApiException {
        ApiResponse<Kip37TransactionStatusResponse> resp = this.burnTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip37TransactionStatusResponse> burnTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, BurnKip37TokenRequest body) throws ApiException {
        Call call = this.burnTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call burnTokenAsync(String xChainId, String contractAddressOrAlias, BurnKip37TokenRequest body, final ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.burnTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createTokenCall(String xChainId, String contractAddressOrAlias, CreateKip37TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateKip37TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, CreateKip37TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling createToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling createToken(Async)");
        }
        Call call = this.createTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TransactionStatusResponse createToken(String xChainId, String contractAddressOrAlias, CreateKip37TokenRequest body) throws ApiException {
        ApiResponse<Kip37TransactionStatusResponse> resp = this.createTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip37TransactionStatusResponse> createTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, CreateKip37TokenRequest body) throws ApiException {
        Call call = this.createTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createTokenAsync(String xChainId, String contractAddressOrAlias, CreateKip37TokenRequest body, final ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTokensCall(String contractAddressOrAlias, String xChainId, Integer size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokensValidateBeforeCall(String contractAddressOrAlias, String xChainId, Integer size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling getTokens(Async)");
        }
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTokens(Async)");
        }
        Call call = this.getTokensCall(contractAddressOrAlias, xChainId, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TokenInfoListResponse getTokens(String contractAddressOrAlias, String xChainId, Integer size, String cursor) throws ApiException {
        ApiResponse<Kip37TokenInfoListResponse> resp = this.getTokensWithHttpInfo(contractAddressOrAlias, xChainId, size, cursor);
        return resp.getData();
    }

    public ApiResponse<Kip37TokenInfoListResponse> getTokensWithHttpInfo(String contractAddressOrAlias, String xChainId, Integer size, String cursor) throws ApiException {
        Call call = this.getTokensValidateBeforeCall(contractAddressOrAlias, xChainId, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<Kip37TokenInfoListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokensAsync(String contractAddressOrAlias, String xChainId, Integer size, String cursor, final ApiCallback<Kip37TokenInfoListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokensValidateBeforeCall(contractAddressOrAlias, xChainId, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TokenInfoListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call mintTokenCall(String xChainId, String contractAddressOrAlias, MintKip37TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        MintKip37TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/mint".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call mintTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, MintKip37TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling mintToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling mintToken(Async)");
        }
        Call call = this.mintTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TransactionStatusResponse mintToken(String xChainId, String contractAddressOrAlias, MintKip37TokenRequest body) throws ApiException {
        ApiResponse<Kip37TransactionStatusResponse> resp = this.mintTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip37TransactionStatusResponse> mintTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, MintKip37TokenRequest body) throws ApiException {
        Call call = this.mintTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call mintTokenAsync(String xChainId, String contractAddressOrAlias, MintKip37TokenRequest body, final ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mintTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call pauseTokenCall(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OperateKip37ContractRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/pause/{token-id}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call pauseTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling pauseToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling pauseToken(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling pauseToken(Async)");
        }
        Call call = this.pauseTokenCall(xChainId, contractAddressOrAlias, tokenId, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TransactionStatusResponse pauseToken(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body) throws ApiException {
        ApiResponse<Kip37TransactionStatusResponse> resp = this.pauseTokenWithHttpInfo(xChainId, contractAddressOrAlias, tokenId, body);
        return resp.getData();
    }

    public ApiResponse<Kip37TransactionStatusResponse> pauseTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body) throws ApiException {
        Call call = this.pauseTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, null, null);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call pauseTokenAsync(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body, final ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.pauseTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call transferTokenCall(String xChainId, String contractAddressOrAlias, TransferKip37TokenRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        TransferKip37TokenRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/transfer".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call transferTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, TransferKip37TokenRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling transferToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling transferToken(Async)");
        }
        Call call = this.transferTokenCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TransactionStatusResponse transferToken(String xChainId, String contractAddressOrAlias, TransferKip37TokenRequest body) throws ApiException {
        ApiResponse<Kip37TransactionStatusResponse> resp = this.transferTokenWithHttpInfo(xChainId, contractAddressOrAlias, body);
        return resp.getData();
    }

    public ApiResponse<Kip37TransactionStatusResponse> transferTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, TransferKip37TokenRequest body) throws ApiException {
        Call call = this.transferTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, null, null);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call transferTokenAsync(String xChainId, String contractAddressOrAlias, TransferKip37TokenRequest body, final ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.transferTokenValidateBeforeCall(xChainId, contractAddressOrAlias, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call unpauseTokenCall(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OperateKip37ContractRequest localVarPostBody = body;
        String localVarPath = "/v1/contract/{contract-address-or-alias}/token/unpause/{token-id}".replaceAll("\\{contract-address-or-alias\\}", this.apiClient.escapeString(contractAddressOrAlias.toString())).replaceAll("\\{token-id\\}", this.apiClient.escapeString(tokenId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call unpauseTokenValidateBeforeCall(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling unpauseToken(Async)");
        }
        if (contractAddressOrAlias == null) {
            throw new ApiException("Missing the required parameter 'contractAddressOrAlias' when calling unpauseToken(Async)");
        }
        if (tokenId == null) {
            throw new ApiException("Missing the required parameter 'tokenId' when calling unpauseToken(Async)");
        }
        Call call = this.unpauseTokenCall(xChainId, contractAddressOrAlias, tokenId, body, progressListener, progressRequestListener);
        return call;
    }

    public Kip37TransactionStatusResponse unpauseToken(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body) throws ApiException {
        ApiResponse<Kip37TransactionStatusResponse> resp = this.unpauseTokenWithHttpInfo(xChainId, contractAddressOrAlias, tokenId, body);
        return resp.getData();
    }

    public ApiResponse<Kip37TransactionStatusResponse> unpauseTokenWithHttpInfo(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body) throws ApiException {
        Call call = this.unpauseTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, null, null);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call unpauseTokenAsync(String xChainId, String contractAddressOrAlias, String tokenId, OperateKip37ContractRequest body, final ApiCallback<Kip37TransactionStatusResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.unpauseTokenValidateBeforeCall(xChainId, contractAddressOrAlias, tokenId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Kip37TransactionStatusResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

