/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip7.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class TransferKip7TokenRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="amount")
    private String amount = null;

    public TransferKip7TokenRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0xd6905b98E4Ba43a24E842d2b66c1410173791cab", description="Klaytn account address to send tokens. The default value is the contract deployer account.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TransferKip7TokenRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0xaddbf9cbfd30768202b70b5504c012fbdf00b8d8", required=true, description="Klaytn account address to receive tokens")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TransferKip7TokenRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Schema(example="0x50", required=true, description="The amount of tokens to transfer (in hexadecimal)")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferKip7TokenRequest transferKip7TokenRequest = (TransferKip7TokenRequest)o;
        return Objects.equals(this.from, transferKip7TokenRequest.from) && Objects.equals(this.to, transferKip7TokenRequest.to) && Objects.equals(this.amount, transferKip7TokenRequest.amount);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferKip7TokenRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

