/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.wallet;

import com.klaytn.caver.account.AccountKeyRoleBased;
import com.klaytn.caver.account.AccountKeyWeightedMultiSig;
import com.klaytn.caver.methods.response.AccountKey;
import com.klaytn.caver.transaction.AbstractFeeDelegatedTransaction;
import com.klaytn.caver.transaction.AbstractFeeDelegatedWithRatioTransaction;
import com.klaytn.caver.transaction.AbstractTransaction;
import com.klaytn.caver.transaction.TransactionDecoder;
import com.klaytn.caver.transaction.type.AccountUpdate;
import com.klaytn.caver.transaction.type.LegacyTransaction;
import com.klaytn.caver.wallet.IWallet;
import com.klaytn.caver.wallet.keyring.SignatureData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import xyz.groundx.caver_ext_kas.exception.KASAPIException;
import xyz.groundx.caver_ext_kas.kas.wallet.Wallet;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Account;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountStatus;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountSummary;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDProcessRLPRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDTransactionResult;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FDUserProcessRLPRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ProcessRLPRequest;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.TransactionResult;

public class KASWallet
implements IWallet {
    Wallet walletAPI;

    public KASWallet(Wallet walletAPI) {
        this.walletAPI = walletAPI;
    }

    public List<String> generate(int num) throws KASAPIException {
        try {
            ArrayList<String> addressList = new ArrayList<String>();
            for (int i = 0; i < num; ++i) {
                Account account = this.walletAPI.createAccount();
                addressList.add(account.getAddress());
            }
            return addressList;
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    public Account getAccount(String address) throws KASAPIException {
        try {
            return this.walletAPI.getAccount(address);
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    public boolean remove(String address) {
        try {
            AccountStatus status = this.walletAPI.deleteAccount(address);
            return status.getStatus().equals("deleted");
        }
        catch (ApiException e) {
            return false;
        }
    }

    public boolean isExisted(String address) {
        try {
            Account account = this.getAccount(address);
            return true;
        }
        catch (KASAPIException e) {
            return false;
        }
    }

    public AccountSummary enableAccount(String address) throws KASAPIException {
        try {
            return this.walletAPI.enableAccount(address);
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    public AccountSummary disableAccount(String address) throws KASAPIException {
        try {
            return this.walletAPI.disableAccount(address);
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    public AbstractTransaction sign(String address, AbstractTransaction transaction) throws IOException, KASAPIException {
        if (transaction.getFrom().equals("0x")) {
            transaction.setFrom(address);
        }
        if (!transaction.getFrom().toLowerCase().equals(address.toLowerCase())) {
            throw new IllegalArgumentException("From address are not matched");
        }
        if (this.isWeightedMultiSigType(transaction, address)) {
            throw new IllegalArgumentException("Not supported: Using multiple keys in an account is currently not supported.");
        }
        List<SignatureData> signatureData = this.makeSignature(transaction);
        transaction.appendSignatures(signatureData);
        return transaction;
    }

    public AbstractFeeDelegatedTransaction signAsGlobalFeePayer(AbstractFeeDelegatedTransaction feeDelegatedTransaction) throws IOException, KASAPIException {
        try {
            feeDelegatedTransaction.fillTransaction();
            String rlp = feeDelegatedTransaction.getRLPEncoding();
            FDProcessRLPRequest rlpRequest = new FDProcessRLPRequest();
            rlpRequest.setRlp(rlp);
            rlpRequest.setSubmit(false);
            if (feeDelegatedTransaction instanceof AbstractFeeDelegatedWithRatioTransaction) {
                rlpRequest.setFeeRatio(((AbstractFeeDelegatedWithRatioTransaction)feeDelegatedTransaction).getFeeRatioInteger().longValue());
            }
            FDTransactionResult result = this.walletAPI.requestFDRawTransactionPaidByGlobalFeePayer(rlpRequest);
            AbstractFeeDelegatedTransaction tx = (AbstractFeeDelegatedTransaction)TransactionDecoder.decode((String)result.getRlp());
            String existFeePayer = feeDelegatedTransaction.getFeePayer();
            if (!(existFeePayer.equals("0x") || existFeePayer.equals("0x0000000000000000000000000000000000000000") || existFeePayer.toLowerCase().equals(tx.getFeePayer().toLowerCase()))) {
                throw new RuntimeException("Invalid fee payer: The address of the fee payer defined in the transaction does not match the address of the global fee payer. To sign with a global fee payer, you must define the global fee payer's address in the feePayer field, or the feePayer field must not be defined.");
            }
            feeDelegatedTransaction.setFeePayer(tx.getFeePayer());
            feeDelegatedTransaction.appendFeePayerSignatures(tx.getFeePayerSignatures());
            return feeDelegatedTransaction;
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    public AbstractFeeDelegatedTransaction signAsFeePayer(String feePayerAddress, AbstractFeeDelegatedTransaction feeDelegatedTransaction) throws IOException, KASAPIException {
        try {
            if (feePayerAddress == null) {
                return this.signAsGlobalFeePayer(feeDelegatedTransaction);
            }
            if (feeDelegatedTransaction.getFeePayer().equals("0x") || feeDelegatedTransaction.getFeePayer().equals("0x0000000000000000000000000000000000000000")) {
                feeDelegatedTransaction.setFeePayer(feePayerAddress);
            }
            if (!feeDelegatedTransaction.getFeePayer().toLowerCase().equals(feePayerAddress.toLowerCase())) {
                throw new IllegalArgumentException("Fee payer address are not matched");
            }
            if (this.isWeightedMultiSigType(feeDelegatedTransaction, feePayerAddress)) {
                throw new IllegalArgumentException("Not supported: Using multiple keys in an account is currently not supported.");
            }
            feeDelegatedTransaction.fillTransaction();
            String rlp = feeDelegatedTransaction.getRLPEncoding();
            FDUserProcessRLPRequest rlpRequest = new FDUserProcessRLPRequest();
            rlpRequest.setRlp(rlp);
            rlpRequest.setFeePayer(feeDelegatedTransaction.getFeePayer());
            rlpRequest.setSubmit(false);
            if (feeDelegatedTransaction instanceof AbstractFeeDelegatedWithRatioTransaction) {
                rlpRequest.setFeeRatio(((AbstractFeeDelegatedWithRatioTransaction)feeDelegatedTransaction).getFeeRatioInteger().longValue());
            }
            FDTransactionResult result = this.walletAPI.requestFDRawTransactionPaidByUser(rlpRequest);
            AbstractFeeDelegatedTransaction tx = (AbstractFeeDelegatedTransaction)TransactionDecoder.decode((String)result.getRlp());
            feeDelegatedTransaction.appendFeePayerSignatures(tx.getFeePayerSignatures());
            return feeDelegatedTransaction;
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    public Wallet getWalletAPI() {
        return this.walletAPI;
    }

    public void setWalletAPI(Wallet walletAPI) {
        this.walletAPI = walletAPI;
    }

    private boolean isWeightedMultiSigType(AbstractTransaction transaction, String address) throws IOException {
        AccountKey res = (AccountKey)transaction.getKlaytnCall().getAccountKey(address).send();
        if (res == null) {
            return false;
        }
        AccountKey.AccountKeyData accountKeyData = (AccountKey.AccountKeyData)res.getResult();
        String type = accountKeyData.getType();
        if (type.equals(AccountKeyWeightedMultiSig.getType())) {
            return true;
        }
        if (type.equals(AccountKeyRoleBased.getType())) {
            AccountKeyRoleBased roleBased = (AccountKeyRoleBased)accountKeyData.getAccountKey();
            if (transaction instanceof AccountUpdate ? roleBased.getRoleAccountUpdateKey() instanceof AccountKeyWeightedMultiSig : roleBased.getRoleTransactionKey() instanceof AccountKeyWeightedMultiSig) {
                return true;
            }
        }
        return false;
    }

    private boolean isWeightedMultiSigType(AbstractFeeDelegatedTransaction fdTransaction, String address) throws IOException {
        AccountKeyRoleBased roleBased;
        AccountKey res = (AccountKey)fdTransaction.getKlaytnCall().getAccountKey(address).send();
        if (res == null) {
            return true;
        }
        AccountKey.AccountKeyData accountKeyData = (AccountKey.AccountKeyData)res.getResult();
        String type = accountKeyData.getType();
        if (type.equals(AccountKeyWeightedMultiSig.getType())) {
            return true;
        }
        return type.equals(AccountKeyRoleBased.getType()) && (roleBased = (AccountKeyRoleBased)accountKeyData.getAccountKey()).getRoleFeePayerKey() instanceof AccountKeyWeightedMultiSig;
    }

    private List<SignatureData> makeSignature(AbstractTransaction transaction) throws IOException {
        try {
            if (transaction instanceof AbstractFeeDelegatedTransaction) {
                return this.makeSignature((AbstractFeeDelegatedTransaction)transaction);
            }
            transaction.fillTransaction();
            ProcessRLPRequest request = new ProcessRLPRequest();
            if (transaction instanceof LegacyTransaction) {
                request.setFrom(transaction.getFrom());
            }
            request.setRlp(transaction.getRLPEncoding());
            request.setSubmit(false);
            TransactionResult result = this.walletAPI.requestRawTransaction(request);
            return this.convertSignatureData(result.getSignatures());
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    private List<SignatureData> makeSignature(AbstractFeeDelegatedTransaction transaction) throws IOException, KASAPIException {
        try {
            transaction.fillTransaction();
            FDProcessRLPRequest request = new FDProcessRLPRequest();
            if (transaction instanceof AbstractFeeDelegatedWithRatioTransaction) {
                request.setFeeRatio(((AbstractFeeDelegatedWithRatioTransaction)transaction).getFeeRatioInteger().longValue());
            }
            request.setRlp(transaction.getRLPEncoding());
            request.setSubmit(false);
            FDTransactionResult result = this.walletAPI.requestFDRawTransactionPaidByGlobalFeePayer(request);
            return this.convertSignatureData(result.getSignatures());
        }
        catch (ApiException e) {
            throw new KASAPIException(e);
        }
    }

    private List<SignatureData> convertSignatureData(List<Signature> signatureList) {
        return signatureList.stream().map(signature -> new SignatureData(signature.getV(), signature.getR(), signature.getS())).collect(Collectors.toList());
    }
}

