/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiCallback;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiException;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiResponse;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Configuration;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.Pair;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressRequestBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ProgressResponseBody;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.PageableTransfers;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.tokenhistory.model.Transfers;

public class TokenHistoryApi {
    private ApiClient apiClient;

    public TokenHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenHistoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getTransfersCall(String xChainId, String presets, String kind, String range, Long size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/transfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (kind != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("kind", kind));
        }
        if (range != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("range", range));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        if (presets != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("presets", presets));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransfersValidateBeforeCall(String xChainId, String presets, String kind, String range, Long size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTransfers(Async)");
        }
        if (presets == null) {
            throw new ApiException("Missing the required parameter 'presets' when calling getTransfers(Async)");
        }
        Call call = this.getTransfersCall(xChainId, presets, kind, range, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public PageableTransfers getTransfers(String xChainId, String presets, String kind, String range, Long size, String cursor) throws ApiException {
        ApiResponse<PageableTransfers> resp = this.getTransfersWithHttpInfo(xChainId, presets, kind, range, size, cursor);
        return resp.getData();
    }

    public ApiResponse<PageableTransfers> getTransfersWithHttpInfo(String xChainId, String presets, String kind, String range, Long size, String cursor) throws ApiException {
        Call call = this.getTransfersValidateBeforeCall(xChainId, presets, kind, range, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<PageableTransfers>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransfersAsync(String xChainId, String presets, String kind, String range, Long size, String cursor, final ApiCallback<PageableTransfers> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransfersValidateBeforeCall(xChainId, presets, kind, range, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableTransfers>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransfersByEoaCall(String xChainId, String address, String kind, String caFilter, String range, Long size, String cursor, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/transfer/account/{address}".replaceAll("\\{address\\}", this.apiClient.escapeString(address.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (kind != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("kind", kind));
        }
        if (caFilter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("ca-filter", caFilter));
        }
        if (range != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("range", range));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (cursor != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("cursor", cursor));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransfersByEoaValidateBeforeCall(String xChainId, String address, String kind, String caFilter, String range, Long size, String cursor, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTransfersByEoa(Async)");
        }
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling getTransfersByEoa(Async)");
        }
        Call call = this.getTransfersByEoaCall(xChainId, address, kind, caFilter, range, size, cursor, progressListener, progressRequestListener);
        return call;
    }

    public PageableTransfers getTransfersByEoa(String xChainId, String address, String kind, String caFilter, String range, Long size, String cursor) throws ApiException {
        ApiResponse<PageableTransfers> resp = this.getTransfersByEoaWithHttpInfo(xChainId, address, kind, caFilter, range, size, cursor);
        return resp.getData();
    }

    public ApiResponse<PageableTransfers> getTransfersByEoaWithHttpInfo(String xChainId, String address, String kind, String caFilter, String range, Long size, String cursor) throws ApiException {
        Call call = this.getTransfersByEoaValidateBeforeCall(xChainId, address, kind, caFilter, range, size, cursor, null, null);
        Type localVarReturnType = new TypeToken<PageableTransfers>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransfersByEoaAsync(String xChainId, String address, String kind, String caFilter, String range, Long size, String cursor, final ApiCallback<PageableTransfers> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransfersByEoaValidateBeforeCall(xChainId, address, kind, caFilter, range, size, cursor, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PageableTransfers>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransfersByTxHashCall(String xChainId, String transactionHash, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/transfer/tx/{transaction-hash}".replaceAll("\\{transaction-hash\\}", this.apiClient.escapeString(transactionHash.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xChainId != null) {
            localVarHeaderParams.put("x-chain-id", this.apiClient.parameterToString(xChainId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransfersByTxHashValidateBeforeCall(String xChainId, String transactionHash, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xChainId == null) {
            throw new ApiException("Missing the required parameter 'xChainId' when calling getTransfersByTxHash(Async)");
        }
        if (transactionHash == null) {
            throw new ApiException("Missing the required parameter 'transactionHash' when calling getTransfersByTxHash(Async)");
        }
        Call call = this.getTransfersByTxHashCall(xChainId, transactionHash, progressListener, progressRequestListener);
        return call;
    }

    public Transfers getTransfersByTxHash(String xChainId, String transactionHash) throws ApiException {
        ApiResponse<Transfers> resp = this.getTransfersByTxHashWithHttpInfo(xChainId, transactionHash);
        return resp.getData();
    }

    public ApiResponse<Transfers> getTransfersByTxHashWithHttpInfo(String xChainId, String transactionHash) throws ApiException {
        Call call = this.getTransfersByTxHashValidateBeforeCall(xChainId, transactionHash, null, null);
        Type localVarReturnType = new TypeToken<Transfers>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransfersByTxHashAsync(String xChainId, String transactionHash, final ApiCallback<Transfers> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransfersByTxHashValidateBeforeCall(xChainId, transactionHash, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Transfers>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

