/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.controller;

import android.app.Activity;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import xyz.doikki.videoplayer.controller.IVideoController;
import xyz.doikki.videoplayer.controller.MediaPlayerControl;

public class ControlWrapper
implements MediaPlayerControl,
IVideoController {
    private final MediaPlayerControl mPlayerControl;
    private final IVideoController mController;

    public ControlWrapper(@NonNull MediaPlayerControl playerControl, @NonNull IVideoController controller) {
        this.mPlayerControl = playerControl;
        this.mController = controller;
    }

    @Override
    public void start() {
        this.mPlayerControl.start();
    }

    @Override
    public void pause() {
        this.mPlayerControl.pause();
    }

    @Override
    public long getDuration() {
        return this.mPlayerControl.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.mPlayerControl.getCurrentPosition();
    }

    @Override
    public void seekTo(long pos) {
        this.mPlayerControl.seekTo(pos);
    }

    @Override
    public boolean isPlaying() {
        return this.mPlayerControl.isPlaying();
    }

    @Override
    public int getBufferedPercentage() {
        return this.mPlayerControl.getBufferedPercentage();
    }

    @Override
    public void startFullScreen() {
        this.mPlayerControl.startFullScreen();
    }

    @Override
    public void stopFullScreen() {
        this.mPlayerControl.stopFullScreen();
    }

    @Override
    public boolean isFullScreen() {
        return this.mPlayerControl.isFullScreen();
    }

    @Override
    public void setMute(boolean isMute) {
        this.mPlayerControl.setMute(isMute);
    }

    @Override
    public boolean isMute() {
        return this.mPlayerControl.isMute();
    }

    @Override
    public void setScreenScaleType(int screenScaleType) {
        this.mPlayerControl.setScreenScaleType(screenScaleType);
    }

    @Override
    public void setSpeed(float speed) {
        this.mPlayerControl.setSpeed(speed);
    }

    @Override
    public float getSpeed() {
        return this.mPlayerControl.getSpeed();
    }

    @Override
    public long getTcpSpeed() {
        return this.mPlayerControl.getTcpSpeed();
    }

    @Override
    public void replay(boolean resetPosition) {
        this.mPlayerControl.replay(resetPosition);
    }

    @Override
    public void setMirrorRotation(boolean enable) {
        this.mPlayerControl.setMirrorRotation(enable);
    }

    @Override
    public Bitmap doScreenShot() {
        return this.mPlayerControl.doScreenShot();
    }

    @Override
    public int[] getVideoSize() {
        return this.mPlayerControl.getVideoSize();
    }

    @Override
    public void setRotation(float rotation) {
        this.mPlayerControl.setRotation(rotation);
    }

    @Override
    public void startTinyScreen() {
        this.mPlayerControl.startTinyScreen();
    }

    @Override
    public void stopTinyScreen() {
        this.mPlayerControl.stopTinyScreen();
    }

    @Override
    public boolean isTinyScreen() {
        return this.mPlayerControl.isTinyScreen();
    }

    public void togglePlay() {
        if (this.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    public void toggleFullScreen(Activity activity) {
        if (activity == null || activity.isFinishing()) {
            return;
        }
        if (this.isFullScreen()) {
            activity.setRequestedOrientation(1);
            this.stopFullScreen();
        } else {
            activity.setRequestedOrientation(0);
            this.startFullScreen();
        }
    }

    public void toggleFullScreen() {
        if (this.isFullScreen()) {
            this.stopFullScreen();
        } else {
            this.startFullScreen();
        }
    }

    public void toggleFullScreenByVideoSize(Activity activity) {
        if (activity == null || activity.isFinishing()) {
            return;
        }
        int[] size = this.getVideoSize();
        int width = size[0];
        int height = size[1];
        if (this.isFullScreen()) {
            this.stopFullScreen();
            if (width > height) {
                activity.setRequestedOrientation(1);
            }
        } else {
            this.startFullScreen();
            if (width > height) {
                activity.setRequestedOrientation(0);
            }
        }
    }

    @Override
    public void startFadeOut() {
        this.mController.startFadeOut();
    }

    @Override
    public void stopFadeOut() {
        this.mController.stopFadeOut();
    }

    @Override
    public boolean isShowing() {
        return this.mController.isShowing();
    }

    @Override
    public void setLocked(boolean locked) {
        this.mController.setLocked(locked);
    }

    @Override
    public boolean isLocked() {
        return this.mController.isLocked();
    }

    @Override
    public void startProgress() {
        this.mController.startProgress();
    }

    @Override
    public void stopProgress() {
        this.mController.stopProgress();
    }

    @Override
    public void hide() {
        this.mController.hide();
    }

    @Override
    public void show() {
        this.mController.show();
    }

    @Override
    public boolean hasCutout() {
        return this.mController.hasCutout();
    }

    @Override
    public int getCutoutHeight() {
        return this.mController.getCutoutHeight();
    }

    public void toggleLockState() {
        this.setLocked(!this.isLocked());
    }

    public void toggleShowState() {
        if (this.isShowing()) {
            this.hide();
        } else {
            this.show();
        }
    }
}

