/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.player;

import android.app.Application;
import java.util.LinkedHashMap;
import xyz.doikki.videoplayer.player.VideoView;
import xyz.doikki.videoplayer.player.VideoViewConfig;
import xyz.doikki.videoplayer.util.L;

public class VideoViewManager {
    private LinkedHashMap<String, VideoView> mVideoViews = new LinkedHashMap();
    private boolean mPlayOnMobileNetwork;
    private static VideoViewManager sInstance;
    private static VideoViewConfig sConfig;

    private VideoViewManager() {
        this.mPlayOnMobileNetwork = VideoViewManager.getConfig().mPlayOnMobileNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setConfig(VideoViewConfig config) {
        if (sConfig != null) return;
        Class<VideoViewConfig> clazz = VideoViewConfig.class;
        synchronized (VideoViewConfig.class) {
            if (sConfig != null) return;
            sConfig = config == null ? VideoViewConfig.newBuilder().build() : config;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static VideoViewConfig getConfig() {
        VideoViewManager.setConfig(null);
        return sConfig;
    }

    public boolean playOnMobileNetwork() {
        return this.mPlayOnMobileNetwork;
    }

    public void setPlayOnMobileNetwork(boolean playOnMobileNetwork) {
        this.mPlayOnMobileNetwork = playOnMobileNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VideoViewManager instance() {
        if (sInstance != null) return sInstance;
        Class<VideoViewManager> clazz = VideoViewManager.class;
        synchronized (VideoViewManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new VideoViewManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void add(VideoView videoView, String tag) {
        VideoView old;
        if (!(videoView.getContext() instanceof Application)) {
            L.w("The Context of this VideoView is not an Application Context,you must remove it after release,or it will lead to memory leek.");
        }
        if ((old = this.get(tag)) != null) {
            old.release();
            this.remove(tag);
        }
        this.mVideoViews.put(tag, videoView);
    }

    public VideoView get(String tag) {
        return this.mVideoViews.get(tag);
    }

    public void remove(String tag) {
        this.mVideoViews.remove(tag);
    }

    public void removeAll() {
        this.mVideoViews.clear();
    }

    public void releaseByTag(String tag) {
        this.releaseByTag(tag, true);
    }

    public void releaseByTag(String tag, boolean isRemove) {
        VideoView videoView = this.get(tag);
        if (videoView != null) {
            videoView.release();
            if (isRemove) {
                this.remove(tag);
            }
        }
    }

    public boolean onBackPress(String tag) {
        VideoView videoView = this.get(tag);
        if (videoView == null) {
            return false;
        }
        return videoView.onBackPressed();
    }
}

