/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.player;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.util.Map;
import xyz.doikki.videoplayer.player.AbstractPlayer;

public class AndroidMediaPlayer
extends AbstractPlayer
implements MediaPlayer.OnErrorListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    protected MediaPlayer mMediaPlayer;
    private int mBufferedPercent;
    private Context mAppContext;
    private boolean mIsPreparing;

    public AndroidMediaPlayer(Context context) {
        this.mAppContext = context.getApplicationContext();
    }

    @Override
    public void initPlayer() {
        this.mMediaPlayer = new MediaPlayer();
        this.setOptions();
        this.mMediaPlayer.setAudioStreamType(3);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
    }

    @Override
    public void setDataSource(String path, Map<String, String> headers) {
        try {
            this.mMediaPlayer.setDataSource(this.mAppContext, Uri.parse((String)path), headers);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void setDataSource(AssetFileDescriptor fd) {
        try {
            this.mMediaPlayer.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getLength());
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void start() {
        try {
            this.mMediaPlayer.start();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void pause() {
        try {
            this.mMediaPlayer.pause();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void stop() {
        try {
            this.mMediaPlayer.stop();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void prepareAsync() {
        try {
            this.mIsPreparing = true;
            this.mMediaPlayer.prepareAsync();
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void reset() {
        this.stop();
        this.mMediaPlayer.reset();
        this.mMediaPlayer.setSurface(null);
        this.mMediaPlayer.setDisplay(null);
        this.mMediaPlayer.setVolume(1.0f, 1.0f);
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public void seekTo(long time) {
        try {
            this.mMediaPlayer.seekTo((int)time);
        }
        catch (IllegalStateException e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void release() {
        this.mMediaPlayer.setOnErrorListener(null);
        this.mMediaPlayer.setOnCompletionListener(null);
        this.mMediaPlayer.setOnInfoListener(null);
        this.mMediaPlayer.setOnBufferingUpdateListener(null);
        this.mMediaPlayer.setOnPreparedListener(null);
        this.mMediaPlayer.setOnVideoSizeChangedListener(null);
        this.stop();
        final MediaPlayer mediaPlayer = this.mMediaPlayer;
        this.mMediaPlayer = null;
        new Thread(){

            @Override
            public void run() {
                try {
                    mediaPlayer.release();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public long getCurrentPosition() {
        return this.mMediaPlayer.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public int getBufferedPercentage() {
        return this.mBufferedPercent;
    }

    @Override
    public void setSurface(Surface surface) {
        try {
            this.mMediaPlayer.setSurface(surface);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void setDisplay(SurfaceHolder holder) {
        try {
            this.mMediaPlayer.setDisplay(holder);
        }
        catch (Exception e) {
            this.mPlayerEventListener.onError();
        }
    }

    @Override
    public void setVolume(float v1, float v2) {
        this.mMediaPlayer.setVolume(v1, v2);
    }

    @Override
    public void setLooping(boolean isLooping) {
        this.mMediaPlayer.setLooping(isLooping);
    }

    @Override
    public void setOptions() {
    }

    @Override
    public void setSpeed(float speed) {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                this.mMediaPlayer.setPlaybackParams(this.mMediaPlayer.getPlaybackParams().setSpeed(speed));
            }
            catch (Exception e) {
                this.mPlayerEventListener.onError();
            }
        }
    }

    @Override
    public float getSpeed() {
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                return this.mMediaPlayer.getPlaybackParams().getSpeed();
            }
            catch (Exception e) {
                this.mPlayerEventListener.onError();
            }
        }
        return 1.0f;
    }

    @Override
    public long getTcpSpeed() {
        return 0L;
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.mPlayerEventListener.onError();
        return true;
    }

    public void onCompletion(MediaPlayer mp) {
        this.mPlayerEventListener.onCompletion();
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        if (what == 3) {
            if (this.mIsPreparing) {
                this.mPlayerEventListener.onInfo(what, extra);
                this.mIsPreparing = false;
            }
        } else {
            this.mPlayerEventListener.onInfo(what, extra);
        }
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.mBufferedPercent = percent;
    }

    public void onPrepared(MediaPlayer mp) {
        this.mPlayerEventListener.onPrepared();
        this.start();
        if (!this.isVideo()) {
            this.mPlayerEventListener.onInfo(3, 0);
        }
    }

    private boolean isVideo() {
        try {
            MediaPlayer.TrackInfo[] trackInfo;
            for (MediaPlayer.TrackInfo info : trackInfo = this.mMediaPlayer.getTrackInfo()) {
                if (info.getTrackType() != 1) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
        int videoWidth = mp.getVideoWidth();
        int videoHeight = mp.getVideoHeight();
        if (videoWidth != 0 && videoHeight != 0) {
            this.mPlayerEventListener.onVideoSizeChanged(videoWidth, videoHeight);
        }
    }
}

