/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.dueeeke.videoplayer.util.PlayerUtils;
import java.lang.reflect.Method;
import java.util.List;

public final class CutoutUtil {
    private CutoutUtil() {
    }

    public static boolean allowDisplayToCutout(Activity activity) {
        if (Build.VERSION.SDK_INT >= 28) {
            Window window = activity.getWindow();
            WindowInsets windowInsets = window.getDecorView().getRootWindowInsets();
            if (windowInsets == null) {
                return false;
            }
            DisplayCutout displayCutout = windowInsets.getDisplayCutout();
            if (displayCutout == null) {
                return false;
            }
            List boundingRects = displayCutout.getBoundingRects();
            return boundingRects.size() > 0;
        }
        return CutoutUtil.hasCutoutHuawei(activity) || CutoutUtil.hasCutoutOPPO(activity) || CutoutUtil.hasCutoutVIVO(activity) || CutoutUtil.hasCutoutXIAOMI(activity);
    }

    private static boolean hasCutoutHuawei(Activity activity) {
        if (!Build.MANUFACTURER.equalsIgnoreCase("HUAWEI")) {
            return false;
        }
        try {
            ClassLoader cl = activity.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            if (HwNotchSizeUtil != null) {
                Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
                return (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean hasCutoutOPPO(Activity activity) {
        if (!Build.MANUFACTURER.equalsIgnoreCase("oppo")) {
            return false;
        }
        return activity.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
    }

    @SuppressLint(value={"PrivateApi"})
    private static boolean hasCutoutVIVO(Activity activity) {
        if (!Build.MANUFACTURER.equalsIgnoreCase("vivo")) {
            return false;
        }
        try {
            ClassLoader cl = activity.getClassLoader();
            Class<?> ftFeatureUtil = cl.loadClass("android.util.FtFeature");
            if (ftFeatureUtil != null) {
                Method get = ftFeatureUtil.getMethod("isFeatureSupport", Integer.TYPE);
                return (Boolean)get.invoke(ftFeatureUtil, 32);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SuppressLint(value={"PrivateApi"})
    private static boolean hasCutoutXIAOMI(Activity activity) {
        if (!Build.MANUFACTURER.equalsIgnoreCase("xiaomi")) {
            return false;
        }
        try {
            ClassLoader cl = activity.getClassLoader();
            Class<?> SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
            Method getInt = SystemProperties.getMethod("getInt", paramTypes);
            Object[] params = new Object[]{"ro.miui.notch", 0};
            int hasCutout = (Integer)getInt.invoke(SystemProperties, params);
            return hasCutout == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void adaptCutoutAboveAndroidP(Context context, boolean isAdapt) {
        Activity activity = PlayerUtils.scanForActivity(context);
        if (activity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = isAdapt ? 1 : 0;
            activity.getWindow().setAttributes(lp);
        }
    }
}

