/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.List;
import java.util.Optional;
import xyz.cofe.fn.Fn2;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.ImplementError;
import xyz.cofe.text.tparse.MapResultError;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Sq2OP;
import xyz.cofe.text.tparse.Sq3OP;
import xyz.cofe.text.tparse.Sq3OPImpl;
import xyz.cofe.text.tparse.SqNOPImpl;
import xyz.cofe.text.tparse.Tok;

public class Sq2OPImpl<P extends Pointer<?, ?, P>, T1 extends Tok<P>, T2 extends Tok<P>>
implements Sq2OP<P, T1, T2> {
    private final GR<P, T1> first;
    private final GR<P, T2> second;

    public Sq2OPImpl(GR<P, T1> first, GR<P, T2> second) {
        if (first == null) {
            throw new IllegalArgumentException("first==null");
        }
        if (second == null) {
            throw new IllegalArgumentException("second==null");
        }
        this.first = first;
        this.second = second;
    }

    @Override
    public <U extends Tok<P>> GR<P, U> map(final Fn2<T1, T2, U> map) {
        if (map == null) {
            throw new IllegalArgumentException("map == null");
        }
        return new GR<P, U>(){
            private String name;
            private final SqNOPImpl<P> sq;
            {
                this.sq = new SqNOPImpl(Sq2OPImpl.this.first, Sq2OPImpl.this.second);
            }

            @Override
            public GR<P, U> name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                if (this.name != null) {
                    return this.name;
                }
                return super.toString();
            }

            @Override
            public Optional<U> apply(P ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                Optional m = this.sq.name(this.name).match(ptr);
                if (m.isPresent()) {
                    Tok t1;
                    List toks = m.get();
                    if (toks.size() < 2) {
                        throw new ImplementError("tokens count < 2");
                    }
                    Tok t0 = toks.get(0);
                    Tok t = (Tok)map.apply(t0, t1 = toks.get(1));
                    if (t == null) {
                        throw new MapResultError("return null");
                    }
                    if (t.end().position() != t1.end().position()) {
                        throw new MapResultError("pointer order");
                    }
                    return Optional.of(t);
                }
                return Optional.empty();
            }
        };
    }

    @Override
    public <U extends Tok<P>> Sq3OP<P, T1, T2, U> next(GR<P, U> third) {
        if (third == null) {
            throw new IllegalArgumentException("third==null");
        }
        return new Sq3OPImpl<P, T1, T2, U>(this.first, this.second, third);
    }
}

