/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.Optional;
import java.util.function.Consumer;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Tok;

public class ProxyGR<P extends Pointer<?, ?, P>, T extends Tok<P>>
implements GR<P, T> {
    private GR<P, ? extends T> target;
    private String name;

    public ProxyGR(GR<P, T> initial) {
        if (initial == null) {
            throw new IllegalArgumentException("initial==null");
        }
        this.target = initial;
    }

    public ProxyGR<P, T> conf(Consumer<ProxyGR<P, T>> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    public GR<P, ? extends T> getTarget() {
        return this.target;
    }

    public void setTarget(GR<P, ? extends T> newTarget) {
        if (newTarget == null) {
            throw new IllegalArgumentException("newTarget==null");
        }
        this.target = newTarget;
    }

    @Override
    public Optional<T> apply(P ptr) {
        if (ptr == null) {
            throw new IllegalArgumentException("ptr==null");
        }
        Optional res = (Optional)this.target.apply(ptr);
        return res.isPresent() ? Optional.of((Tok)res.get()) : Optional.empty();
    }

    @Override
    public ProxyGR<P, T> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }
}

