/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.function.Function;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.parse.BasicCharPointer;
import xyz.cofe.text.parse.CharPointer;
import xyz.cofe.text.parse.Token;
import xyz.cofe.text.parse.TokenIterator;

public class Tokenizer
implements Eterable<Token> {
    private CharPointer pointer;
    private Function<CharPointer, ? extends Token>[] parsers;

    @SafeVarargs
    public Tokenizer(String source, int offset, Function<CharPointer, ? extends Token> ... parsers) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset<0");
        }
        if (parsers == null) {
            throw new IllegalArgumentException("parsers==null");
        }
        this.pointer = new BasicCharPointer(source, 0);
        this.parsers = parsers;
    }

    public Tokenizer(String source, int offset, Iterable<Function<CharPointer, ? extends Token>> parsers) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset<0");
        }
        if (parsers == null) {
            throw new IllegalArgumentException("parsers==null");
        }
        this.pointer = new BasicCharPointer(source, 0);
        this.parsers = Eterable.of(parsers).toList().toArray(new Function[0]);
    }

    public CharPointer getPointer() {
        return this.pointer;
    }

    public Function<CharPointer, ? extends Token>[] getParsers() {
        return this.parsers;
    }

    public TokenIterator iterator() {
        return new TokenIterator(this.pointer, this.parsers);
    }

    @SafeVarargs
    public static Token parse(String source, int offset, Function<? super CharPointer, ? extends Token> ... parsers) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset<0");
        }
        if (parsers == null) {
            throw new IllegalArgumentException("parsers==null");
        }
        if (parsers.length < 1) {
            return null;
        }
        BasicCharPointer tp = new BasicCharPointer(source, offset);
        for (Function<? super CharPointer, ? extends Token> parser : parsers) {
            Token t;
            if (parser == null || (t = parser.apply(tp)) == null) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    public static Token parse(String source, Function<? super CharPointer, ? extends Token> ... parsers) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (parsers == null) {
            throw new IllegalArgumentException("parsers==null");
        }
        if (parsers.length < 1) {
            return null;
        }
        return Tokenizer.parse(source, 0, parsers);
    }
}

