/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.ArrayList;
import java.util.function.Function;
import xyz.cofe.fn.Fn2;
import xyz.cofe.fn.Fn3;
import xyz.cofe.text.parse.Arr;
import xyz.cofe.text.parse.Pointer;
import xyz.cofe.text.parse.Tok;

public class Sequence<P extends Pointer, T extends Tok<P>>
implements Function<P, T> {
    private final Function<P, T>[] expressions;
    private final Fn3<P, P, Arr<T>, T> builder;

    public Sequence(Function<P, T>[] expressions, Fn3<P, P, Arr<T>, T> builder) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("builder==null");
        }
        this.expressions = expressions;
        this.builder = builder;
    }

    public Function<P, T>[] getExpressions() {
        return this.expressions;
    }

    @Override
    public T apply(P ptr) {
        if (ptr == null) {
            throw new IllegalArgumentException("ptr==null");
        }
        if (this.expressions == null || this.expressions.length < 1) {
            return null;
        }
        ArrayList<Tok> toks = new ArrayList<Tok>();
        P begin = ptr;
        for (Function<P, P> function : this.expressions) {
            if (function == null) continue;
            Tok t = (Tok)function.apply(ptr);
            if (t == null) {
                return null;
            }
            Object nptr = t.getEnd();
            if (ptr.compareTo(nptr) >= 0) {
                throw new Error("parser return empty token");
            }
            ptr = nptr;
            toks.add(t);
        }
        if (toks.isEmpty()) {
            return null;
        }
        P end = ptr;
        if (begin.compareTo(end) >= 0) {
            throw new Error("parser catch empty token");
        }
        return (T)this.build(begin, end, new Arr(toks));
    }

    public <R extends T> Sequence<P, R> build(Fn3<P, P, Arr<R>, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        Sequence<P, T> seq = new Sequence<P, T>(this.expressions, fn);
        return seq;
    }

    public <R extends T> Sequence<P, R> build(Fn2<P, P, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        Sequence<P, T> seq = new Sequence<P, T>(this.expressions, (begin, end, toks) -> (Tok)fn.apply(begin, end));
        return seq;
    }

    public Fn3<P, P, Arr<T>, T> getBuilder() {
        return this.builder;
    }

    private T build(P begin, P end, Arr<T> tokens) {
        return (T)((Tok)this.builder.apply(begin, end, tokens));
    }
}

