/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.function.Function;
import xyz.cofe.fn.Fn3;
import xyz.cofe.text.parse.Alternatives;
import xyz.cofe.text.parse.Arr;
import xyz.cofe.text.parse.Pointer;
import xyz.cofe.text.parse.Repeat;
import xyz.cofe.text.parse.Sequence;
import xyz.cofe.text.parse.Tok;

public class Builder {
    @SafeVarargs
    public static <P extends Pointer, T extends Tok<P>> SeqBuilder<P, T> seq(Function<P, T> ... seq) {
        if (seq == null) {
            throw new IllegalArgumentException("seq==null");
        }
        if (seq.length < 1) {
            throw new IllegalArgumentException("seq.length<1");
        }
        return new SeqBuilder<P, T>(seq);
    }

    @SafeVarargs
    public static <P extends Pointer, T extends Tok<P>> Alternatives<P, T> alt(Function<P, T> ... alts) {
        if (alts == null) {
            throw new IllegalArgumentException("alts==null");
        }
        if (alts.length < 1) {
            throw new IllegalArgumentException("alts.length<1");
        }
        return new Alternatives<P, T>(alts);
    }

    public static class SeqBuilder<P extends Pointer, T extends Tok<P>> {
        private Function<P, T>[] seq;

        public SeqBuilder(Function<P, T>[] seq) {
            if (seq == null) {
                throw new IllegalArgumentException("seq==null");
            }
            this.seq = seq;
        }

        public Sequence<P, T> build(Fn3<P, P, Arr<T>, T> builder) {
            if (builder == null) {
                throw new IllegalArgumentException("builder==null");
            }
            return new Sequence<P, T>(this.seq, builder);
        }
    }

    public static class RepBuilder<P extends Pointer, T extends Tok<P>> {
        private Function<P, T> expression;

        public RepBuilder(Function<P, T> expression) {
            if (expression == null) {
                throw new IllegalArgumentException("expression==null");
            }
            this.expression = expression;
        }

        public Repeat<P, T> build(Fn3<P, P, Arr<? super T>, T> builder) {
            if (builder == null) {
                throw new IllegalArgumentException("builder==null");
            }
            return new Repeat<P, T>(this.expression, builder);
        }
    }
}

