/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.List;
import xyz.cofe.text.parse.Pointer;
import xyz.cofe.text.parse.Token;
import xyz.cofe.text.parse.TokenPointer;

public class BasicTokenPointer
implements TokenPointer {
    private final List<Token> tokens;
    private final int pointer;

    public BasicTokenPointer(List<Token> tokens, int initial) {
        if (tokens == null) {
            throw new IllegalArgumentException("tokens==null");
        }
        this.pointer = initial;
        this.tokens = tokens;
    }

    public BasicTokenPointer(BasicTokenPointer sample, int initial) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.pointer = initial;
        this.tokens = sample.tokens;
    }

    @Override
    public Integer pointer() {
        return this.pointer;
    }

    @Override
    public Token lookup() {
        if (this.pointer < 0) {
            return null;
        }
        if (this.pointer >= this.tokens.size()) {
            return null;
        }
        return this.tokens.get(this.pointer);
    }

    @Override
    public TokenPointer move(int offset) {
        return new BasicTokenPointer(this, this.pointer + offset);
    }

    @Override
    public boolean eof() {
        return this.pointer >= this.tokens.size();
    }

    @Override
    public int compareTo(Pointer o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof TokenPointer) {
            int p2 = (Integer)((TokenPointer)o).pointer();
            return this.pointer == p2 ? 0 : (this.pointer < p2 ? -1 : 1);
        }
        return 0;
    }
}

