/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import xyz.cofe.fn.Pair;
import xyz.cofe.fn.QuadConsumer;
import xyz.cofe.fn.QuintConsumer;
import xyz.cofe.fn.TripleConsumer;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.parse.ArrPattern;
import xyz.cofe.text.parse.IndexValue;

public class Arr<A>
implements Eterable<A> {
    private final List<A> arr = new ArrayList<A>();

    public Arr(Iterable<A> itms) {
        if (itms != null) {
            for (A a : itms) {
                this.arr.add(a);
            }
        }
    }

    public Arr() {
        this(null);
    }

    public int size() {
        return this.arr.size();
    }

    public boolean isEmpty() {
        return this.arr.isEmpty();
    }

    public boolean contains(Object o) {
        return this.arr.contains(o);
    }

    public Iterator<A> iterator() {
        return this.arr.iterator();
    }

    public boolean containsAll(Collection<?> c) {
        return this.arr.containsAll(c);
    }

    public A get(int index) {
        return this.arr.get(index);
    }

    public int indexOf(Object o) {
        return this.arr.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.arr.lastIndexOf(o);
    }

    public void each(Consumer<? super A> action) {
        this.arr.forEach(action);
    }

    public Arr<A> sort(Comparator<A> cmp) {
        if (cmp == null) {
            throw new IllegalArgumentException("cmp==null");
        }
        Arr<A> arr = new Arr<A>(this);
        return arr;
    }

    public Arr<A> filter(Predicate<A> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter==null");
        }
        return new Arr<A>(super.filter(filter));
    }

    public Arr<A> notNull() {
        return new Arr<A>(super.notNull());
    }

    public Arr<A> union(Iterable<A> ... iter) {
        if (iter == null) {
            throw new IllegalArgumentException("iter==null");
        }
        return new Arr<A>(super.union((Iterable[])iter));
    }

    public <B> Arr<B> map(Function<A, B> map) {
        if (map == null) {
            throw new IllegalArgumentException("map==null");
        }
        return new Arr<A>(super.map(map));
    }

    public Arr<A> limit(long limit) {
        return new Arr<A>(super.limit(limit));
    }

    public <B> Arr<Pair<A, B>> product(Iterable<B> source) {
        return new Arr<Pair<A, B>>(super.product(source));
    }

    public <B> Arr<A> product(Iterable<B> source, BiConsumer<A, B> consumer) {
        super.product(source, consumer);
        return this;
    }

    public <B, C> Eterable<A> product(Iterable<B> source1, Iterable<C> source2, TripleConsumer<A, B, C> consumer) {
        super.product(source1, source2, consumer);
        return this;
    }

    public <B, C, D> Eterable<A> product(Iterable<B> source1, Iterable<C> source2, Iterable<D> source3, QuadConsumer<A, B, C, D> consumer) {
        super.product(source1, source2, source3, consumer);
        return this;
    }

    public <B, C, D, E> Eterable<A> product(Iterable<B> source1, Iterable<C> source2, Iterable<D> source3, Iterable<E> source4, QuintConsumer<A, B, C, D, E> consumer) {
        super.product(source1, source2, source3, source4, consumer);
        return this;
    }

    public Optional<A> first() {
        return super.first();
    }

    public List<A> toList() {
        return super.toList();
    }

    public Arr<IndexValue<A>> indexes() {
        Arr<IndexValue<A>> arr = new Arr<IndexValue<A>>();
        int idx = -1;
        Iterator<A> iterator = this.iterator();
        while (iterator.hasNext()) {
            A a = iterator.next();
            arr.arr.add(new IndexValue<A>(++idx, a));
        }
        return arr;
    }

    public Arr<A> reverse() {
        Arr<A> arr = new Arr<A>();
        Iterator<A> iterator = this.iterator();
        while (iterator.hasNext()) {
            A a = iterator.next();
            arr.arr.add(0, a);
        }
        return arr;
    }

    public <R> R reduce(R init, BiFunction<R, A, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        R r = init;
        Iterator<A> iterator = this.iterator();
        while (iterator.hasNext()) {
            A a = iterator.next();
            r = fn.apply(r, a);
        }
        return r;
    }

    public ArrPattern<A> pattern() {
        return new ArrPattern(this);
    }
}

