/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.wizard.CellDivider;
import bibliothek.gui.dock.wizard.ColumnDividier;
import bibliothek.gui.dock.wizard.PersistentCell;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardNodeMap;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Dimension;
import java.awt.Insets;

public class WizardColumnModel {
    private WizardSplitDockStation station;
    private double factorW;
    private double factorH;
    private PersistentColumn[] persistentColumns;

    public WizardColumnModel(WizardSplitDockStation station) {
        this(station, -1.0, -1.0);
    }

    public WizardColumnModel(WizardSplitDockStation station, double factorW, double factorH) {
        this.station = station;
        this.factorH = factorH;
        this.factorW = factorW;
    }

    public void setFactors(double factorW, double factorH) {
        this.factorW = factorW;
        this.factorH = factorH;
    }

    private WizardSplitDockStation.Side side() {
        return this.station.getSide();
    }

    private int gap(int column) {
        return this.station.getWizardSpanStrategy().getGap(column);
    }

    private int gap(int column, int cell) {
        return this.station.getWizardSpanStrategy().getGap(column, cell);
    }

    private int gap(Node node, WizardNodeMap map) {
        return this.station.getWizardSpanStrategy().getGap(node, map);
    }

    private int gap() {
        return this.station.getDividerSize();
    }

    public Leaf[] getLastLeafOfColumns() {
        return this.getMap().getLastLeafOfColumns();
    }

    public PersistentColumn[] getPersistentColumns() {
        return this.getMap().getPersistentColumns();
    }

    public boolean isHeaderLevel(SplitNode node) {
        return this.getMap().isHeaderLevel(node);
    }

    public boolean isHeaderLevel(SplitNode node, boolean recursive) {
        return this.getMap().isHeaderLevel(node, recursive);
    }

    protected WizardNodeMap getMap() {
        return new WizardNodeMap(this.station, this.persistentColumns){

            @Override
            protected void handlePersistentColumnsAdapted(PersistentColumn[] persistentColumns) {
                WizardColumnModel.access$002(WizardColumnModel.this, persistentColumns);
            }
        };
    }

    public Dimension getPreferredSize() {
        PersistentColumn[] columns = this.getMap().getPersistentColumns();
        int size = 0;
        int cellMax = 20;
        for (int c = 0; c < columns.length; ++c) {
            PersistentColumn column = columns[c];
            size += column.getSize();
            size += this.gap(c);
            int cellSize = 0;
            int count = 0;
            for (PersistentCell cell : column.getCells().values()) {
                cellSize += cell.getSize();
                cellSize += this.gap(c, count);
                ++count;
            }
            cellMax = Math.max(cellMax, cellSize += this.gap(c, count));
        }
        size += this.gap(columns.length);
        if (this.station.getDockableCount() > 0) {
            size += this.station.getSideGap();
        }
        Dimension result = this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL ? new Dimension(size, cellMax) : new Dimension(cellMax, size);
        Insets insets = this.station.getContentPane().getInsets();
        if (insets != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        return result;
    }

    public void setPersistentColumns(Dockable[][] columnsAndCells, int[][] cellSizes, int[] columnSizes) {
        WizardNodeMap map = this.getMap();
        PersistentColumn[] persistentColumns = map.getPersistentColumns();
        for (int i = 0; i < columnsAndCells.length; ++i) {
            block1: for (int j = 0; j < columnsAndCells[i].length; ++j) {
                Dockable key = columnsAndCells[i][j];
                if (key == null) continue;
                for (PersistentColumn column : persistentColumns) {
                    PersistentCell cell = column.getCells().get(key);
                    if (cell == null) continue;
                    cell.setSize(cellSizes[i][j]);
                    column.setSize(columnSizes[i]);
                    continue block1;
                }
            }
        }
        this.applyPersistentSizes(map, true);
    }

    public void setDivider(Divideable divideable, double divider) {
        PersistentCell cell;
        WizardNodeMap map = this.getMap();
        if (divideable instanceof Node) {
            Node node = (Node)divideable;
            WizardNodeMap.Column column = this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? map.getHeadColumn(node.getRight()) : map.getHeadColumn(node.getLeft());
            if (column != null) {
                this.setDivider(map, column, node.getDivider(), divider, node.getSize());
            } else {
                PersistentCell cell2 = map.getHeadCell(node.getLeft());
                if (cell2 != null) {
                    double dividerDelta = divider - node.getDivider();
                    int deltaPixel = this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL ? (int)(dividerDelta * (double)node.getSize().height) : (int)(dividerDelta * (double)node.getSize().width);
                    cell2.setSize(cell2.getSize() + deltaPixel);
                    this.applyPersistentSizes(map, true);
                } else {
                    node.setDivider(divider);
                }
            }
        } else if (divideable instanceof ColumnDividier) {
            WizardNodeMap.Column column = map.getHeadColumn((SplitNode)this.station.getRoot());
            if (column != null) {
                this.setDivider(map, column, divideable.getDivider(), divider, this.station.getSize());
            }
        } else if (divideable instanceof CellDivider && (cell = map.getHeadCell((SplitNode)((CellDivider)divideable).getLeaf())) != null) {
            double dividierDelta = divider - divideable.getDivider();
            int deltaPixel = (int)(dividierDelta * (double)cell.getSize());
            cell.setSize(cell.getSize() + deltaPixel);
            this.applyPersistentSizes(map, true);
        }
    }

    private void setDivider(WizardNodeMap map, WizardNodeMap.Column column, double oldDividier, double newDividier, Dimension size) {
        PersistentColumn persistent = column.getPersistentColumn();
        double dividerDelta = this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? oldDividier - newDividier : newDividier - oldDividier;
        int deltaPixel = this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL ? (int)(dividerDelta * (double)size.width) : (int)(dividerDelta * (double)size.height);
        persistent.setSize(persistent.getSize() + deltaPixel);
        this.applyPersistentSizes(map, true);
    }

    public void resetToPreferredSizes() {
        WizardNodeMap map = this.getMap();
        for (PersistentColumn column : map.getPersistentColumns()) {
            column.setSize(column.getPreferredSize());
            for (PersistentCell cell : column.getCells().values()) {
                cell.setSize(cell.getPreferredSize());
            }
        }
        this.applyPersistentSizes(map, true);
    }

    public void resetToPreferredSize(int index) {
        PersistentColumn column = this.getMap().getPersistentColumn(index);
        column.setSize(column.getPreferredSize());
    }

    protected int applyPersistentSizes(WizardNodeMap map, boolean revalidate) {
        int result = this.applyPersistentSizes((SplitNode)this.station.getRoot(), map);
        if (revalidate) {
            this.station.revalidateOutside();
        }
        return result;
    }

    private int applyPersistentSizes(SplitNode node, WizardNodeMap map) {
        WizardNodeMap.Column column = map.getColumn(node, false);
        if (column != null) {
            this.applyPersistentSizes(column.getRoot(), column.getPersistentColumn(), map);
            PersistentColumn persistent = column.getPersistentColumn();
            if (persistent == null) {
                return 0;
            }
            return persistent.getSize();
        }
        if (node instanceof Root) {
            return this.applyPersistentSizes(((Root)node).getChild(), map);
        }
        if (node instanceof Node) {
            int left = this.applyPersistentSizes(((Node)node).getLeft(), map);
            int right = this.applyPersistentSizes(((Node)node).getRight(), map);
            int gap = this.gap((Node)node, map);
            ((Node)node).setDivider((double)(left + gap / 2) / (double)(left + right + gap));
            return left + gap + right;
        }
        return 0;
    }

    private int applyPersistentSizes(SplitNode node, PersistentColumn column, WizardNodeMap map) {
        PersistentCell cell;
        if (node instanceof Root) {
            return this.applyPersistentSizes(((Root)node).getChild(), column, map);
        }
        if (node instanceof Node) {
            Node n = (Node)node;
            int left = this.applyPersistentSizes(n.getLeft(), column, map);
            int right = this.applyPersistentSizes(n.getRight(), column, map);
            if (n.getLeft() == null || !n.getLeft().isVisible()) {
                return right;
            }
            if (n.getRight() == null || !n.getRight().isVisible()) {
                return left;
            }
            int gap = this.gap((Node)node, map);
            ((Node)node).setDivider((double)(left + gap / 2) / (double)(left + right + gap));
            return left + gap + right;
        }
        if (node instanceof Leaf && (cell = column.getCells().get(((Leaf)node).getDockable())) != null) {
            return cell.getSize();
        }
        return 0;
    }

    public void updateBounds(double x, double y) {
        double w = 1.0;
        double h = 1.0;
        int gap0 = this.gap(0);
        WizardNodeMap map = this.getMap();
        int columns = map.getColumns().size();
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            x += (double)gap0 / this.factorW;
            w -= (double)gap0 / this.factorW;
            if (columns > 0) {
                w -= (double)this.gap(columns) / this.factorW;
            }
        } else {
            y += (double)gap0 / this.factorH;
            h -= (double)gap0 / this.factorH;
            if (columns > 0) {
                h -= (double)this.gap(columns) / this.factorH;
            }
        }
        int sideGap = this.station.getSideGap();
        switch (this.station.getSide()) {
            case RIGHT: {
                x += (double)sideGap / this.factorW;
            }
            case LEFT: {
                w -= (double)sideGap / this.factorW;
                break;
            }
            case BOTTOM: {
                y += (double)sideGap / this.factorH;
            }
            case TOP: {
                h -= (double)sideGap / this.factorH;
            }
        }
        Root root = this.station.getRoot();
        root.updateBounds(x, y, w, h, this.factorW, this.factorH, false);
        int pixels = this.applyPersistentSizes(map, false);
        if (this.station.getSide().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            w = (double)pixels / this.factorW;
        } else {
            h = (double)pixels / this.factorH;
        }
        this.updateBounds((SplitNode)this.station.getRoot(), x, y, w, h, map);
    }

    protected void updateBounds(SplitNode node, double x, double y, double width, double height, WizardNodeMap map) {
        if (node != null && node.isVisible()) {
            WizardNodeMap.Column column = map.getColumn(node, false);
            if (column != null) {
                this.updateBounds(x, y, width, height, column, map);
            } else {
                this.updateBoundsRecursive(node, x, y, width, height, map);
            }
        }
    }

    protected void updateBounds(double x, double y, double width, double height, WizardNodeMap.Column column, WizardNodeMap map) {
        int requested = 0;
        int count = 0;
        int gaps = 0;
        for (PersistentCell cell : column.getPersistentColumn().getCells().values()) {
            requested += cell.getSize();
            gaps += this.gap(column.getIndex(), count);
            ++count;
        }
        gaps += this.gap(column.getIndex(), count);
        int gap0 = this.gap(column.getIndex(), 0);
        int cellCount = column.getCellCount();
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            double available = height * this.factorH - (double)gaps;
            if ((double)requested < (available = Math.max(available, 0.0))) {
                height = (double)requested / this.factorH + (double)gaps / this.factorH;
            }
            y += (double)gap0 / this.factorH;
            height -= (double)gap0 / this.factorH;
            if (cellCount > 0) {
                height -= (double)this.gap(column.getIndex(), cellCount) / this.factorH;
            }
        } else {
            double available = width * this.factorW - (double)gaps;
            if ((double)requested < (available = Math.max(available, 0.0))) {
                width = (double)requested / this.factorW + (double)gaps / this.factorW;
            }
            x += (double)gap0 / this.factorW;
            width -= (double)gap0 / this.factorW;
            if (cellCount > 0) {
                width -= (double)this.gap(column.getIndex(), cellCount) / this.factorW;
            }
        }
        this.updateBoundsRecursive(column.getRoot(), x, y, width, height, map);
    }

    protected void updateBoundsRecursive(SplitNode node, double x, double y, double width, double height, WizardNodeMap map) {
        if (node != null && node.isVisible()) {
            if (node instanceof Root) {
                this.updateBounds(((Root)node).getChild(), x, y, width, height, map);
            } else if (node instanceof Node) {
                Node n = (Node)node;
                if (n.getLeft() != null && n.getLeft().isVisible() && n.getRight() != null && n.getRight().isVisible()) {
                    if (n.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                        double dividerWidth = this.factorW > 0.0 ? Math.max(0.0, (double)this.gap(n, map) / this.factorW) : 0.0;
                        double dividerLocation = width * n.getDivider();
                        this.updateBounds(n.getLeft(), x, y, dividerLocation - dividerWidth / 2.0, height, map);
                        this.updateBounds(n.getRight(), x + dividerLocation + dividerWidth / 2.0, y, width - dividerLocation - dividerWidth / 2.0, height, map);
                    } else {
                        double dividerHeight = this.factorH > 0.0 ? Math.max(0.0, (double)this.gap(n, map) / this.factorH) : 0.0;
                        double dividerLocation = height * n.getDivider();
                        this.updateBounds(n.getLeft(), x, y, width, dividerLocation - dividerHeight / 2.0, map);
                        this.updateBounds(n.getRight(), x, y + dividerLocation + dividerHeight / 2.0, width, height - dividerLocation - dividerHeight / 2.0, map);
                    }
                } else {
                    this.updateBounds(n.getLeft(), x, y, width, height, map);
                    this.updateBounds(n.getRight(), x, y, width, height, map);
                }
            }
            node.setBounds(x, y, width, height, this.factorW, this.factorH, true);
        }
    }

    public double validateDivider(double divider, Node node) {
        return this.validateDivider(divider, node, this.getMap());
    }

    public double validateDivider(double divider, Leaf leaf) {
        return this.validateDivider(divider, leaf, this.getMap());
    }

    public double validateColumnDivider(double divider) {
        return this.validateColumnDivider(divider, this.getMap());
    }

    private double validateDivider(double divider, Node node, WizardNodeMap map) {
        WizardNodeMap.Column column = map.getColumn((SplitNode)node, true);
        if (column == null) {
            return this.validateHeadNode(divider, node, map);
        }
        return this.validateDivider(column, divider, node, map);
    }

    private double validateDivider(double divider, Leaf leaf, WizardNodeMap map) {
        WizardNodeMap.Column column = map.getColumn((SplitNode)leaf, true);
        if (column != null) {
            return this.validateDivider(column, divider, leaf, map);
        }
        return divider;
    }

    private double validateColumnDivider(double divider, WizardNodeMap map) {
        int available;
        WizardNodeMap.Column outer = map.getOutermostColumn();
        if (outer == null) {
            return divider;
        }
        int min = 0;
        int gap = this.gap();
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            for (WizardNodeMap.Column column : map.getColumns().values()) {
                min += column.getRoot().getSize().width + gap;
            }
            min -= outer.getRoot().getSize().width + gap;
            min += outer.getMinimumSize().width;
            available = this.station.getWidth() - gap;
        } else {
            for (WizardNodeMap.Column column : map.getColumns().values()) {
                min += column.getRoot().getSize().height + gap;
            }
            min -= outer.getRoot().getSize().height + gap;
            min += outer.getMinimumSize().height;
            available = this.station.getHeight() - gap;
        }
        if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM) {
            double maxDividier = 1.0 - (double)(min + this.gap() / 2) / (double)(available + this.gap());
            return Math.min(maxDividier, divider);
        }
        double minDividier = (double)(min + this.gap() / 2) / (double)(available + this.gap());
        return Math.max(minDividier, divider);
    }

    private double validateHeadNode(double divider, Node node, WizardNodeMap map) {
        int available;
        int min;
        if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? divider < node.getDivider() : divider > node.getDivider()) {
            return divider;
        }
        WizardNodeMap.Column head = this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM ? map.getHeadColumn(node.getRight()) : map.getHeadColumn(node.getLeft());
        if (head == null) {
            return divider;
        }
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            min = head.getMinimumSize().width + this.gap();
            available = node.getSize().width;
        } else {
            min = head.getMinimumSize().height + this.gap();
            available = node.getSize().height;
        }
        if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM) {
            double maxDividier = 1.0 - (double)(min + this.gap() / 2) / (double)(available + this.gap());
            return Math.min(maxDividier, divider);
        }
        double minDividier = (double)(min + this.gap() / 2) / (double)(available + this.gap());
        return Math.max(minDividier, divider);
    }

    public double validateDivider(WizardNodeMap.Column column, double divider, Node node, WizardNodeMap map) {
        int available;
        int min;
        if (divider > node.getDivider()) {
            return divider;
        }
        WizardNodeMap.Cell head = column.getRightmostCell(node.getLeft());
        if (head == null) {
            return divider;
        }
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            min = node.getLeft().getSize().height - head.getNode().getSize().height + head.getMinimumSize().height;
            available = node.getSize().height;
        } else {
            min = node.getLeft().getSize().width - head.getNode().getSize().width + head.getMinimumSize().width;
            available = node.getSize().width;
        }
        double minDividier = (double)(min + this.gap() / 2) / (double)(available + this.gap());
        return Math.max(minDividier, divider);
    }

    public double validateDivider(WizardNodeMap.Column column, double divider, Leaf leaf, WizardNodeMap map) {
        int available;
        int min;
        WizardNodeMap.Cell head = column.getRightmostCell((SplitNode)leaf);
        if (head == null) {
            return divider;
        }
        if (this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            min = head.getMinimumSize().height + this.gap();
            available = leaf.getSize().height;
        } else {
            min = head.getMinimumSize().width + this.gap();
            available = leaf.getSize().width;
        }
        double minDividier = (double)(min + this.gap() / 2) / (double)(available + this.gap());
        return Math.max(minDividier, divider);
    }

    static /* synthetic */ PersistentColumn[] access$002(WizardColumnModel x0, PersistentColumn[] x1) {
        x0.persistentColumns = x1;
        return x1;
    }
}

