/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.station.layer.DefaultDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Point;
import javax.swing.SwingUtilities;

public class ToolbarSlimDropLayer
extends DefaultDropLayer {
    private final ToolbarDockStation station;

    public ToolbarSlimDropLayer(ToolbarDockStation station) {
        super((DockStation)station);
        this.station = station;
        this.setPriority(LayerPriority.BASE);
    }

    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            Point mouseCoord = new Point(x, y);
            SwingUtilities.convertPointFromScreen(mouseCoord, this.getComponent());
            int size = this.station.getLateralNodropZoneSize();
            if (this.station.getOrientation() == Orientation.VERTICAL) {
                return mouseCoord.x > size && mouseCoord.x < this.getComponent().getWidth() - size - 1;
            }
            return mouseCoord.y > size && mouseCoord.y < this.getComponent().getHeight() - size - 1;
        }
        return false;
    }
}

