/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationExtension;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;

public class ToolbarScreenDockStationExtension
implements ScreenDockStationExtension {
    private DockController controller;
    private Dockable pending;

    public ToolbarScreenDockStationExtension(DockController controller) {
        this.controller = controller;
    }

    public boolean canReplace(ScreenDockStation station, Dockable old, Dockable next) {
        ToolbarStrategy strategy = (ToolbarStrategy)this.controller.getProperties().get(ToolbarStrategy.STRATEGY);
        return strategy.isToolbarGroupPartParent((DockStation)station, next, true);
    }

    public void drop(ScreenDockStation station, ScreenDockStationExtension.DropArguments arguments) {
        if (arguments.getWindow() == null) {
            Dockable dockable;
            ToolbarStrategy strategy = (ToolbarStrategy)this.controller.getProperties().get(ToolbarStrategy.STRATEGY);
            if (strategy.isToolbarPart(dockable = arguments.getDockable())) {
                Dockable replacement = strategy.ensureToolbarLayer((DockStation)station, dockable);
                this.pending = replacement != dockable ? dockable : null;
                arguments.setDockable(replacement);
            }
        } else {
            this.pending = null;
        }
    }

    public void dropped(ScreenDockStation station, ScreenDockStationExtension.DropArguments arguments, boolean successfull) {
        if (this.pending != null && successfull) {
            DockStation child = arguments.getDockable().asDockStation();
            DockableProperty successor = arguments.getProperty().getSuccessor();
            if (successor == null || !child.drop(this.pending, successor)) {
                child.drop(this.pending);
            }
        }
        this.pending = null;
    }
}

