/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRoot;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBar;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBarFactory;
import bibliothek.gui.dock.station.toolbar.group.DefaultToolbarGroupDividierStrategy;
import bibliothek.gui.dock.station.toolbar.group.SlimScrollbar;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategyFactory;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDropInfo;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupExpander;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeader;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeaderFactory;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupPlaceholderMapping;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarGroupInnerLayer;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarGroupOuterLayer;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGridConverter;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.property.PropertyFactory;
import bibliothek.util.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ToolbarGroupDockStation
extends AbstractToolbarDockStation {
    public static final String TITLE_ID = "toolbar.group";
    public static final String DISPLAYER_ID = "toolbar.group";
    public static final PropertyKey<ColumnScrollBarFactory> SCROLLBAR_FACTORY = new PropertyKey("dock.scrollbarFactory", (PropertyFactory)new ConstantPropertyFactory((Object)SlimScrollbar.FACTORY), true);
    public static final PropertyKey<ToolbarGroupHeaderFactory> HEADER_FACTORY = new PropertyKey("dock.toolbarGroupHeaderFactory");
    public static final PropertyKey<ToolbarGroupDividerStrategyFactory> DIVIDER_STRATEGY_FACTORY = new PropertyKey("dock.toolbarGroupDividerStrategy", (PropertyFactory)new ConstantPropertyFactory((Object)DefaultToolbarGroupDividierStrategy.FACTORY), true);
    private final DockablePlaceholderToolbarGrid<StationChildHandle> dockables = new DockablePlaceholderToolbarGrid();
    private ToolbarGroupExpander expander;
    private final PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            ToolbarGroupDockStation.this.dockables.setStrategy(newValue);
        }
    };
    private PropertyValue<ToolbarGroupDividerStrategyFactory> dividerStrategyFactory = new PropertyValue<ToolbarGroupDividerStrategyFactory>(DIVIDER_STRATEGY_FACTORY){

        protected void valueChanged(ToolbarGroupDividerStrategyFactory oldValue, ToolbarGroupDividerStrategyFactory newValue) {
            if (newValue == null) {
                ToolbarGroupDockStation.this.setDividerStrategy(null);
            } else {
                ToolbarGroupDockStation.this.setDividerStrategy(newValue.create(ToolbarGroupDockStation.this));
            }
        }
    };
    private ToolbarGroupDividerStrategy dividerStrategy;
    private OverpaintablePanelBase mainPanel;
    private int borderSideSnapSize = 10;
    private boolean allowSideSnap = true;
    private ToolbarGridLayoutManager<StationChildHandle> layoutManager;
    private ToolbarGroupDropInfo dropInfo;
    private PropertyValue<ColumnScrollBarFactory> scrollbarFactory = new PropertyValue<ColumnScrollBarFactory>(SCROLLBAR_FACTORY){

        protected void valueChanged(ColumnScrollBarFactory oldValue, ColumnScrollBarFactory newValue) {
            ToolbarGroupDockStation.this.resetScrollbars();
        }
    };
    private Map<Integer, ColumnScrollBar> scrollbars = new HashMap<Integer, ColumnScrollBar>();
    private AdjustmentListener adjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            ToolbarGroupDockStation.this.mainPanel.dockablePane.revalidate();
        }
    };
    private PropertyValue<ToolbarGroupHeaderFactory> headerFactory = new PropertyValue<ToolbarGroupHeaderFactory>(HEADER_FACTORY){

        protected void valueChanged(ToolbarGroupHeaderFactory oldValue, ToolbarGroupHeaderFactory newValue) {
            ToolbarGroupHeader header = null;
            if (newValue != null) {
                header = newValue.create(ToolbarGroupDockStation.this);
            }
            if (ToolbarGroupDockStation.this.groupHeader != null) {
                ToolbarGroupDockStation.this.mainPanel.removeHeaderCopmonent(ToolbarGroupDockStation.this.groupHeader.getComponent());
                ToolbarGroupDockStation.this.groupHeader.destroy();
            }
            ToolbarGroupDockStation.this.groupHeader = header;
            if (ToolbarGroupDockStation.this.groupHeader != null) {
                ToolbarGroupDockStation.this.groupHeader.setOrientation(ToolbarGroupDockStation.this.getOrientation());
                ToolbarGroupDockStation.this.mainPanel.addHeaderComponent(ToolbarGroupDockStation.this.groupHeader.getComponent());
            }
        }
    };
    private ToolbarGroupHeader groupHeader;

    public ToolbarGridLayoutManager<StationChildHandle> getLayoutManager() {
        return this.layoutManager;
    }

    public ToolbarGroupDockStation() {
        this.init();
    }

    protected void init() {
        this.init("dock.background.station.toolbar.group");
        this.mainPanel = new OverpaintablePanelBase();
        this.paint = new DefaultStationPaintValue("dock.paint.toolbar.group", (DockStation)this);
        this.setOrientation(this.getOrientation());
        this.displayerFactory = this.createDisplayerFactory();
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, this.getDisplayerId());
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            public void discard(DockableDisplayer displayer) {
                ToolbarGroupDockStation.this.discard(displayer);
            }

            public void moveableElementChanged(DockableDisplayer displayer) {
            }
        });
        this.setTitleIcon(null);
        this.expander = new ToolbarGroupExpander(this);
        this.setDividerStrategy(((ToolbarGroupDividerStrategyFactory)this.dividerStrategyFactory.getValue()).create(this));
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler((DockComponentRoot)this, this.displayers);
    }

    public ToolbarColumnModel<Dockable, StationChildHandle> getColumnModel() {
        return this.dockables.getModel();
    }

    public int column(Dockable dockable) {
        return this.dockables.getColumn(dockable);
    }

    public int line(Dockable dockable) {
        return this.dockables.getLine(dockable);
    }

    public int columnCount() {
        return this.dockables.getColumnCount();
    }

    public int lineCount(int column) {
        return this.dockables.getLineCount(column);
    }

    public Dockable getDockable(int columnIndex, int line) {
        StationChildHandle handle = this.getHandle(columnIndex, line);
        if (handle == null) {
            return null;
        }
        return handle.asDockable();
    }

    public StationChildHandle getHandle(int columnIndex, int line) {
        ToolbarColumnModel<Dockable, StationChildHandle> model = this.getColumnModel();
        if (columnIndex < 0 || columnIndex >= model.getColumnCount()) {
            return null;
        }
        ToolbarColumn<Dockable, StationChildHandle> column = model.getColumn((Dockable)columnIndex);
        if (line < 0 || line >= column.getDockableCount()) {
            return null;
        }
        return column.getItem(line);
    }

    public StationChildHandle getHandle(Dockable dockable) {
        ToolbarColumn<Dockable, StationChildHandle> column = this.getColumnModel().getColumn(dockable);
        if (column == null) {
            return null;
        }
        int n = column.getDockableCount();
        for (int i = 0; i < n; ++i) {
            StationChildHandle handle = column.getItem(i);
            if (handle.getDockable() != dockable) continue;
            return handle;
        }
        return null;
    }

    public boolean isLastOfColumn(Dockable dockable) {
        int index = this.indexOf(dockable);
        int column = this.column(dockable);
        if (index == this.getDockableCount() - 1) {
            return true;
        }
        return this.column(this.getDockable(index + 1)) != column;
    }

    @Override
    public ToolbarStrategy getToolbarStrategy() {
        DockController controller = this.getController();
        DockStation parent = this.getDockParent();
        while (controller == null && parent != null) {
            controller = parent.getController();
            Dockable parentDockable = parent.asDockable();
            if (parentDockable == null) {
                parent = null;
                continue;
            }
            parent = parentDockable.getDockParent();
        }
        SilentPropertyValue value = new SilentPropertyValue(ToolbarStrategy.STRATEGY, controller);
        ToolbarStrategy result = (ToolbarStrategy)value.getValue();
        value.setProperties((DockController)null);
        return result;
    }

    public Component getComponent() {
        return this.mainPanel;
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public Dockable getDockable(int index) {
        return ((StationChildHandle)this.dockables.get(index)).asDockable();
    }

    public String getFactoryID() {
        return "ToolbarGroupDockStationFactory";
    }

    protected String getDisplayerId() {
        return "toolbar.group";
    }

    public void setAllowSideSnap(boolean allowSideSnap) {
        this.allowSideSnap = allowSideSnap;
    }

    public boolean isAllowSideSnap() {
        return this.allowSideSnap;
    }

    public void setBorderSideSnapSize(int borderSideSnapSize) {
        if (borderSideSnapSize < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.borderSideSnapSize = borderSideSnapSize;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    @Override
    public void setController(DockController controller) {
        if (this.getController() != controller) {
            if (this.getController() != null) {
                this.dockables.unbind();
            }
            Iterator iter = this.dockables.items();
            while (iter.hasNext()) {
                ((StationChildHandle)iter.next()).setTitleRequest(null);
            }
            super.setController(controller);
            this.title = controller == null ? null : this.registerTitle(controller);
            this.paint.setController(controller);
            this.expander.setController(controller);
            this.placeholderStrategy.setProperties(controller);
            this.displayerFactory.setController(controller);
            this.displayers.setController(controller);
            this.mainPanel.setController(controller);
            this.layoutManager.setController(controller);
            this.scrollbarFactory.setProperties(controller);
            this.headerFactory.setProperties(controller);
            this.dividerStrategyFactory.setProperties(controller);
            if (this.getController() != null) {
                this.dockables.bind();
            }
            iter = this.dockables.items();
            while (iter.hasNext()) {
                ((StationChildHandle)iter.next()).setTitleRequest(this.title, true);
            }
        }
    }

    @Override
    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        this.orientation = orientation;
        this.fireOrientingEvent();
        for (ColumnScrollBar scrollbar : this.scrollbars.values()) {
            scrollbar.setOrientation(orientation);
        }
        if (this.groupHeader != null) {
            this.groupHeader.setOrientation(orientation);
            this.mainPanel.removeHeaderCopmonent(this.groupHeader.getComponent());
            this.mainPanel.addHeaderComponent(this.groupHeader.getComponent());
        }
        this.mainPanel.updateAlignment();
        this.mainPanel.revalidate();
    }

    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new ToolbarGroupInnerLayer(this, this.mainPanel.dockablePane), new ToolbarGroupOuterLayer(this, this.mainPanel.dockablePane)};
    }

    public boolean accept(Dockable child) {
        return this.getToolbarStrategy().isToolbarGroupPart(child);
    }

    public boolean accept(DockStation station) {
        return this.getToolbarStrategy().isToolbarGroupPartParent(station, this, false);
    }

    public boolean accept(DockStation base, Dockable neighbor) {
        return false;
    }

    public StationDropOperation prepareDrop(StationDropItem item) {
        DockController controller = this.getController();
        if (this.getExpandedState() == ExpandedState.EXPANDED) {
            return null;
        }
        Dockable dockable = item.getDockable();
        if (this.accept(dockable) && dockable.accept((DockStation)this)) {
            if (controller != null && !controller.getAcceptance().accept((DockStation)this, dockable)) {
                return null;
            }
            Point mouse = new Point(item.getMouseX(), item.getMouseY());
            SwingUtilities.convertPointFromScreen(mouse, this.mainPanel.dockablePane);
            int column = this.getColumnAt(mouse);
            int line = -1;
            if (column >= 0 && column < this.columnCount()) {
                Rectangle columnBounds = this.layoutManager.getBounds(column);
                if (this.getOrientation() == Orientation.VERTICAL) {
                    int x = columnBounds.x;
                    int width = columnBounds.width;
                    if (x + width / 5 <= mouse.x && mouse.x <= x + width * 4 / 5) {
                        line = this.layoutManager.getInsertionLineAt(column, mouse.y);
                    } else if (mouse.x >= x + width * 4 / 5) {
                        ++column;
                    }
                } else {
                    int y = columnBounds.y;
                    int height = columnBounds.height;
                    if (y + height / 5 <= mouse.y && mouse.y <= y + height * 4 / 5) {
                        line = this.layoutManager.getInsertionLineAt(column, mouse.x);
                    } else if (mouse.y >= y + height * 4 / 5) {
                        ++column;
                    }
                }
            }
            if (column == -1) {
                column = 0;
            }
            boolean effect = true;
            if (dockable.getDockParent() == this) {
                int currentColumn = this.column(dockable);
                int currentLine = this.line(dockable);
                effect = currentColumn != column || currentLine != line && currentLine != line - 1;
                effect = effect && (line != -1 || this.lineCount(currentColumn) != 1 || currentColumn != column && currentColumn != column - 1);
            }
            return new ToolbarGroupDropInfo(dockable, this, column, line, effect){

                public void execute() {
                    ToolbarGroupDockStation.this.dropInfo = null;
                    ToolbarGroupDockStation.this.drop(this);
                }

                public void destroy(StationDropOperation next) {
                    if (next == null || next.getTarget() != this.getTarget()) {
                        ToolbarGroupDockStation.this.layoutManager.mutate();
                    }
                    ToolbarGroupDockStation.this.dropInfo = null;
                    ToolbarGroupDockStation.this.mainPanel.repaint();
                }

                public void draw() {
                    ToolbarGroupDockStation.this.dropInfo = this;
                    int column = this.getColumn();
                    int line = this.getLine();
                    if (this.hasEffect()) {
                        ToolbarGroupDockStation.this.layoutManager.mutate(column, line);
                    } else {
                        ToolbarGroupDockStation.this.layoutManager.mutate();
                    }
                    ToolbarGroupDockStation.this.mainPanel.repaint();
                }
            };
        }
        return null;
    }

    public int getColumnAt(Point location) {
        int max;
        int pos;
        if (this.getOrientation() == Orientation.VERTICAL) {
            pos = location.x;
            max = this.mainPanel.getWidth();
        } else {
            pos = location.y;
            max = this.mainPanel.getHeight();
        }
        if (pos < 0) {
            return -1;
        }
        if (pos >= max) {
            return this.columnCount();
        }
        return this.layoutManager.getColumnAt(pos);
    }

    protected void drop(ToolbarGroupDropInfo dropInfoGroup) {
        int line = dropInfoGroup.getLine();
        if (line == -1) {
            this.drop(dropInfoGroup.getItem(), dropInfoGroup.getColumn());
        } else {
            this.drop(dropInfoGroup.getItem(), dropInfoGroup.getColumn(), line);
        }
    }

    public void drop(Dockable dockable) {
        this.drop(dockable, 0, 0);
    }

    public boolean drop(Dockable dockable, int column, int line) {
        return this.drop(dockable, column, line, false);
    }

    public boolean drop(Dockable dockable, int column, int line, boolean force) {
        if (force || this.accept(dockable)) {
            if (!force) {
                Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                if (replacement == null) {
                    return false;
                }
                if (replacement != dockable) {
                    replacement.asDockStation().drop(dockable);
                    dockable = replacement;
                }
            }
            this.add(dockable, column, line);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Dockable dockable, int column, int line) {
        DockUtilities.ensureTreeValidity((DockStation)this, (Dockable)dockable);
        DockUtilities.checkLayoutLocked();
        Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
        if (replacement != dockable) {
            replacement.asDockStation().drop(dockable);
            dockable = replacement;
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking((DockStation)this, (Dockable)dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            dockable.setDockParent((DockStation)this);
            StationChildHandle handle = this.createHandle(dockable);
            int before = this.dockables.getColumnCount();
            this.dockables.insert(column, line, handle);
            this.addComponent(handle);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(dockable, before != this.dockables.getColumnCount());
        }
        finally {
            token.release();
        }
    }

    private StationChildHandle createHandle(Dockable dockable) {
        StationChildHandle handle = new StationChildHandle((DockStation)this, this.displayers, dockable, this.title);
        handle.updateDisplayer();
        return handle;
    }

    private void addComponent(StationChildHandle handle) {
        this.mainPanel.dockablePane.add(handle.getDisplayer().getComponent());
        this.mainPanel.getContentPane().revalidate();
    }

    private void removeComponent(StationChildHandle handle) {
        this.mainPanel.dockablePane.remove(handle.getDisplayer().getComponent());
        this.mainPanel.getContentPane().revalidate();
    }

    public boolean drop(Dockable dockable, int column) {
        return this.drop(dockable, column, false);
    }

    public boolean drop(Dockable dockable, int column, boolean force) {
        if (force || this.accept(dockable)) {
            if (!force) {
                Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                if (replacement == null) {
                    return false;
                }
                if (replacement != dockable) {
                    replacement.asDockStation().drop(dockable);
                    dockable = replacement;
                }
            }
            this.add(dockable, column);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Dockable dockable, int column) {
        DockUtilities.ensureTreeValidity((DockStation)this, (Dockable)dockable);
        DockUtilities.checkLayoutLocked();
        Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
        if (replacement != dockable) {
            replacement.asDockStation().drop(dockable);
            dockable = replacement;
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking((DockStation)this, (Dockable)dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            dockable.setDockParent((DockStation)this);
            StationChildHandle handle = this.createHandle(dockable);
            int before = this.dockables.getColumnCount();
            this.dockables.insert(column, handle, false);
            this.addComponent(handle);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(dockable, before != this.dockables.getColumnCount());
        }
        finally {
            token.release();
        }
    }

    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("not a child of this station: " + dockable);
        }
        this.remove(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(Dockable dockable) {
        DockUtilities.checkLayoutLocked();
        int column = this.column(dockable);
        int before = this.dockables.getColumnCount();
        StationChildHandle handle = (StationChildHandle)this.dockables.get(dockable);
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking((DockStation)this, (Dockable)dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            this.dockables.remove(handle);
            this.removeComponent(handle);
            handle.destroy();
            dockable.setDockParent(null);
            this.listeners.fireDockableRemoved(dockable);
            this.fireColumnRepositioned(column, before != this.dockables.getColumnCount());
            this.mainPanel.repaint();
        }
        finally {
            token.release();
        }
    }

    public void replace(Dockable old, Dockable next) {
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        if (controller != null) {
            controller.freezeLayout();
        }
        int column = this.dockables.getColumn(old);
        int line = this.dockables.getLine(old);
        int beforeCount = this.dockables.getColumnCount();
        this.remove(old);
        if (beforeCount != this.dockables.getColumnCount()) {
            this.add(next, column);
        } else {
            this.add(next, column, line);
        }
        controller.meltLayout();
    }

    @Override
    public boolean canReplace(Dockable old, Dockable next) {
        return this.acceptable(next) && this.getToolbarStrategy().isToolbarGroupPartParent(this, next, true);
    }

    protected void fireDockablesRepositioned(Dockable dockable) {
        this.fireDockablesRepositioned(dockable, false);
    }

    protected void fireDockablesRepositioned(Dockable dockable, boolean all) {
        this.fireColumnRepositioned(this.column(dockable), all);
    }

    protected void fireColumnRepositioned(int column, boolean all) {
        ArrayList<Dockable> list = new ArrayList<Dockable>();
        int end = all ? this.dockables.getColumnCount() : column + 1;
        for (int i = column; i < end; ++i) {
            Iterator items = this.dockables.getColumnContent(i);
            while (items.hasNext()) {
                list.add(((StationChildHandle)items.next()).getDockable());
            }
        }
        if (list.size() > 0) {
            this.listeners.fireDockablesRepositioned(list.toArray(new Dockable[list.size()]));
        }
    }

    public ColumnDockActionSource getExpandActionSource() {
        return this.expander.getActions();
    }

    public ToolbarGroupHeaderFactory getHeaderComponentFactory() {
        return (ToolbarGroupHeaderFactory)this.headerFactory.getValue();
    }

    public void setHeaderComponentFactory(ToolbarGroupHeaderFactory factory) {
        this.headerFactory.setValue((Object)factory);
    }

    public ToolbarGroupHeader getHeaderComponent() {
        return this.groupHeader;
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme((DockStation)this, (DockFactory)new ToolbarGroupDockStationFactory());
    }

    @Override
    protected DefaultDisplayerFactoryValue createDisplayerFactory() {
        return new DefaultDisplayerFactoryValue("dock.displayer.toolbar.group", (DockStation)this);
    }

    @Override
    protected DockTitleVersion registerTitle(DockController controller) {
        return controller.getDockTitleManager().getVersion("toolbar.group", BasicDockTitleFactory.FACTORY);
    }

    @Override
    protected void discard(DockableDisplayer displayer) {
        Dockable dockable = displayer.getDockable();
        StationChildHandle handle = (StationChildHandle)this.dockables.get(dockable);
        if (handle == null) {
            throw new IllegalArgumentException("displayer is not child of this station: " + displayer);
        }
        this.removeComponent(handle);
        handle.updateDisplayer();
        this.addComponent(handle);
    }

    private void resetScrollbars() {
        for (Map.Entry<Integer, ColumnScrollBar> entry : this.scrollbars.entrySet()) {
            ColumnScrollBar replacement = ((ColumnScrollBarFactory)this.scrollbarFactory.getValue()).create(this);
            this.mainPanel.dockablePane.remove(entry.getValue().getComponent());
            entry.setValue(replacement);
            this.mainPanel.dockablePane.add(entry.getValue().getComponent());
        }
    }

    private void setDividerStrategy(ToolbarGroupDividerStrategy dividerStrategy) {
        this.dividerStrategy = dividerStrategy;
        this.layoutManager.setDividerStrategy(dividerStrategy);
        this.mainPanel.revalidate();
    }

    public Rectangle getDropGapBoundaries() {
        if (this.dropInfo == null) {
            return null;
        }
        JPanel dockablePane = this.mainPanel.dockablePane;
        Point zero = new Point(0, 0);
        zero = SwingUtilities.convertPoint(dockablePane, zero, (Component)((Object)this.mainPanel));
        Rectangle gapBounds = this.dropInfo.getLine() == -1 ? this.layoutManager.getGapBounds(this.dropInfo.getColumn(), false) : this.layoutManager.getGapBounds(this.dropInfo.getColumn(), this.dropInfo.getLine());
        gapBounds.x += zero.x;
        gapBounds.y += zero.y;
        return gapBounds;
    }

    public PlaceholderMap getPlaceholders() {
        PlaceholderMap map = this.dockables.toMap();
        this.writeLayoutArguments(map);
        return map;
    }

    public PlaceholderMap getPlaceholders(Map<Dockable, Integer> identifiers) {
        PlaceholderMap map = this.dockables.toMap(identifiers);
        this.writeLayoutArguments(map);
        return map;
    }

    public PlaceholderMapping getPlaceholderMapping() {
        return new ToolbarGroupPlaceholderMapping(this, this.dockables);
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        this.dockables.fromMap(placeholders);
        this.readLayoutArguments(placeholders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap placeholders, Map<Integer, Dockable> children) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("this station still has children");
        }
        DockController controller = this.getController();
        this.readLayoutArguments(placeholders);
        try {
            if (controller != null) {
                controller.freezeLayout();
            }
            this.dockables.setStrategy(null);
            this.dockables.unbind();
            this.dockables.fromMap(placeholders, children, new PlaceholderToolbarGridConverter<Dockable, StationChildHandle>(){

                @Override
                public StationChildHandle convert(Dockable dockable, ConvertedPlaceholderListItem item) {
                    ToolbarGroupDockStation.this.listeners.fireDockableAdding(dockable);
                    dockable.setDockParent((DockStation)ToolbarGroupDockStation.this);
                    StationChildHandle handle = ToolbarGroupDockStation.this.createHandle(dockable);
                    ToolbarGroupDockStation.this.addComponent(handle);
                    return handle;
                }

                @Override
                public void added(StationChildHandle item) {
                    ToolbarGroupDockStation.this.listeners.fireDockableAdded(item.getDockable());
                }
            });
            if (controller != null) {
                this.dockables.bind();
            }
            this.dockables.setStrategy((PlaceholderStrategy)this.placeholderStrategy.getValue());
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
        }
    }

    private void writeLayoutArguments(PlaceholderMap map) {
        ToolbarGroupDockStationLayout.writeOrientation(map, this.getOrientation());
    }

    private void readLayoutArguments(PlaceholderMap map) {
        Orientation orientation = ToolbarGroupDockStationLayout.readOrientation(map);
        if (orientation != null) {
            this.setOrientation(orientation);
        }
    }

    public DockableProperty getDockableProperty(Dockable child, Dockable target) {
        int column = this.column(child);
        int line = this.line(child);
        if (target == null) {
            target = child;
        }
        PlaceholderStrategy strategy = (PlaceholderStrategy)this.placeholderStrategy.getValue();
        Path placeholder = null;
        if (strategy != null && (placeholder = strategy.getPlaceholderFor(target)) != null && column >= 0 && line >= 0) {
            this.dockables.addPlaceholder(column, line, placeholder);
        }
        return new ToolbarGroupProperty(column, line, placeholder);
    }

    public void aside(AsideRequest request) {
        DockableProperty location = request.getLocation();
        int column = -1;
        int line = -1;
        Path newPlaceholder = request.getPlaceholder();
        if (location instanceof ToolbarGroupProperty) {
            ToolbarGroupProperty groupLocation = (ToolbarGroupProperty)location;
            Path placeholder = groupLocation.getPlaceholder();
            if (placeholder != null) {
                column = this.dockables.getColumn(placeholder);
            }
            if (column == -1) {
                placeholder = null;
                column = groupLocation.getColumn();
            }
            int totalColumnCount = this.dockables.getTotalColumnCount();
            column = Math.max(0, Math.min(column, totalColumnCount));
            if (placeholder != null && column < totalColumnCount) {
                line = this.dockables.getLine(column, placeholder);
            } else if (column == totalColumnCount) {
                line = 0;
            }
            if (line == -1) {
                line = groupLocation.getLine();
                line = Math.max(0, Math.min(line, this.dockables.getLineCount(column)));
            }
            if (groupLocation.getSuccessor() == null) {
                if (newPlaceholder != null) {
                    this.dockables.insertPlaceholder(column, line, newPlaceholder);
                }
            } else if (newPlaceholder != null) {
                AsideAnswer answer;
                this.dockables.addPlaceholder(column, line, newPlaceholder);
                Dockable existing = (Dockable)this.dockables.getModel().getColumn(column).getDockable(line);
                if (existing.asDockStation() != null && (answer = request.forward(existing.asDockStation())).isCanceled()) {
                    return;
                }
            }
        } else {
            column = 0;
            line = this.dockables.getColumnCount() > 0 ? this.dockables.getLineCount(column) : 0;
        }
        request.answer((DockableProperty)new ToolbarGroupProperty(column, line, newPlaceholder));
    }

    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof ToolbarGroupProperty) {
            return this.drop(dockable, (ToolbarGroupProperty)property);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, ToolbarGroupProperty property) {
        DockStation child;
        Path placeholder = property.getPlaceholder();
        int column = property.getColumn();
        int line = property.getLine();
        if (placeholder != null) {
            if (this.dockables.hasPlaceholder(placeholder)) {
                StationChildHandle child2 = (StationChildHandle)this.dockables.get(placeholder);
                if (child2 == null) {
                    if (this.acceptable(dockable)) {
                        Dockable replacement = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                        if (replacement == null) {
                            return false;
                        }
                        DockController controller = this.getController();
                        if (controller != null) {
                            controller.freezeLayout();
                        }
                        try {
                            this.dropAt(replacement, placeholder);
                            if (replacement != dockable) {
                                if (property.getSuccessor() != null) {
                                    if (!replacement.asDockStation().drop(dockable, property.getSuccessor())) {
                                        replacement.asDockStation().drop(dockable);
                                    }
                                } else {
                                    replacement.asDockStation().drop(dockable);
                                }
                            }
                        }
                        finally {
                            if (controller != null) {
                                controller.meltLayout();
                            }
                        }
                        return true;
                    }
                } else {
                    if (this.drop(child2, dockable, property)) {
                        return true;
                    }
                    column = this.dockables.getColumn(child2.getDockable());
                    line = this.dockables.getLine(column, child2.getDockable()) + 1;
                }
            }
        } else if (column >= 0 && column < this.columnCount() && line >= 0 && line < this.lineCount(column) && (child = this.getDockable(column, line).asDockStation()) != null && child.drop(dockable, property.getSuccessor())) {
            return true;
        }
        if (!this.acceptable(dockable)) {
            return false;
        }
        line = Math.max(0, line);
        return this.drop(dockable, column, line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAt(Dockable dockable, Path placeholder) {
        DockUtilities.checkLayoutLocked();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking((DockStation)this, (Dockable)dockable);
        try {
            DockUtilities.ensureTreeValidity((DockStation)this, (Dockable)dockable);
            this.listeners.fireDockableAdding(dockable);
            int before = this.dockables.getColumnCount();
            dockable.setDockParent((DockStation)this);
            StationChildHandle handle = this.createHandle(dockable);
            this.dockables.put(placeholder, handle);
            this.addComponent(handle);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(dockable, before != this.dockables.getColumnCount());
        }
        finally {
            token.release();
        }
    }

    private boolean drop(StationChildHandle parent, Dockable child, ToolbarGroupProperty property) {
        if (property.getSuccessor() == null) {
            return false;
        }
        DockStation station = parent.getDockable().asDockStation();
        if (station == null) {
            return false;
        }
        return station.drop(child, property.getSuccessor());
    }

    public void move(Dockable dockable, DockableProperty property) {
        if (property instanceof ToolbarGroupProperty) {
            this.move(dockable, (ToolbarGroupProperty)property);
        }
    }

    private void move(Dockable dockable, ToolbarGroupProperty property) {
        int line;
        int column;
        int sourceColumn = this.column(dockable);
        int sourceLine = this.line(dockable);
        boolean empty = false;
        int destinationColumn = property.getColumn();
        int destinationLine = property.getLine();
        Path placeholder = property.getPlaceholder();
        if (placeholder != null && (column = this.dockables.getColumn(placeholder)) != -1 && (line = this.dockables.getLine(column, placeholder)) != -1) {
            empty = true;
            destinationColumn = column;
            destinationLine = line;
        }
        if (!empty) {
            destinationLine = (destinationColumn = Math.min(destinationColumn, this.dockables.getColumnCount())) == this.dockables.getColumnCount() || destinationColumn == -1 ? 0 : Math.min(destinationLine, this.dockables.getLineCount(destinationColumn));
        }
        PlaceholderList.Level level = empty ? PlaceholderList.Level.BASE : PlaceholderList.Level.DOCKABLE;
        this.dockables.move(sourceColumn, sourceLine, destinationColumn, destinationLine, level);
        this.mainPanel.getContentPane().revalidate();
    }

    protected class OverpaintablePanelBase
    extends SecureContainer {
        private static final long serialVersionUID = -4399008463139189130L;
        private final JPanel dockablePane = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (ToolbarGroupDockStation.this.dividerStrategy != null) {
                    ToolbarGroupDockStation.this.dividerStrategy.paint(this, g, ToolbarGroupDockStation.this.layoutManager);
                }
            }
        };
        private JPanel decorationPane = ToolbarGroupDockStation.this.createBackgroundPanel();

        public OverpaintablePanelBase() {
            this.setBasePane(this.decorationPane);
            this.setSolid(false);
            this.decorationPane.setOpaque(false);
            this.dockablePane.setOpaque(false);
            this.decorationPane.setLayout(new BorderLayout());
            this.decorationPane.add((Component)this.dockablePane, "Center");
        }

        public void addHeaderComponent(Component header) {
            if (ToolbarGroupDockStation.this.getOrientation() == Orientation.HORIZONTAL) {
                this.decorationPane.add(header, "West");
            } else {
                this.decorationPane.add(header, "North");
            }
        }

        public void removeHeaderCopmonent(Component header) {
            this.decorationPane.remove(header);
        }

        public Dimension getPreferredSize() {
            if (this.dockablePane != null && !this.dockablePane.isValid()) {
                this.dockablePane.doLayout();
            }
            return this.getBasePane().getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getBasePane().getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getBasePane().getPreferredSize();
        }

        public void updateAlignment() {
            Orientation orientation = ToolbarGroupDockStation.this.getOrientation();
            if (orientation != null) {
                if (ToolbarGroupDockStation.this.layoutManager != null) {
                    ToolbarGroupDockStation.this.layoutManager.setController(null);
                }
                ToolbarGroupDockStation.this.layoutManager = new ToolbarGridLayoutManager<StationChildHandle>((Container)this.dockablePane, orientation, ToolbarGroupDockStation.this.dockables, ToolbarGroupDockStation.this){

                    @Override
                    protected Component toComponent(StationChildHandle item) {
                        return item.getDisplayer().getComponent();
                    }

                    @Override
                    protected void setShowScrollbar(int column, boolean show) {
                        boolean change = false;
                        if (show) {
                            if (!ToolbarGroupDockStation.this.scrollbars.containsKey(column)) {
                                ColumnScrollBar bar = ((ColumnScrollBarFactory)ToolbarGroupDockStation.this.scrollbarFactory.getValue()).create(ToolbarGroupDockStation.this);
                                bar.setOrientation(ToolbarGroupDockStation.this.getOrientation());
                                ToolbarGroupDockStation.this.scrollbars.put(column, bar);
                                OverpaintablePanelBase.this.dockablePane.add(bar.getComponent());
                                bar.addAdjustmentListener(ToolbarGroupDockStation.this.adjustmentListener);
                                change = true;
                            }
                        } else {
                            ColumnScrollBar bar = (ColumnScrollBar)ToolbarGroupDockStation.this.scrollbars.remove(column);
                            if (bar != null) {
                                OverpaintablePanelBase.this.dockablePane.remove(bar.getComponent());
                                bar.removeAdjustmentListener(ToolbarGroupDockStation.this.adjustmentListener);
                                change = true;
                            }
                        }
                        if (change) {
                            OverpaintablePanelBase.this.revalidateLater();
                        }
                    }

                    @Override
                    protected int getScrollbarValue(int column, int required, int available) {
                        ColumnScrollBar scrollbar = (ColumnScrollBar)ToolbarGroupDockStation.this.scrollbars.get(column);
                        if (scrollbar == null) {
                            return 0;
                        }
                        scrollbar.setValues(required, available);
                        return scrollbar.getValue();
                    }

                    @Override
                    protected Component getScrollbar(int column) {
                        ColumnScrollBar scrollbar = (ColumnScrollBar)ToolbarGroupDockStation.this.scrollbars.get(column);
                        if (scrollbar == null) {
                            return null;
                        }
                        return scrollbar.getComponent();
                    }
                };
                this.dockablePane.setLayout(ToolbarGroupDockStation.this.layoutManager);
                ToolbarGroupDockStation.this.layoutManager.setDividerStrategy(ToolbarGroupDockStation.this.dividerStrategy);
                ToolbarGroupDockStation.this.layoutManager.setController(this.getController());
            }
            ToolbarGroupDockStation.this.mainPanel.revalidate();
        }

        private void revalidateLater() {
            if (ToolbarGroupDockStation.this.orientation == Orientation.VERTICAL) {
                final int height = this.decorationPane.getHeight();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (height == OverpaintablePanelBase.this.decorationPane.getHeight()) {
                            OverpaintablePanelBase.this.decorationPane.revalidate();
                        }
                    }
                });
            } else {
                final int width = this.decorationPane.getWidth();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (width == OverpaintablePanelBase.this.decorationPane.getWidth()) {
                            OverpaintablePanelBase.this.decorationPane.revalidate();
                        }
                    }
                });
            }
        }

        protected void paintOverlay(Graphics g) {
            Graphics2D g2D = (Graphics2D)g;
            this.paintDrag(g);
            if (ToolbarGroupDockStation.this.dropInfo != null && ToolbarGroupDockStation.this.dropInfo.hasEffect()) {
                Point zero = new Point(0, 0);
                zero = SwingUtilities.convertPoint(this.dockablePane, zero, (Component)((Object)this));
                Rectangle gapBounds = ToolbarGroupDockStation.this.getDropGapBoundaries();
                ToolbarGroupDockStation.this.paint.drawInsertion((Graphics)g2D, new Rectangle(zero.x, zero.y, this.dockablePane.getWidth(), this.dockablePane.getHeight()), gapBounds);
            }
        }

        private void paintDrag(Graphics g) {
            StationChildHandle handle;
            Dockable removal = ToolbarGroupDockStation.this.getRemoval();
            if (removal != null && (handle = ToolbarGroupDockStation.this.getHandle(removal)) != null) {
                Rectangle bounds = handle.getDisplayer().getComponent().getBounds();
                JPanel dockablePane = ((ToolbarGroupDockStation)ToolbarGroupDockStation.this).mainPanel.dockablePane;
                Point zero = new Point(0, 0);
                zero = SwingUtilities.convertPoint(dockablePane, zero, (Component)((Object)this));
                bounds.x += zero.x;
                bounds.y += zero.y;
                ToolbarGroupDockStation.this.getPaint().drawRemoval(g, bounds, bounds);
            }
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }
}

