/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import bibliothek.gui.dock.wizard.WizardNodeMap;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Dimension;

public class WizardSpanStrategy {
    private WizardSplitDockStation station;
    private Span[][] cellSpans = new Span[0][0];
    private Span[] columnSpans = new Span[0];
    private StationSpanFactoryValue factory;
    private int selectedColumn = -1;
    private int selectedCell = -1;

    public WizardSpanStrategy(WizardSplitDockStation station) {
        this.station = station;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.wizard", (DockStation)station){

            protected void changed() {
                WizardSpanStrategy.this.reset();
            }
        };
        station.addDockStationListener((DockStationListener)new DockStationAdapter(){

            public void dockableAdded(DockStation station, Dockable dockable) {
                WizardSpanStrategy.this.checkReset();
            }

            public void dockableRemoved(DockStation station, Dockable dockable) {
                WizardSpanStrategy.this.checkReset();
            }

            public void dockablesRepositioned(DockStation station, Dockable[] dockables) {
                WizardSpanStrategy.this.checkReset();
            }
        });
    }

    public void setController(DockController controller) {
        this.factory.setController(controller);
    }

    private void checkReset() {
        WizardNodeMap map = this.station.getWizardSplitLayoutManager().getMap();
        WizardNodeMap.Column[] columns = map.getSortedColumns();
        if (columns.length != this.columnSpans.length - 1) {
            this.reset();
        } else {
            for (int i = 0; i < columns.length; ++i) {
                if (this.cellSpans[i].length - 1 == columns[i].getCellCount()) continue;
                this.reset();
                return;
            }
        }
    }

    public void reset() {
        int i;
        this.selectedColumn = -1;
        this.selectedCell = -1;
        WizardNodeMap map = this.station.getWizardSplitLayoutManager().getMap();
        WizardNodeMap.Column[] columns = map.getSortedColumns();
        this.columnSpans = new Span[columns.length + 1];
        this.cellSpans = new Span[columns.length][];
        Callback columnCallback = new Callback(true);
        Callback cellCallback = new Callback(false);
        int gap = this.station.getDividerSize();
        for (i = 0; i < this.columnSpans.length; ++i) {
            this.columnSpans[i] = this.factory.create((SpanCallback)columnCallback);
        }
        for (i = 1; i < columns.length; ++i) {
            this.columnSpans[i].configureSize(SpanMode.OFF, gap);
        }
        for (i = 0; i < columns.length; ++i) {
            int j;
            int cellCount = columns[i].getCellCount();
            this.cellSpans[i] = new Span[cellCount + 1];
            for (j = 0; j < this.cellSpans[i].length; ++j) {
                this.cellSpans[i][j] = this.factory.create((SpanCallback)cellCallback);
            }
            for (j = 1; j < cellCount; ++j) {
                this.cellSpans[i][j].configureSize(SpanMode.OFF, gap);
            }
        }
    }

    public void setPut(PutInfo info) {
        if (info == null || info.getCombinerTarget() != null) {
            this.setPut(-1, -1);
        } else if (info.getNode() == null) {
            this.setPut(0, -1);
        } else {
            WizardNodeMap map = this.station.getWizardSplitLayoutManager().getMap();
            SplitNode node = info.getNode();
            node = this.traverseDown(node);
            WizardNodeMap.Column column = map.getColumn(node);
            Dimension size = info.getDockable().getComponent().getPreferredSize();
            int width = size.width;
            int height = size.height;
            if (this.station.getSide().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                WizardNodeMap.Cell cell;
                for (Span span : this.columnSpans) {
                    span.configureSize(SpanMode.OPEN, width);
                }
                Span[] spanArray = this.cellSpans;
                int n = spanArray.length;
                for (int i = 0; i < n; ++i) {
                    Span array;
                    for (Span span : array = spanArray[i]) {
                        span.configureSize(SpanMode.OPEN, height);
                    }
                }
                if (info.getPut() == PutInfo.Put.LEFT) {
                    this.setPut(column.getIndex(), -1);
                } else if (info.getPut() == PutInfo.Put.RIGHT) {
                    this.setPut(column.getIndex() + 1, -1);
                } else if (info.getPut() == PutInfo.Put.TOP) {
                    cell = column.getLeftmostCell(node);
                    this.setPut(column.getIndex(), cell.getIndex());
                } else if (info.getPut() == PutInfo.Put.BOTTOM) {
                    cell = column.getRightmostCell(node);
                    this.setPut(column.getIndex(), cell.getIndex() + 1);
                }
            } else {
                for (Span span : this.columnSpans) {
                    span.configureSize(SpanMode.OPEN, height);
                }
                Object cell = this.cellSpans;
                int n = ((Span[])cell).length;
                for (int i = 0; i < n; ++i) {
                    Span array;
                    for (Span span : array = cell[i]) {
                        span.configureSize(SpanMode.OPEN, width);
                    }
                }
                if (info.getPut() == PutInfo.Put.LEFT) {
                    cell = column.getLeftmostCell(node);
                    this.setPut(column.getIndex(), ((WizardNodeMap.Cell)cell).getIndex());
                } else if (info.getPut() == PutInfo.Put.RIGHT) {
                    cell = column.getRightmostCell(node);
                    this.setPut(column.getIndex(), ((WizardNodeMap.Cell)cell).getIndex() + 1);
                } else if (info.getPut() == PutInfo.Put.TOP) {
                    this.setPut(column.getIndex(), -1);
                } else if (info.getPut() == PutInfo.Put.BOTTOM) {
                    this.setPut(column.getIndex() + 1, -1);
                }
            }
        }
    }

    private SplitNode traverseDown(SplitNode node) {
        while (node instanceof Node) {
            Node n = (Node)node;
            boolean left = n.getLeft().isVisible();
            boolean right = n.getRight().isVisible();
            if (!left && right) {
                node = n.getRight();
                continue;
            }
            if (!left || right) break;
            node = n.getLeft();
        }
        return node;
    }

    private void setPut(int column, int cell) {
        int i;
        this.selectedColumn = column;
        this.selectedCell = cell;
        for (i = 0; i < this.columnSpans.length; ++i) {
            if (i == column && cell == -1) {
                this.columnSpans[i].mutate(SpanMode.OPEN);
                continue;
            }
            this.columnSpans[i].mutate(SpanMode.OFF);
        }
        for (i = 0; i < this.cellSpans.length; ++i) {
            for (int j = 0; j < this.cellSpans[i].length; ++j) {
                if (i == column && j == cell) {
                    this.cellSpans[i][j].mutate(SpanMode.OPEN);
                    continue;
                }
                this.cellSpans[i][j].mutate(SpanMode.OFF);
            }
        }
    }

    public void unsetPut() {
        this.selectedColumn = -1;
        this.selectedCell = -1;
        for (Span span : this.columnSpans) {
            span.set(SpanMode.OFF);
        }
        Span[] spanArray = this.cellSpans;
        int n = spanArray.length;
        for (int i = 0; i < n; ++i) {
            Span array;
            for (Span span : array = spanArray[i]) {
                span.set(SpanMode.OFF);
            }
        }
    }

    public int getGap() {
        if (this.selectedColumn == -1) {
            return this.station.getDividerSize();
        }
        if (this.selectedCell == -1) {
            if (this.selectedColumn >= this.columnSpans.length) {
                return this.station.getDividerSize();
            }
            return this.getSize(this.columnSpans[this.selectedColumn]);
        }
        if (this.selectedColumn >= this.cellSpans.length) {
            return this.station.getDividerSize();
        }
        Span[] array = this.cellSpans[this.selectedColumn];
        if (this.selectedCell >= array.length) {
            return this.station.getDividerSize();
        }
        return this.getSize(array[this.selectedCell]);
    }

    public int getGap(int column) {
        if (column >= this.columnSpans.length) {
            return 0;
        }
        return this.getSize(this.columnSpans[column]);
    }

    public int getGap(int column, int cell) {
        if (column >= this.cellSpans.length) {
            return 0;
        }
        if (cell >= this.cellSpans[column].length) {
            return 0;
        }
        return this.getSize(this.cellSpans[column][cell]);
    }

    protected int getSize(Span span) {
        return span.getSize();
    }

    public int getGap(Node node, WizardNodeMap map) {
        WizardNodeMap.Column column = map.getColumn((SplitNode)node);
        if (column == null) {
            return 0;
        }
        for (SplitNode root = column.getRoot().getParent(); root != null; root = root.getParent()) {
            if (root != node) continue;
            return this.getGap(column.getIndex());
        }
        WizardNodeMap.Cell cell = column.getLeftmostCell(node.getRight());
        if (cell == null) {
            return this.getGap(column.getIndex());
        }
        return this.getGap(column.getIndex(), cell.getIndex());
    }

    private class Callback
    implements SpanCallback {
        private boolean column;

        public Callback(boolean column) {
            this.column = column;
        }

        public DockStation getStation() {
            return WizardSpanStrategy.this.station;
        }

        public boolean isHorizontal() {
            if (this.column) {
                return WizardSpanStrategy.this.station.getSide().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL;
            }
            return WizardSpanStrategy.this.station.getSide().getColumnOrientation() == SplitDockStation.Orientation.HORIZONTAL;
        }

        public boolean isVertical() {
            return !this.isHorizontal();
        }

        public void resized() {
            WizardSpanStrategy.this.station.revalidateOutside();
        }

        public SpanUsage getUsage() {
            return SpanUsage.INSERTING;
        }
    }
}

