/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.toolbar.expand;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ExpandableToolbarItemStrategy;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.magnet.MagnetizedOperation;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemStrategyListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;

public class ExpandManager {
    private final PropertyValue<ExpandableToolbarItemStrategy> strategy = new PropertyValue<ExpandableToolbarItemStrategy>(ExpandableToolbarItemStrategy.STRATEGY){

        protected void valueChanged(ExpandableToolbarItemStrategy oldValue, ExpandableToolbarItemStrategy newValue) {
            if (oldValue != null) {
                oldValue.removeExpandedListener(ExpandManager.this.listener);
            }
            if (newValue != null) {
                newValue.addExpandedListener(ExpandManager.this.listener);
            }
        }
    };
    private final ExpandableToolbarItemStrategyListener listener = new ExpandableToolbarItemStrategyListener(){

        @Override
        public void stretched(Dockable item) {
            ExpandManager.this.updateLater(item);
        }

        @Override
        public void shrunk(Dockable item) {
            ExpandManager.this.updateLater(item);
        }

        @Override
        public void expanded(Dockable item) {
            ExpandManager.this.updateLater(item);
        }

        @Override
        public void enablementChanged(Dockable item, ExpandedState state, boolean enabled) {
        }
    };

    public ExpandManager(DockController controller) {
        this.strategy.setProperties(controller);
    }

    private void updateLater(final Dockable item) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExpandManager.this.update(item);
            }
        });
    }

    public void update(Dockable item) {
        DockStation parent = item.getDockParent();
        while (parent != null) {
            if (parent instanceof ScreenDockStation) {
                this.update((ScreenDockStation)parent, item);
            }
            if ((item = parent.asDockable()) == null) {
                parent = null;
                continue;
            }
            parent = item.getDockParent();
        }
    }

    protected void update(ScreenDockStation station, Dockable child) {
        ScreenDockWindow window = station.getWindow(child);
        Insets insets = window.getDockableInsets();
        Dimension preferred = child.getComponent().getPreferredSize();
        int width = insets.left + insets.right + preferred.width;
        int height = insets.top + insets.bottom + preferred.height;
        Rectangle bounds = window.getNormalBounds();
        if (bounds == null) {
            bounds = window.getWindowBounds();
        }
        bounds = new Rectangle(bounds.x, bounds.y, width, height);
        MagnetizedOperation operation = station.getMagnetController().start(window);
        Rectangle validated = station.getBoundaryRestriction().check(window, bounds);
        if (validated != null) {
            bounds = validated;
        }
        bounds = operation.attract(bounds);
        operation.stop();
        if (window.isFullscreen()) {
            window.setNormalBounds(bounds);
        } else {
            window.setWindowBounds(bounds);
        }
    }
}

