/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenu;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import java.awt.Component;

public abstract class AbstractCustomizationMenu
implements CustomizationMenu {
    private int x;
    private int y;
    private CustomizationMenuContent content;
    private CustomizationMenuCallback callback;
    private DockController controller;

    @Override
    public CustomizationMenuContent getContent() {
        return this.content;
    }

    @Override
    public void setContent(CustomizationMenuContent content) {
        if (this.content != content) {
            if (this.isOpen()) {
                CustomizationMenuCallback callback = this.getCallback();
                this.close();
                if (this.content != null) {
                    this.content.setController(null);
                }
                this.content = content;
                if (content != null) {
                    content.setController(this.controller);
                    this.open(this.x, this.y, callback);
                }
            } else {
                if (this.content != null) {
                    this.content.setController(null);
                }
                this.content = content;
                if (content != null) {
                    content.setController(this.controller);
                }
            }
        }
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        if (this.content != null) {
            this.content.setController(controller);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public boolean isOpen() {
        return this.callback != null;
    }

    public CustomizationMenuCallback getCallback() {
        return this.callback;
    }

    @Override
    public void open(int x, int y, CustomizationMenuCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException();
        }
        if (this.content == null) {
            throw new IllegalStateException("the menu has no content and cannot be opened");
        }
        if (this.callback != null) {
            this.close();
        }
        this.callback = callback;
        this.content.bind(callback);
        this.x = x;
        this.y = y;
        this.doOpen(x, y, this.content.getView());
    }

    @Override
    public void close() {
        this.doClose();
        this.closed();
    }

    protected void closed() {
        if (this.callback != null) {
            this.callback.closed();
            this.callback = null;
            if (this.content != null) {
                this.content.unbind();
            }
        }
    }

    protected abstract void doOpen(int var1, int var2, Component var3);

    protected abstract void doClose();
}

