/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layer;

import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class ToolbarGroupInnerLayer
implements DockStationDropLayer {
    private final ToolbarGroupDockStation station;
    private LayerPriority priority = LayerPriority.BASE;
    private Component component;

    public ToolbarGroupInnerLayer(ToolbarGroupDockStation station, Component component) {
        this.station = station;
        this.component = component;
    }

    public boolean canCompare(DockStationDropLayer layer) {
        return false;
    }

    public int compare(DockStationDropLayer layer) {
        return 0;
    }

    public boolean contains(int x, int y) {
        Rectangle bound;
        int i;
        Point mouseCoord = new Point(x, y);
        SwingUtilities.convertPointFromScreen(mouseCoord, this.component);
        ToolbarGridLayoutManager<StationChildHandle> layout = this.station.getLayoutManager();
        if (this.station.columnCount() == 0) {
            return this.component.contains(mouseCoord);
        }
        int count = this.station.columnCount();
        for (i = 0; i < count; ++i) {
            bound = layout.getBounds(i);
            if (!bound.contains(mouseCoord)) continue;
            return true;
        }
        for (i = 0; i <= count; ++i) {
            bound = layout.getGapBounds(i, true);
            if (!bound.contains(mouseCoord)) continue;
            return true;
        }
        return false;
    }

    public Component getComponent() {
        return this.component;
    }

    public LayerPriority getPriority() {
        return this.priority;
    }

    public void setPriority(LayerPriority priority) {
        this.priority = priority;
    }

    public ToolbarGroupDockStation getStation() {
        return this.station;
    }

    public DockStationDropLayer modify(DockStationDropLayer child) {
        return child;
    }
}

