/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.window.AbstractScreenWindowShape;
import bibliothek.gui.dock.station.screen.window.ScreenWindowShapeCallback;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManagerListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.SwingUtilities;

public class ToolbarScreenWindowShape
extends AbstractScreenWindowShape {
    private ToolbarGroupDockStation station;
    private boolean reshapePending = false;
    private ToolbarGridLayoutManagerListener listener = new ToolbarGridLayoutManagerListener(){

        @Override
        public void didLayout(Container container) {
            ToolbarScreenWindowShape.this.reshape();
        }
    };

    public void setCallback(ScreenWindowShapeCallback callback) {
        this.uninstall();
        super.setCallback(callback);
    }

    private void uninstall() {
        if (this.station != null) {
            this.station.getLayoutManager().removeListener(this.listener);
            this.station = null;
        }
    }

    private void install(ToolbarGroupDockStation station) {
        this.station = station;
        station.getLayoutManager().addListener(this.listener);
    }

    protected Shape getShape() {
        Dockable dockable;
        if (this.station == null && (dockable = this.getCallback().getWindow().getDockable()) instanceof ToolbarGroupDockStation) {
            this.install((ToolbarGroupDockStation)dockable);
        }
        if (this.station == null) {
            return null;
        }
        Area area = new Area();
        this.addBorder(area);
        this.addChildren(area);
        this.addExpanded(area);
        return area;
    }

    private void addBorder(Area area) {
        ScreenDockWindow window = this.getCallback().getWindow();
        Insets insets = window.getDockableInsets();
        Dimension size = window.getWindowBounds().getSize();
        if (insets.top > 0) {
            area.add(new Area(new Rectangle(0, 0, size.width, insets.top)));
        }
        if (insets.bottom > 0) {
            area.add(new Area(new Rectangle(0, size.height - insets.bottom - 1, size.width, insets.bottom)));
        }
        if (insets.left > 0) {
            area.add(new Area(new Rectangle(0, 0, insets.left, size.height)));
        }
        if (insets.right > 0) {
            area.add(new Area(new Rectangle(size.width - insets.right - 1, 0, insets.right, size.height)));
        }
    }

    private void addChildren(Area area) {
        ScreenDockWindow window = this.getCallback().getWindow();
        Insets insets = window.getDockableInsets();
        int n = this.station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable dockable = this.station.getDockable(i);
            Point zero = new Point(0, 0);
            zero = SwingUtilities.convertPoint(dockable.getComponent(), zero, this.station.getComponent());
            zero.x += insets.left;
            zero.y += insets.top;
            Dimension size = dockable.getComponent().getSize();
            area.add(new Area(new Rectangle(zero.x - 1, zero.y - 1, size.width + 2, size.height + 2)));
            for (DockTitle title : dockable.listBoundTitles()) {
                if (!SwingUtilities.isDescendingFrom(title.getComponent(), this.station.getComponent())) continue;
                Point titleZero = new Point(0, 0);
                titleZero = SwingUtilities.convertPoint(title.getComponent(), titleZero, dockable.getComponent());
                titleZero.x += zero.x;
                titleZero.y += zero.y;
                size = title.getComponent().getSize();
                area.add(new Area(new Rectangle(titleZero.x - 1, titleZero.y - 1, size.width + 2, size.height + 2)));
            }
        }
    }

    private void addExpanded(Area area) {
        Rectangle dropGap = this.station.getDropGapBoundaries();
        if (dropGap != null) {
            ScreenDockWindow window = this.getCallback().getWindow();
            Insets insets = window.getDockableInsets();
            dropGap.x += insets.left;
            dropGap.y += insets.top;
            area.add(new Area(dropGap));
        }
    }

    public void reshape() {
        this.reshapePending = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ToolbarScreenWindowShape.this.reshapePending) {
                    ToolbarScreenWindowShape.this.reshapePending = false;
                    ToolbarScreenWindowShape.super.reshape();
                }
            }
        });
    }
}

