/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.title.DockTitleRequest;

public class CSplitDockStation
extends SplitDockStation
implements CommonDockStation<SplitDockStation, CSplitDockStation>,
CommonDockable {
    private CommonStationDelegate<CSplitDockStation> delegate;

    public CSplitDockStation(CommonStationDelegate<CSplitDockStation> delegate) {
        this.delegate = delegate;
        this.getDockable().addCDockablePropertyListener(new CDockableAdapter(){

            @Override
            public void titleShownChanged(CDockable dockable) {
                CSplitDockStation.this.fireTitleExchanged();
            }
        });
    }

    @Override
    public String getFactoryID() {
        return "CommonDockStationFactory";
    }

    @Override
    public String getConverterID() {
        return super.getFactoryID();
    }

    @Override
    public CDockable getDockable() {
        return this.delegate.getDockable();
    }

    @Override
    public CStation<CSplitDockStation> getStation() {
        return this.delegate.getStation();
    }

    @Override
    public SplitDockStation getDockStation() {
        return this;
    }

    @Override
    public CSplitDockStation asDockStation() {
        return this;
    }

    @Override
    public CommonDockable asDockable() {
        return this;
    }

    protected ListeningDockAction createFullScreenAction() {
        return null;
    }

    public void setNextFullScreen() {
        this.setFullScreen(null);
    }

    public void setFrontDockable(Dockable dockable) {
        if (!this.isFullScreen()) {
            super.setFrontDockable(dockable);
        }
    }

    @Override
    public DockActionSource[] getSources() {
        return this.delegate.getSources();
    }

    public void requestDockTitle(DockTitleRequest request) {
        if (this.delegate.isTitleDisplayed(request.getVersion())) {
            super.requestDockTitle(request);
        } else {
            request.answer(null);
        }
    }
}

