/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaAttributeModel;
import org.apache.xmlbeans.SchemaField;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaLocalAttribute;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.impl.common.Chars;
import org.apache.xmlbeans.impl.common.IdentityConstraint;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.common.ValidatorListener;
import org.apache.xmlbeans.impl.common.XmlWhitespace;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeVisitorImpl;
import org.apache.xmlbeans.impl.values.JavaBase64HolderEx;
import org.apache.xmlbeans.impl.values.JavaBooleanHolder;
import org.apache.xmlbeans.impl.values.JavaBooleanHolderEx;
import org.apache.xmlbeans.impl.values.JavaDecimalHolderEx;
import org.apache.xmlbeans.impl.values.JavaDoubleHolderEx;
import org.apache.xmlbeans.impl.values.JavaFloatHolderEx;
import org.apache.xmlbeans.impl.values.JavaHexBinaryHolderEx;
import org.apache.xmlbeans.impl.values.JavaQNameHolderEx;
import org.apache.xmlbeans.impl.values.JavaStringEnumerationHolderEx;
import org.apache.xmlbeans.impl.values.JavaUriHolderEx;
import org.apache.xmlbeans.impl.values.NamespaceContext;
import org.apache.xmlbeans.impl.values.XmlDateImpl;
import org.apache.xmlbeans.impl.values.XmlDurationImpl;
import org.apache.xmlbeans.impl.values.XmlListImpl;
import org.apache.xmlbeans.impl.values.XmlQNameImpl;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public final class Validator
implements ValidatorListener {
    private LinkedList _visitorPool = new LinkedList();
    private boolean _invalid;
    private SchemaType _rootType;
    private SchemaField _rootField;
    private SchemaTypeLoader _globalTypes;
    private Chars _chars;
    private State _stateStack;
    private int _errorState;
    private Collection _errorListener;
    private ValidatorVC _vc;
    private int _suspendErrors;
    private IdentityConstraint _constraintEngine;
    private int _eatContent;
    private SchemaLocalElement _localElement;
    private SchemaParticle _wildcardElement;
    private SchemaLocalAttribute _localAttribute;
    private SchemaAttributeModel _wildcardAttribute;
    private SchemaType _unionType;
    private String _stringValue;
    private BigDecimal _decimalValue;
    private boolean _booleanValue;
    private float _floatValue;
    private double _doubleValue;
    private QName _qnameValue;
    private GDate _gdateValue;
    private GDuration _gdurationValue;
    private byte[] _byteArrayValue;
    private List _listValue;
    private List _listTypes;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$xmlbeans$impl$validator$Validator;

    public Validator(SchemaType type, SchemaField field, SchemaTypeLoader globalLoader, XmlOptions options, Collection defaultErrorListener) {
        options = XmlOptions.maskNull(options);
        this._errorListener = (Collection)options.get("ERROR_LISTENER");
        if (this._errorListener == null) {
            this._errorListener = defaultErrorListener;
        }
        this._constraintEngine = new IdentityConstraint(this._errorListener, type.isDocumentType());
        this._globalTypes = globalLoader;
        this._chars = new Chars();
        this._rootType = type;
        this._rootField = field;
        this._vc = new ValidatorVC();
    }

    public boolean isValid() {
        return !this._invalid && this._constraintEngine.isValid();
    }

    private void emitError(ValidatorListener.Event event, String msg) {
        this.emitError(event, msg, 0);
    }

    private void emitError(ValidatorListener.Event event, String msg, int severity) {
        ++this._errorState;
        if (this._suspendErrors == 0) {
            if (severity == 0) {
                this._invalid = true;
            }
            if (this._errorListener != null) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError();
                }
                this._errorListener.add(XmlError.forCursor(msg, severity, event.getLocationAsCursor()));
            }
        }
    }

    private void emitFieldError(ValidatorListener.Event event, String msg, QName name) {
        this.emitFieldError(event, msg + " " + QNameHelper.pretty(name));
    }

    private void emitFieldError(ValidatorListener.Event event, String msg) {
        this.emitFieldError(event, msg, 0);
    }

    private void emitFieldError(ValidatorListener.Event event, String msg, int severity) {
        if (this._stateStack != null && this._stateStack._field != null) {
            msg = msg + " in element " + QNameHelper.pretty(this._stateStack._field.getName());
        }
        this.emitError(event, msg, severity);
    }

    public void error(XmlError error) {
        ++this._errorState;
        if (this._suspendErrors == 0) {
            this._invalid = true;
            if (this._errorListener != null) {
                this._errorListener.add(error);
            }
        }
    }

    public void nextEvent(int kind, ValidatorListener.Event event) {
        this.resetValues();
        if (this._eatContent > 0) {
            switch (kind) {
                case 2: {
                    --this._eatContent;
                    break;
                }
                case 1: {
                    ++this._eatContent;
                }
            }
        } else {
            if (!$assertionsDisabled && kind != 1 && kind != 4 && kind != 2 && kind != 3 && kind != 5) {
                throw new AssertionError();
            }
            switch (kind) {
                case 1: {
                    this.beginEvent(event);
                    break;
                }
                case 4: {
                    this.attrEvent(event);
                    break;
                }
                case 5: {
                    this.endAttrsEvent(event);
                    break;
                }
                case 3: {
                    this.textEvent(event);
                    break;
                }
                case 2: {
                    this.endEvent(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginEvent(ValidatorListener.Event event) {
        SchemaLocalElement sle;
        this._localElement = null;
        this._wildcardElement = null;
        String message = null;
        State state = this.topState();
        Object elementType = null;
        SchemaField elementField = null;
        if (state == null) {
            elementType = this._rootType;
            elementField = this._rootField;
        } else {
            SchemaParticle currentParticle;
            QName name = event.getName();
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            state._isEmpty = false;
            if (state._isNil) {
                this.emitFieldError(event, "Nil element cannot have element content");
                this._eatContent = 1;
                return;
            }
            if (!state.visit(name)) {
                message = this.findDetailedErrorBegin(state, name);
                if (message != null) {
                    this.emitFieldError(event, message);
                    message = null;
                } else {
                    this.emitFieldError(event, "Element not allowed:", name);
                }
                this._eatContent = 1;
                return;
            }
            this._wildcardElement = currentParticle = state.currentParticle();
            if (currentParticle.getParticleType() == 5) {
                QNameSet elemWildcardSet = currentParticle.getWildcardSet();
                if (!elemWildcardSet.contains(name)) {
                    this.emitFieldError(event, "Element not allowed:", name);
                    this._eatContent = 1;
                    return;
                }
                int wildcardProcess = currentParticle.getWildcardProcess();
                if (wildcardProcess == 3) {
                    this._eatContent = 1;
                    return;
                }
                this._localElement = this._globalTypes.findElement(name);
                elementField = this._localElement;
                if (elementField == null) {
                    if (wildcardProcess == 1) {
                        this.emitFieldError(event, "Element not allowed (strict wildcard, and no definition found):", name);
                    }
                    this._eatContent = 1;
                    return;
                }
            } else {
                if (!$assertionsDisabled && currentParticle.getParticleType() != 4) {
                    throw new AssertionError();
                }
                if (!currentParticle.getName().equals(name)) {
                    if (((SchemaLocalElement)((Object)currentParticle)).blockSubstitution()) {
                        this.emitFieldError(event, "Element substitution not allowed when group head has block='substitution'", name);
                        this._eatContent = 1;
                        return;
                    }
                    SchemaGlobalElement newField = this._globalTypes.findElement(name);
                    if (!$assertionsDisabled && newField == null) {
                        throw new AssertionError();
                    }
                    if (newField != null) {
                        elementField = newField;
                        this._localElement = newField;
                    }
                } else {
                    elementField = (SchemaField)((Object)currentParticle);
                }
            }
            elementType = elementField.getType();
        }
        if (!$assertionsDisabled && elementType == null) {
            throw new AssertionError();
        }
        if (elementType.isNoType()) {
            this.emitFieldError(event, "Invalid type.");
            this._eatContent = 1;
        }
        Object xsiType = null;
        if (event.getXsiType(this._chars)) {
            String value = this._chars.asString();
            int originalErrorState = this._errorState++;
            ++this._suspendErrors;
            try {
                Object var11_14;
                try {
                    this._vc._event = null;
                    xsiType = this._globalTypes.findType(XmlQNameImpl.validateLexical(value, this._vc, event));
                }
                catch (Throwable t) {
                    var11_14 = null;
                    --this._suspendErrors;
                }
                var11_14 = null;
                --this._suspendErrors;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                --this._suspendErrors;
                throw throwable;
            }
            if (originalErrorState != this._errorState) {
                this.emitFieldError(event, "Invalid xsi:type qname: '" + value + "'");
                this._eatContent = 1;
                return;
            }
            if (xsiType == null) {
                this.emitError(event, "Could not find xsi:type: '" + value + "'");
                this._eatContent = 1;
                return;
            }
        }
        if (xsiType != null && !xsiType.equals(elementType)) {
            Object t;
            if (!elementType.isAssignableFrom((SchemaType)xsiType)) {
                this.emitFieldError(event, "Type '" + xsiType + "' is not derived from '" + elementType + "'");
                this._eatContent = 1;
                return;
            }
            if (elementType.blockExtension()) {
                t = xsiType;
                while (!t.equals(elementType)) {
                    if (t.getDerivationType() == 2) {
                        this.emitFieldError(event, "Extension type: '" + xsiType + "' may not be substituted for: '" + elementType + "'");
                        this._eatContent = 1;
                        return;
                    }
                    t = t.getBaseType();
                }
            }
            if (elementType.blockRestriction()) {
                t = xsiType;
                while (!t.equals(elementType)) {
                    if (t.getDerivationType() == 1) {
                        this.emitFieldError(event, "Restriction type: '" + xsiType + "' may not be substituted for: '" + elementType + "'");
                        this._eatContent = 1;
                        return;
                    }
                    t = t.getBaseType();
                }
            }
            if (elementField instanceof SchemaLocalElement) {
                this._localElement = sle = (SchemaLocalElement)elementField;
                if (sle.blockExtension() || sle.blockRestriction()) {
                    Object t2 = xsiType;
                    while (!t2.equals(elementType)) {
                        if (t2.getDerivationType() == 1 && sle.blockRestriction() || t2.getDerivationType() == 2 && sle.blockExtension()) {
                            this.emitError(event, "Derived type: '" + xsiType + "' may not be substituted for element '" + QNameHelper.pretty(sle.getName()) + "'");
                            this._eatContent = 1;
                            return;
                        }
                        t2 = t2.getBaseType();
                    }
                }
            }
            elementType = xsiType;
        }
        if (elementField instanceof SchemaLocalElement) {
            this._localElement = sle = (SchemaLocalElement)elementField;
            if (sle.isAbstract()) {
                this.emitError(event, "Element '" + QNameHelper.pretty(sle.getName()) + "' is abstract and cannot be used in an instance.");
                this._eatContent = 1;
                return;
            }
        }
        if (elementType != null && elementType.isAbstract()) {
            this.emitFieldError(event, "Abstract type: " + elementType + " cannot be used in an instance");
            this._eatContent = 1;
            return;
        }
        boolean isNil = false;
        boolean hasNil = false;
        if (event.getXsiNil(this._chars)) {
            this._vc._event = event;
            isNil = JavaBooleanHolder.validateLexical(this._chars.asString(), this._vc);
            hasNil = true;
        }
        if (hasNil && !elementField.isNillable()) {
            this.emitFieldError(event, "Element has xsi:nil attribute but is not nillable");
            this._eatContent = 1;
            return;
        }
        this.newState((SchemaType)elementType, elementField, isNil);
        this._constraintEngine.element(event, (SchemaType)elementType, elementField instanceof SchemaLocalElement ? ((SchemaLocalElement)elementField).getIdentityConstraints() : null);
    }

    private void attrEvent(ValidatorListener.Event event) {
        SchemaLocalAttribute attrSchema;
        QName attrName = event.getName();
        State state = this.topState();
        if (state._attrs == null) {
            state._attrs = new HashSet();
        }
        if (state._attrs.contains(attrName)) {
            this.emitFieldError(event, "Duplicate attribute: " + QNameHelper.pretty(attrName));
            return;
        }
        state._attrs.add(attrName);
        if (!state._canHaveAttrs) {
            this.emitFieldError(event, "Can't have attributes");
            return;
        }
        SchemaLocalAttribute schemaLocalAttribute = attrSchema = state._attrModel == null ? null : state._attrModel.getAttribute(attrName);
        if (attrSchema != null) {
            this._localAttribute = attrSchema;
            if (attrSchema.getUse() == 1) {
                this.emitFieldError(event, "Attribute is prohibited: " + QNameHelper.pretty(attrName));
                return;
            }
            String value = this.validateSimpleType(attrSchema.getType(), attrSchema, event, false, false);
            this._constraintEngine.attr(event, attrName, attrSchema.getType(), value);
            return;
        }
        int wildcardProcess = state._attrModel.getWildcardProcess();
        this._wildcardAttribute = state._attrModel;
        if (wildcardProcess == 0) {
            this.emitFieldError(event, "Attribute not allowed (no wildcards allowed): " + QNameHelper.pretty(attrName));
            return;
        }
        QNameSet attrWildcardSet = state._attrModel.getWildcardSet();
        if (!attrWildcardSet.contains(attrName)) {
            this.emitFieldError(event, "Attribute not allowed: " + QNameHelper.pretty(attrName));
            return;
        }
        if (wildcardProcess == 3) {
            return;
        }
        this._localAttribute = attrSchema = this._globalTypes.findAttribute(attrName);
        if (attrSchema == null) {
            if (wildcardProcess == 2) {
                return;
            }
            if (!$assertionsDisabled && wildcardProcess != 1) {
                throw new AssertionError();
            }
            this.emitFieldError(event, "Attribute not allowed (strict wildcard, and no definition found): " + QNameHelper.pretty(attrName));
            return;
        }
        String value = this.validateSimpleType(attrSchema.getType(), attrSchema, event, false, false);
        this._constraintEngine.attr(event, attrName, attrSchema.getType(), value);
    }

    private void endAttrsEvent(ValidatorListener.Event event) {
        State state = this.topState();
        if (state._attrModel != null) {
            SchemaLocalAttribute[] attrs = state._attrModel.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                SchemaLocalAttribute sla = attrs[i];
                if (state._attrs == null || !state._attrs.contains(sla.getName())) {
                    if (sla.getUse() == 3) {
                        this.emitFieldError(event, "Expected attribute: ", sla.getName());
                    } else if (sla.isDefault() || sla.isFixed()) {
                        this._constraintEngine.attr(event, sla.getName(), sla.getType(), sla.getDefaultText());
                    }
                }
                ++i;
            }
        }
    }

    private void endEvent(ValidatorListener.Event event) {
        this._localElement = null;
        this._wildcardElement = null;
        String message = null;
        State state = this.topState();
        if (!state._isNil) {
            if (!state.end()) {
                message = this.findDetailedErrorEnd(state);
                if (message != null) {
                    this.emitFieldError(event, message);
                } else {
                    this.emitFieldError(event, "Expected element(s)");
                }
            }
            if (state._isEmpty) {
                this.handleText(event, true, state._field);
            }
        }
        this.popState(event);
        this._constraintEngine.endElement(event);
    }

    private void textEvent(ValidatorListener.Event event) {
        State state = this.topState();
        if (state._isNil) {
            this.emitFieldError(event, "Nil element cannot have simple content");
        } else {
            this.handleText(event, false, state._field);
        }
        state._isEmpty = false;
    }

    private void handleText(ValidatorListener.Event event, boolean emptyContent, SchemaField field) {
        State state = this.topState();
        if (!state._sawText) {
            if (state._hasSimpleContent) {
                String value = this.validateSimpleType(state._type, field, event, emptyContent, true);
                this._constraintEngine.text(event, state._type, value, false);
            } else if (emptyContent) {
                this._constraintEngine.text(event, state._type, null, true);
            } else {
                this._constraintEngine.text(event, state._type, "", false);
            }
        }
        if (!emptyContent && !state._canHaveMixedContent && !event.textIsWhitespace() & !state._hasSimpleContent) {
            if (field instanceof SchemaLocalElement) {
                SchemaLocalElement e = (SchemaLocalElement)field;
                this.emitError(event, "Element: '" + QNameHelper.pretty(e.getName()) + "' cannot have mixed content.");
            } else {
                this.emitError(event, "Can't have mixed content");
            }
        }
        if (!emptyContent) {
            state._sawText = true;
        }
    }

    private String findDetailedErrorBegin(State state, QName qName) {
        String message = null;
        SchemaProperty[] eltProperties = state._type.getElementProperties();
        int ii = 0;
        while (ii < eltProperties.length) {
            SchemaProperty sProp = eltProperties[ii];
            if (state.test(sProp.getName())) {
                message = "Expected element " + QNameHelper.pretty(sProp.getName()) + " instead of " + QNameHelper.pretty(qName) + " here";
                break;
            }
            ++ii;
        }
        return message;
    }

    private String findDetailedErrorEnd(State state) {
        SchemaProperty[] eltProperties = state._type.getElementProperties();
        String message = null;
        int ii = 0;
        while (ii < eltProperties.length) {
            SchemaProperty sProp = eltProperties[ii];
            if (state.test(sProp.getName())) {
                message = "Expected element " + QNameHelper.pretty(sProp.getName()) + " at the end of the content";
                break;
            }
            ++ii;
        }
        return message;
    }

    private void newState(SchemaType type, SchemaField field, boolean isNil) {
        State state = new State();
        state._type = type;
        state._field = field;
        state._isEmpty = true;
        state._isNil = isNil;
        if (type.isSimpleType()) {
            state._hasSimpleContent = true;
        } else {
            state._canHaveAttrs = true;
            state._attrModel = type.getAttributeModel();
            switch (type.getContentType()) {
                case 1: {
                    break;
                }
                case 2: {
                    state._hasSimpleContent = true;
                    break;
                }
                case 4: {
                    state._canHaveMixedContent = true;
                }
                case 3: {
                    SchemaParticle particle = type.getContentModel();
                    boolean bl = state._canHaveElements = particle != null;
                    if (!state._canHaveElements) break;
                    state._visitor = this.initVisitor(particle);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected content type");
                }
            }
        }
        this.pushState(state);
    }

    private void popState(ValidatorListener.Event e) {
        if (this._stateStack._visitor != null) {
            this.poolVisitor(this._stateStack._visitor);
            this._stateStack._visitor = null;
        }
        this._stateStack = this._stateStack._next;
    }

    private void pushState(State state) {
        state._next = this._stateStack;
        this._stateStack = state;
    }

    private void poolVisitor(SchemaTypeVisitorImpl visitor) {
        this._visitorPool.add(visitor);
    }

    private SchemaTypeVisitorImpl initVisitor(SchemaParticle particle) {
        if (this._visitorPool.isEmpty()) {
            return new SchemaTypeVisitorImpl(particle);
        }
        SchemaTypeVisitorImpl result = (SchemaTypeVisitorImpl)this._visitorPool.removeLast();
        result.init(particle);
        return result;
    }

    private State topState() {
        return this._stateStack;
    }

    private String validateSimpleType(SchemaType type, SchemaField field, ValidatorListener.Event event, boolean emptyContent, boolean canApplyDefault) {
        if (!type.isSimpleType() && type.getContentType() != 2) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        if (type.isNoType()) {
            this.emitError(event, "Invalid type.");
            return null;
        }
        String value = "";
        if (!emptyContent) {
            event.getText(this._chars, type.getWhiteSpaceRule());
            value = this._chars.asString();
        }
        if (value.length() == 0 && canApplyDefault && field != null && (field.isDefault() || field.isFixed())) {
            if (XmlQName.type.isAssignableFrom(type)) {
                this.emitError(event, "Default QName values are unsupported for " + QNameHelper.readable(type) + " - ignoring.", 2);
                return null;
            }
            String defaultValue = XmlWhitespace.collapse(field.getDefaultText(), type.getWhiteSpaceRule());
            return this.validateSimpleType(type, defaultValue, event) ? defaultValue : null;
        }
        if (!this.validateSimpleType(type, value, event)) {
            return null;
        }
        if (field != null && field.isFixed()) {
            XmlAnySimpleType def;
            String fixedValue = XmlWhitespace.collapse(field.getDefaultText(), type.getWhiteSpaceRule());
            if (!this.validateSimpleType(type, fixedValue, event)) {
                return null;
            }
            XmlAnySimpleType val = type.newValue(value);
            if (!val.valueEquals(def = type.newValue(fixedValue))) {
                this.emitError(event, "Value not equal to fixed value. " + value);
                return null;
            }
        }
        return value;
    }

    private boolean validateSimpleType(SchemaType type, String value, ValidatorListener.Event event) {
        if (!type.isSimpleType() && type.getContentType() != 2) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException("Not a simple type");
        }
        int retState = this._errorState;
        switch (type.getSimpleVariety()) {
            case 1: {
                this.validateAtomicType(type, value, event);
                break;
            }
            case 2: {
                this.validateUnionType(type, value, event);
                break;
            }
            case 3: {
                this.validateListType(type, value, event);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected simple variety");
            }
        }
        return retState == this._errorState;
    }

    private void validateAtomicType(SchemaType type, String value, ValidatorListener.Event event) {
        if (!$assertionsDisabled && type.getSimpleVariety() != 1) {
            throw new AssertionError();
        }
        int errorState = this._errorState;
        this._vc._event = event;
        switch (type.getPrimitiveType().getBuiltinTypeCode()) {
            case 2: {
                break;
            }
            case 12: {
                JavaStringEnumerationHolderEx.validateLexical(value, type, this._vc);
                this._stringValue = value;
                break;
            }
            case 11: {
                JavaDecimalHolderEx.validateLexical(value, type, this._vc);
                if (errorState != this._errorState) break;
                this._decimalValue = new BigDecimal(value);
                JavaDecimalHolderEx.validateValue(this._decimalValue, type, this._vc);
                break;
            }
            case 3: {
                this._booleanValue = JavaBooleanHolderEx.validateLexical(value, type, this._vc);
                break;
            }
            case 9: {
                float f = JavaFloatHolderEx.validateLexical(value, type, this._vc);
                if (errorState == this._errorState) {
                    JavaFloatHolderEx.validateValue(f, type, this._vc);
                }
                this._floatValue = f;
                break;
            }
            case 10: {
                double d = JavaDoubleHolderEx.validateLexical(value, type, this._vc);
                if (errorState == this._errorState) {
                    JavaDoubleHolderEx.validateValue(d, type, this._vc);
                }
                this._doubleValue = d;
                break;
            }
            case 7: {
                QName n = JavaQNameHolderEx.validateLexical(value, type, this._vc, event);
                if (errorState == this._errorState) {
                    JavaQNameHolderEx.validateValue(n, type, this._vc);
                }
                this._qnameValue = n;
                break;
            }
            case 6: {
                JavaUriHolderEx.validateLexical(value, type, this._vc);
                this._stringValue = value;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                GDate d = XmlDateImpl.validateLexical(value, type, this._vc);
                if (d != null) {
                    XmlDateImpl.validateValue(d, type, this._vc);
                }
                this._gdateValue = d;
                break;
            }
            case 13: {
                GDuration d = XmlDurationImpl.validateLexical(value, type, this._vc);
                if (d != null) {
                    XmlDurationImpl.validateValue(d, type, this._vc);
                }
                this._gdurationValue = d;
                break;
            }
            case 4: {
                byte[] v = JavaBase64HolderEx.validateLexical(value, type, this._vc);
                if (v != null) {
                    JavaBase64HolderEx.validateValue(v, type, this._vc);
                }
                this._byteArrayValue = v;
                break;
            }
            case 5: {
                byte[] v = JavaHexBinaryHolderEx.validateLexical(value, type, this._vc);
                if (v != null) {
                    JavaHexBinaryHolderEx.validateValue(v, type, this._vc);
                }
                this._byteArrayValue = v;
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected primitive type code");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateListType(SchemaType type, String value, ValidatorListener.Event event) {
        int i;
        int errorState = this._errorState;
        if (!type.matchPatternFacet(value)) {
            this.emitError(event, "List '" + value + "' does not match pattern for " + QNameHelper.readable(type));
        }
        String[] items = XmlListImpl.split_list(value);
        XmlAnySimpleType o = type.getFacet(0);
        if (o != null && (i = ((SimpleValue)((Object)o)).getIntValue()) != items.length) {
            this.emitError(event, "List (" + value + ") does not have " + i + " items per length facet for " + QNameHelper.readable(type));
        }
        if ((o = type.getFacet(1)) != null && (i = ((SimpleValue)((Object)o)).getIntValue()) > items.length) {
            this.emitError(event, "List (" + value + ") has only " + items.length + " items, fewer than min length facet (" + i + ") for " + QNameHelper.readable(type));
        }
        if ((o = type.getFacet(2)) != null && (i = ((SimpleValue)((Object)o)).getIntValue()) < items.length) {
            this.emitError(event, "List (" + value + ") has " + items.length + " items, more than max length facet (" + i + ") for " + QNameHelper.readable(type));
        }
        SchemaType itemType = type.getListItemType();
        this._listValue = new ArrayList();
        this._listTypes = new ArrayList();
        i = 0;
        while (i < items.length) {
            this.validateSimpleType(itemType, items[i], event);
            this.addToList(itemType);
            ++i;
        }
        if (errorState != this._errorState) return;
        if (type.getEnumerationValues() == null) return;
        NamespaceContext.push(new NamespaceContext(event));
        try {
            try {
                XmlAnySimpleType listValue = ((SchemaTypeImpl)type).newValidatingValue(value);
            }
            catch (XmlValueOutOfRangeException e) {
                this.emitError(event, "List value (" + value + ") is not a valid enumeration value for " + QNameHelper.readable(type));
                Object var11_12 = null;
                NamespaceContext.pop();
                return;
            }
            Object var11_11 = null;
            NamespaceContext.pop();
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            NamespaceContext.pop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateUnionType(SchemaType type, String value, ValidatorListener.Event event) {
        if (!type.matchPatternFacet(value)) {
            this.emitError(event, "Union '" + value + "' does not match pattern for " + QNameHelper.readable(type));
        }
        int currentWsr = 1;
        String currentValue = value;
        SchemaType[] types = type.getUnionMemberTypes();
        int originalState = this._errorState;
        int i = 0;
        while (i < types.length) {
            Object var12_14;
            int memberWsr = types[i].getWhiteSpaceRule();
            if (memberWsr == 0) {
                memberWsr = 1;
            }
            if (memberWsr != currentWsr) {
                currentWsr = memberWsr;
                currentValue = XmlWhitespace.collapse(value, currentWsr);
            }
            int originalErrorState = this._errorState;
            ++this._suspendErrors;
            try {
                this.validateSimpleType(types[i], currentValue, event);
                var12_14 = null;
                --this._suspendErrors;
            }
            catch (Throwable throwable) {
                var12_14 = null;
                --this._suspendErrors;
                throw throwable;
            }
            if (originalErrorState == this._errorState) {
                this._unionType = types[i];
                break;
            }
            ++i;
        }
        this._errorState = originalState;
        if (i >= types.length) {
            this.emitError(event, "Union '" + value + "' does not match any members of " + QNameHelper.readable(type));
            return;
        }
        XmlAnySimpleType[] unionEnumvals = type.getEnumerationValues();
        if (unionEnumvals == null) return;
        NamespaceContext.push(new NamespaceContext(event));
        try {
            block13: {
                try {
                    XmlAnySimpleType unionValue = type.newValue(value);
                    i = 0;
                    while (i < unionEnumvals.length && !unionValue.valueEquals(unionEnumvals[i])) {
                        ++i;
                    }
                    if (i < unionEnumvals.length) break block13;
                    this.emitError(event, "Union '" + value + "' is not a valid enumeration value for " + QNameHelper.readable(type));
                }
                catch (XmlValueOutOfRangeException e) {
                    this.emitError(event, "Union '" + value + "' is not a valid enumeration value for " + QNameHelper.readable(type));
                    Object var14_17 = null;
                    NamespaceContext.pop();
                    return;
                }
            }
            Object var14_16 = null;
            NamespaceContext.pop();
            return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            NamespaceContext.pop();
            throw throwable;
        }
    }

    private void addToList(SchemaType type) {
        if (type.getSimpleVariety() != 1) {
            return;
        }
        if (type.getUnionMemberTypes().length > 0 && this.getUnionType() != null) {
            type = this.getUnionType();
            this._unionType = null;
        }
        this._listTypes.add(type);
        switch (type.getPrimitiveType().getBuiltinTypeCode()) {
            case 2: {
                this._listValue.add(this._stringValue);
                break;
            }
            case 12: {
                this._listValue.add(this._stringValue);
                this._stringValue = null;
                break;
            }
            case 11: {
                this._listValue.add(this._decimalValue);
                this._decimalValue = null;
                break;
            }
            case 3: {
                this._listValue.add(this._booleanValue ? Boolean.TRUE : Boolean.FALSE);
                this._booleanValue = false;
                break;
            }
            case 9: {
                this._listValue.add(new Float(this._floatValue));
                this._floatValue = 0.0f;
                break;
            }
            case 10: {
                this._listValue.add(new Double(this._doubleValue));
                this._doubleValue = 0.0;
                break;
            }
            case 7: {
                this._listValue.add(this._qnameValue);
                this._qnameValue = null;
                break;
            }
            case 6: {
                this._listTypes.add(this._stringValue);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this._listValue.add(this._gdateValue);
                this._gdateValue = null;
                break;
            }
            case 13: {
                this._listValue.add(this._gdurationValue);
                this._gdurationValue = null;
                break;
            }
            case 4: {
                this._listValue.add(this._byteArrayValue);
                this._byteArrayValue = null;
                break;
            }
            case 5: {
                this._listValue.add(this._byteArrayValue);
                this._byteArrayValue = null;
                break;
            }
            case 8: {
                this._listValue.add(this._stringValue);
                this._stringValue = null;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected primitive type code");
            }
        }
    }

    private void resetValues() {
        this._localAttribute = null;
        this._wildcardAttribute = null;
        this._stringValue = null;
        this._decimalValue = null;
        this._booleanValue = false;
        this._floatValue = 0.0f;
        this._doubleValue = 0.0;
        this._qnameValue = null;
        this._gdateValue = null;
        this._gdurationValue = null;
        this._byteArrayValue = null;
        this._listValue = null;
        this._listTypes = null;
        this._unionType = null;
        this._localAttribute = null;
    }

    public SchemaLocalElement getCurrentElement() {
        if (this._localElement != null) {
            return this._localElement;
        }
        if (this._eatContent > 0) {
            return null;
        }
        if (this._stateStack != null && this._stateStack._field instanceof SchemaLocalElement) {
            return (SchemaLocalElement)this._stateStack._field;
        }
        return null;
    }

    public SchemaParticle getCurrentWildcardElement() {
        return this._wildcardElement;
    }

    public SchemaLocalAttribute getCurrentAttribute() {
        return this._localAttribute;
    }

    public SchemaAttributeModel getCurrentWildcardAttribute() {
        return this._wildcardAttribute;
    }

    public String getStringValue() {
        return this._stringValue;
    }

    public BigDecimal getDecimalValue() {
        return this._decimalValue;
    }

    public boolean getBooleanValue() {
        return this._booleanValue;
    }

    public float getFloatValue() {
        return this._floatValue;
    }

    public double getDoubleValue() {
        return this._doubleValue;
    }

    public QName getQNameValue() {
        return this._qnameValue;
    }

    public GDate getGDateValue() {
        return this._gdateValue;
    }

    public GDuration getGDurationValue() {
        return this._gdurationValue;
    }

    public byte[] getByteArrayValue() {
        return this._byteArrayValue;
    }

    public List getListValue() {
        return this._listValue;
    }

    public List getListTypes() {
        return this._listTypes;
    }

    public SchemaType getUnionType() {
        return this._unionType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$apache$xmlbeans$impl$validator$Validator == null ? (class$org$apache$xmlbeans$impl$validator$Validator = Validator.class$("org.apache.xmlbeans.impl.validator.Validator")) : class$org$apache$xmlbeans$impl$validator$Validator).desiredAssertionStatus();
    }

    private final class State {
        SchemaType _type;
        SchemaField _field;
        boolean _canHaveAttrs;
        boolean _canHaveMixedContent;
        boolean _hasSimpleContent;
        boolean _sawText;
        boolean _isEmpty;
        boolean _isNil;
        SchemaTypeVisitorImpl _visitor;
        boolean _canHaveElements;
        SchemaAttributeModel _attrModel;
        HashSet _attrs;
        State _next;
        static final /* synthetic */ boolean $assertionsDisabled;

        private State() {
        }

        boolean visit(QName name) {
            return this._canHaveElements && this._visitor.visit(name);
        }

        boolean test(QName name) {
            return this._canHaveElements && this._visitor.testValid(name);
        }

        boolean end() {
            return !this._canHaveElements || this._visitor.visit(null);
        }

        SchemaParticle currentParticle() {
            if (!$assertionsDisabled && this._visitor == null) {
                throw new AssertionError();
            }
            return this._visitor.currentParticle();
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$validator$Validator == null ? (class$org$apache$xmlbeans$impl$validator$Validator = Validator.class$("org.apache.xmlbeans.impl.validator.Validator")) : class$org$apache$xmlbeans$impl$validator$Validator).desiredAssertionStatus();
        }
    }

    private class ValidatorVC
    implements ValidationContext {
        ValidatorListener.Event _event;

        private ValidatorVC() {
        }

        public void invalid(String message) {
            Validator.this.emitError(this._event, message);
        }
    }
}

