/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.schema.StscState;
import org.w3.x2001.xmlSchema.ImportDocument;
import org.w3.x2001.xmlSchema.IncludeDocument;
import org.w3.x2001.xmlSchema.RedefineDocument;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StscImporter {
    private static final String PROJECT_URL_PREFIX = "project://local";

    public static SchemaToProcess[] resolveImportsAndIncludes(SchemaDocument.Schema[] startWith) {
        DownloadTable engine = new DownloadTable(startWith);
        return engine.resolveImportsAndIncludes();
    }

    private static String baseURLForDoc(XmlObject obj) {
        String path = obj.documentProperties().getSourceName();
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return PROJECT_URL_PREFIX + path.replace('\\', '/');
        }
        int colon = path.indexOf(58);
        if (colon > 1 && path.substring(0, colon).matches("^\\w+$")) {
            return path;
        }
        return "project://local/" + path.replace('\\', '/');
    }

    private static URI parseURI(String s) {
        if (s == null) {
            return null;
        }
        try {
            return new URI(s);
        }
        catch (URISyntaxException syntax) {
            return null;
        }
    }

    private static URI resolve(URI base, String child) {
        URI ruri;
        block2: {
            ruri = base.resolve(child);
            if (!"file".equals(ruri.getScheme()) || child.equals(ruri) || !base.getPath().startsWith("//") || ruri.getPath().startsWith("//")) break block2;
            String path = "///".concat(ruri.getPath());
            try {
                ruri = new URI("file", null, path, ruri.getQuery(), ruri.getFragment());
            }
            catch (URISyntaxException uris) {}
        }
        return ruri;
    }

    public static class DownloadTable {
        private Map schemaByNsLocPair = new HashMap();
        private Map schemaByDigestKey = new HashMap();
        private LinkedList scanNeeded = new LinkedList();
        private Set emptyNamespaceSchemas = new HashSet();
        private Set scannedAlready = new HashSet();
        private Set failedDownloads = new HashSet();

        private SchemaDocument.Schema downloadSchema(XmlObject referencedBy, String targetNamespace, String locationURL) {
            SchemaDocument.Schema result;
            SchemaDocument.Schema result2;
            String absoluteURL;
            if (locationURL == null) {
                return null;
            }
            URI baseURI = StscImporter.parseURI(StscImporter.baseURLForDoc(referencedBy));
            String string = absoluteURL = baseURI == null ? locationURL : StscImporter.resolve(baseURI, locationURL).toString();
            if (absoluteURL != null && targetNamespace != null && (result2 = (SchemaDocument.Schema)this.schemaByNsLocPair.get(new NsLocPair(targetNamespace, absoluteURL))) != null) {
                return result2;
            }
            StscState state = StscState.get();
            if (targetNamespace != null && !targetNamespace.equals("")) {
                if (!state.shouldDownloadURI(absoluteURL) && (result = (SchemaDocument.Schema)this.schemaByNsLocPair.get(new NsLocPair(targetNamespace, null))) != null) {
                    return result;
                }
                if (state.linkerDefinesNamespace(targetNamespace)) {
                    return null;
                }
            }
            if (absoluteURL != null && (result = (SchemaDocument.Schema)this.schemaByNsLocPair.get(new NsLocPair(null, absoluteURL))) != null) {
                return result;
            }
            if (absoluteURL == null) {
                state.error("Could not find resource - no valid location URL.", 56, referencedBy);
                return null;
            }
            if (this.previouslyFailedToDownload(absoluteURL)) {
                return null;
            }
            if (!state.shouldDownloadURI(absoluteURL)) {
                state.error("Could not load resource \"" + absoluteURL + "\" (network downloads disabled).", 56, referencedBy);
                this.addFailedDownload(absoluteURL);
                return null;
            }
            try {
                block20: {
                    SchemaDocument.Schema result3;
                    block19: {
                        String shortname;
                        XmlObject xdoc;
                        block18: {
                            xdoc = this.downloadDocument(state.getS4SLoader(), targetNamespace, absoluteURL);
                            result3 = this.findMatchByDigest(xdoc);
                            shortname = state.relativize(absoluteURL);
                            if (result3 == null) break block18;
                            String dupname = state.relativize(result3.documentProperties().getSourceName());
                            if (dupname != null) {
                                state.info(shortname + " is the same as " + dupname + " (ignoring the duplicate file)");
                            } else {
                                state.info(shortname + " is the same as another schema");
                            }
                            break block19;
                        }
                        XmlOptions voptions = new XmlOptions();
                        voptions.setErrorListener(state.getErrorListener());
                        if (!(xdoc instanceof SchemaDocument) || !xdoc.validate(voptions)) break block20;
                        SchemaDocument sDoc = (SchemaDocument)xdoc;
                        result3 = sDoc.getSchema();
                        state.info("Loading referenced file " + shortname);
                    }
                    NsLocPair key = new NsLocPair(DownloadTable.emptyStringIfNull(result3.getTargetNamespace()), absoluteURL);
                    this.addSuccessfulDownload(key, result3);
                    return result3;
                }
                state.error("Referenced document is not a valid schema", 56, referencedBy);
            }
            catch (MalformedURLException malformed) {
                state.error("URL \"" + absoluteURL + "\" is not well-formed", 56, referencedBy);
            }
            catch (IOException connectionProblem) {
                state.error(connectionProblem.toString(), 56, referencedBy);
            }
            catch (XmlException e) {
                state.error("Problem parsing referenced XML resource - " + e.getMessage(), 56, referencedBy);
            }
            this.addFailedDownload(absoluteURL);
            return null;
        }

        private XmlObject downloadDocument(SchemaTypeLoader loader, String namespace, String absoluteURL) throws MalformedURLException, IOException, XmlException {
            StscState state = StscState.get();
            EntityResolver resolver = state.getEntityResolver();
            if (resolver != null) {
                InputSource source;
                try {
                    source = resolver.resolveEntity(namespace, absoluteURL);
                }
                catch (SAXException e) {
                    throw new XmlException(e);
                }
                Reader reader = source.getCharacterStream();
                if (reader != null) {
                    XmlOptions options = new XmlOptions();
                    options.setLoadLineNumbers();
                    options.setDocumentSourceName(absoluteURL);
                    return loader.parse(reader, null, options);
                }
                InputStream bytes = source.getByteStream();
                if (bytes != null) {
                    String encoding = source.getEncoding();
                    XmlOptions options = new XmlOptions();
                    options.setLoadLineNumbers();
                    options.setLoadMessageDigest();
                    options.setDocumentSourceName(absoluteURL);
                    if (encoding != null) {
                        options.setCharacterEncoding(encoding);
                    }
                    return loader.parse(bytes, null, options);
                }
                String urlToLoad = source.getSystemId();
                if (urlToLoad == null) {
                    throw new IOException("EntityResolver unable to resolve " + absoluteURL + " (for namespace " + namespace + ")");
                }
                XmlOptions options = new XmlOptions();
                options.setLoadLineNumbers();
                options.setLoadMessageDigest();
                options.setDocumentSourceName(absoluteURL);
                URL urlDownload = new URL(urlToLoad);
                return loader.parse(urlDownload, null, options);
            }
            XmlOptions options = new XmlOptions();
            options.setLoadLineNumbers();
            options.setLoadMessageDigest();
            URL urlDownload = new URL(absoluteURL);
            return loader.parse(urlDownload, null, options);
        }

        private void addSuccessfulDownload(NsLocPair key, SchemaDocument.Schema schema) {
            NsLocPair key2;
            byte[] digest = schema.documentProperties().getMessageDigest();
            if (digest == null) {
                StscState.get().addSchemaDigest(null);
            } else {
                DigestKey dk = new DigestKey(digest);
                if (!this.schemaByDigestKey.containsKey(dk)) {
                    this.schemaByDigestKey.put(new DigestKey(digest), schema);
                    StscState.get().addSchemaDigest(digest);
                }
            }
            this.schemaByNsLocPair.put(key, schema);
            NsLocPair key1 = new NsLocPair(key.getNamespaceURI(), null);
            if (!this.schemaByNsLocPair.containsKey(key1)) {
                this.schemaByNsLocPair.put(key1, schema);
            }
            if (!this.schemaByNsLocPair.containsKey(key2 = new NsLocPair(null, key.getLocationURL()))) {
                this.schemaByNsLocPair.put(key2, schema);
            }
        }

        private SchemaDocument.Schema findMatchByDigest(XmlObject original) {
            byte[] digest = original.documentProperties().getMessageDigest();
            if (digest == null) {
                return null;
            }
            return (SchemaDocument.Schema)this.schemaByDigestKey.get(new DigestKey(digest));
        }

        private void addFailedDownload(String locationURL) {
            this.failedDownloads.add(locationURL);
        }

        private boolean previouslyFailedToDownload(String locationURL) {
            return this.failedDownloads.contains(locationURL);
        }

        private static boolean nullableStringsMatch(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }

        private static String emptyStringIfNull(String s) {
            if (s == null) {
                return "";
            }
            return s;
        }

        private void addScanNeeded(SchemaToProcess stp) {
            if (!this.scannedAlready.contains(stp)) {
                this.scannedAlready.add(stp);
                this.scanNeeded.add(stp);
            }
        }

        private void addEmptyNamespaceSchema(SchemaDocument.Schema s) {
            this.emptyNamespaceSchemas.add(s);
        }

        private void usedEmptyNamespaceSchema(SchemaDocument.Schema s) {
            this.emptyNamespaceSchemas.remove(s);
        }

        private boolean fetchRemainingEmptyNamespaceSchemas() {
            if (this.emptyNamespaceSchemas.isEmpty()) {
                return false;
            }
            Iterator i = this.emptyNamespaceSchemas.iterator();
            while (i.hasNext()) {
                SchemaDocument.Schema schema = (SchemaDocument.Schema)i.next();
                this.addScanNeeded(new SchemaToProcess(schema, null, null));
            }
            this.emptyNamespaceSchemas.clear();
            return true;
        }

        private boolean hasNextToScan() {
            return !this.scanNeeded.isEmpty();
        }

        private SchemaToProcess nextToScan() {
            SchemaToProcess next = (SchemaToProcess)this.scanNeeded.removeFirst();
            return next;
        }

        public DownloadTable(SchemaDocument.Schema[] startWith) {
            int i = 0;
            while (i < startWith.length) {
                String targetNamespace = startWith[i].getTargetNamespace();
                NsLocPair key = new NsLocPair(targetNamespace, StscImporter.baseURLForDoc(startWith[i]));
                this.addSuccessfulDownload(key, startWith[i]);
                if (targetNamespace != null) {
                    this.addScanNeeded(new SchemaToProcess(startWith[i], null, null));
                } else {
                    this.addEmptyNamespaceSchema(startWith[i]);
                }
                ++i;
            }
        }

        public SchemaToProcess[] resolveImportsAndIncludes() {
            StscState state = StscState.get();
            ArrayList<SchemaToProcess> result = new ArrayList<SchemaToProcess>();
            block0: while (true) {
                if (this.hasNextToScan()) {
                    SchemaToProcess stp = this.nextToScan();
                    state.addSourceUri(stp.getSourceName(), null);
                    result.add(stp);
                    ImportDocument.Import[] imports = stp.getSchema().getImportArray();
                    int i = 0;
                    while (i < imports.length) {
                        SchemaDocument.Schema imported = this.downloadSchema(imports[i], DownloadTable.emptyStringIfNull(imports[i].getNamespace()), imports[i].getSchemaLocation());
                        if (imported != null) {
                            if (!DownloadTable.nullableStringsMatch(imported.getTargetNamespace(), imports[i].getNamespace())) {
                                StscState.get().error("Imported schema has a target namespace \"" + imported.getTargetNamespace() + "\" that does not match the specified \"" + imports[i].getNamespace() + "\"", 4, imports[i]);
                            } else {
                                this.addScanNeeded(new SchemaToProcess(imported, null, null));
                            }
                        }
                        ++i;
                    }
                    IncludeDocument.Include[] includes = stp.getSchema().getIncludeArray();
                    String sourceNamespace = stp.getChameleonNamespace();
                    if (sourceNamespace == null) {
                        sourceNamespace = DownloadTable.emptyStringIfNull(stp.getSchema().getTargetNamespace());
                    }
                    int i2 = 0;
                    while (i2 < includes.length) {
                        SchemaDocument.Schema included = this.downloadSchema(includes[i2], null, includes[i2].getSchemaLocation());
                        if (included != null) {
                            if (DownloadTable.emptyStringIfNull(included.getTargetNamespace()).equals(sourceNamespace)) {
                                this.addScanNeeded(new SchemaToProcess(included, null, null));
                            } else if (included.getTargetNamespace() != null) {
                                StscState.get().error("Included schema has a target namespace \"" + included.getTargetNamespace() + "\" that does not match the source namespace \"" + sourceNamespace + "\"", 4, includes[i2]);
                            } else {
                                this.addScanNeeded(new SchemaToProcess(included, sourceNamespace, null));
                                this.usedEmptyNamespaceSchema(included);
                            }
                        }
                        ++i2;
                    }
                    RedefineDocument.Redefine[] redefines = stp.getSchema().getRedefineArray();
                    sourceNamespace = stp.getChameleonNamespace();
                    if (sourceNamespace == null) {
                        sourceNamespace = DownloadTable.emptyStringIfNull(stp.getSchema().getTargetNamespace());
                    }
                    i2 = 0;
                    while (true) {
                        if (i2 >= redefines.length) continue block0;
                        SchemaDocument.Schema redefined = this.downloadSchema(redefines[i2], null, redefines[i2].getSchemaLocation());
                        if (redefined != null) {
                            if (DownloadTable.emptyStringIfNull(redefined.getTargetNamespace()).equals(sourceNamespace)) {
                                this.addScanNeeded(new SchemaToProcess(redefined, null, redefines[i2]));
                            } else if (redefined.getTargetNamespace() != null) {
                                StscState.get().error("Redefined schema has a target namespace \"" + redefined.getTargetNamespace() + "\" that does not match the source namespace \"" + sourceNamespace + "\"", 4, redefines[i2]);
                            } else {
                                this.addScanNeeded(new SchemaToProcess(redefined, sourceNamespace, redefines[i2]));
                                this.usedEmptyNamespaceSchema(redefined);
                            }
                        }
                        ++i2;
                    }
                }
                if (!this.fetchRemainingEmptyNamespaceSchemas()) break;
            }
            return result.toArray(new SchemaToProcess[result.size()]);
        }

        private static class DigestKey {
            byte[] _digest;
            int _hashCode;

            DigestKey(byte[] digest) {
                this._digest = digest;
                int i = 0;
                while (i < 4 && i < digest.length) {
                    this._hashCode <<= 8;
                    this._hashCode += digest[i];
                    ++i;
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DigestKey)) {
                    return false;
                }
                return Arrays.equals(this._digest, ((DigestKey)o)._digest);
            }

            public int hashCode() {
                return this._hashCode;
            }
        }

        private static class NsLocPair {
            private String namespaceURI;
            private String locationURL;

            public NsLocPair(String namespaceURI, String locationURL) {
                this.namespaceURI = namespaceURI;
                this.locationURL = locationURL;
            }

            public String getNamespaceURI() {
                return this.namespaceURI;
            }

            public String getLocationURL() {
                return this.locationURL;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof NsLocPair)) {
                    return false;
                }
                NsLocPair nsLocPair = (NsLocPair)o;
                if (this.locationURL != null ? !this.locationURL.equals(nsLocPair.locationURL) : nsLocPair.locationURL != null) {
                    return false;
                }
                return !(this.namespaceURI != null ? !this.namespaceURI.equals(nsLocPair.namespaceURI) : nsLocPair.namespaceURI != null);
            }

            public int hashCode() {
                int result = this.namespaceURI != null ? this.namespaceURI.hashCode() : 0;
                result = 29 * result + (this.locationURL != null ? this.locationURL.hashCode() : 0);
                return result;
            }
        }
    }

    public static class SchemaToProcess {
        private SchemaDocument.Schema schema;
        private String chameleonNamespace;
        private RedefineDocument.Redefine redefine;

        public SchemaToProcess(SchemaDocument.Schema schema, String chameleonNamespace, RedefineDocument.Redefine redefine) {
            this.schema = schema;
            this.chameleonNamespace = chameleonNamespace;
            this.redefine = redefine;
        }

        public SchemaDocument.Schema getSchema() {
            return this.schema;
        }

        public String getSourceName() {
            return this.schema.documentProperties().getSourceName();
        }

        public RedefineDocument.Redefine getRedefine() {
            return this.redefine;
        }

        public String getChameleonNamespace() {
            return this.chameleonNamespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SchemaToProcess)) {
                return false;
            }
            SchemaToProcess schemaToProcess = (SchemaToProcess)o;
            if (this.chameleonNamespace != null ? !this.chameleonNamespace.equals(schemaToProcess.chameleonNamespace) : schemaToProcess.chameleonNamespace != null) {
                return false;
            }
            if (this.redefine != null ? !this.redefine.equals(schemaToProcess.redefine) : schemaToProcess.redefine != null) {
                return false;
            }
            return this.schema.equals(schemaToProcess.schema);
        }

        public int hashCode() {
            int result = this.schema.hashCode();
            result = 29 * result + (this.chameleonNamespace != null ? this.chameleonNamespace.hashCode() : 0);
            result = 29 * result + (this.redefine != null ? this.redefine.hashCode() : 0);
            return result;
        }
    }
}

