/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaAttributeModel;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaIdentityConstraint;
import org.apache.xmlbeans.SchemaLocalAttribute;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlID;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XBeanDebug;
import org.apache.xmlbeans.impl.schema.SchemaGlobalElementImpl;
import org.apache.xmlbeans.impl.schema.SchemaParticleImpl;
import org.apache.xmlbeans.impl.schema.SchemaPropertyImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.schema.XmlValueRef;

public class StscChecker {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$xmlbeans$impl$schema$StscChecker;

    public static void checkAll() {
        StscState state = StscState.get();
        ArrayList<SchemaType> allSeenTypes = new ArrayList<SchemaType>();
        allSeenTypes.addAll(Arrays.asList(state.documentTypes()));
        allSeenTypes.addAll(Arrays.asList(state.attributeTypes()));
        allSeenTypes.addAll(Arrays.asList(state.redefinedGlobalTypes()));
        allSeenTypes.addAll(Arrays.asList(state.globalTypes()));
        int i = 0;
        while (i < allSeenTypes.size()) {
            SchemaType gType = (SchemaType)allSeenTypes.get(i);
            if (!state.noPvr() && !gType.isDocumentType()) {
                StscChecker.checkRestriction((SchemaTypeImpl)gType);
            }
            StscChecker.checkFields((SchemaTypeImpl)gType);
            allSeenTypes.addAll(Arrays.asList(gType.getAnonymousTypes()));
            ++i;
        }
        StscChecker.checkSubstitutionGroups(state.globalElements());
    }

    public static void checkFields(SchemaTypeImpl sType) {
        if (sType.isSimpleType()) {
            return;
        }
        XmlObject location = sType.getParseObject();
        SchemaAttributeModel sAttrModel = sType.getAttributeModel();
        if (sAttrModel != null) {
            SchemaLocalAttribute[] sAttrs = sAttrModel.getAttributes();
            QName idAttr = null;
            int i = 0;
            while (i < sAttrs.length) {
                if (XmlID.type.isAssignableFrom(sAttrs[i].getType())) {
                    if (idAttr == null) {
                        idAttr = sAttrs[i].getName();
                    } else {
                        StscState.get().error("Both " + QNameHelper.pretty(idAttr) + " and " + sAttrs[i].getName() + " are xs:ID attributes; only one ID attribute is allowed on a type.", 60, location);
                    }
                    if (sAttrs[i].getDefaultText() != null) {
                        StscState.get().error("An attribute of type xs:ID is not allowed to have a default or fixed constraint.", 60, location);
                    }
                } else {
                    String valueConstraint = sAttrs[i].getDefaultText();
                    if (valueConstraint != null) {
                        try {
                            XmlAnySimpleType val = sAttrs[i].getDefaultValue();
                            if (!val.validate()) {
                                throw new Exception();
                            }
                            SchemaPropertyImpl sProp = (SchemaPropertyImpl)sType.getAttributeProperty(sAttrs[i].getName());
                            if (sProp != null && sProp.getDefaultText() != null) {
                                sProp.setDefaultValue(new XmlValueRef(val));
                            }
                        }
                        catch (Exception e) {
                            if (sAttrs[i].isFixed()) {
                                StscState.get().error("The " + QNameHelper.pretty(sAttrs[i].getName()) + " element fixed value '" + valueConstraint + "' is not a valid value for " + QNameHelper.readable(sAttrs[i].getType()), 60, location);
                            }
                            StscState.get().error("The " + QNameHelper.pretty(sAttrs[i].getName()) + " element default value '" + valueConstraint + "' is not a valid value for " + QNameHelper.readable(sAttrs[i].getType()), 60, location);
                        }
                    }
                }
                ++i;
            }
        }
        StscChecker.checkElementDefaults(sType.getContentModel(), location, sType);
    }

    private static void checkElementDefaults(SchemaParticle model, XmlObject location, SchemaType parentType) {
        if (model == null) {
            return;
        }
        switch (model.getParticleType()) {
            case 1: 
            case 2: 
            case 3: {
                SchemaParticle[] children = model.getParticleChildren();
                int i = 0;
                while (i < children.length) {
                    StscChecker.checkElementDefaults(children[i], location, parentType);
                    ++i;
                }
                break;
            }
            case 4: {
                String valueConstraint = model.getDefaultText();
                if (valueConstraint == null) break;
                if (model.getType().isSimpleType() || model.getType().getContentType() == 2) {
                    try {
                        XmlAnySimpleType val = model.getDefaultValue();
                        if (!val.validate()) {
                            throw new Exception();
                        }
                        SchemaPropertyImpl sProp = (SchemaPropertyImpl)parentType.getElementProperty(model.getName());
                        if (sProp == null || sProp.getDefaultText() == null) break;
                        sProp.setDefaultValue(new XmlValueRef(val));
                    }
                    catch (Exception e) {
                        if (model.isFixed()) {
                            StscState.get().error("The " + QNameHelper.pretty(model.getName()) + " element fixed value '" + valueConstraint + "' is not a valid value for " + QNameHelper.readable(model.getType()), 60, location);
                            break;
                        }
                        StscState.get().error("The " + QNameHelper.pretty(model.getName()) + " element default value '" + valueConstraint + "' is not a valid value for " + QNameHelper.readable(model.getType()), 60, location);
                    }
                    break;
                }
                if (model.getType().getContentType() == 3) {
                    StscState.get().error("The " + QNameHelper.pretty(model.getName()) + " element cannot have a default value '" + valueConstraint + "' because its type has element content only.", 60, location);
                    break;
                }
                if (model.getType().getContentType() != 1) break;
                StscState.get().error("The " + QNameHelper.pretty(model.getName()) + " element cannot have a default value '" + valueConstraint + "' because its type has empty content only.", 60, location);
                break;
            }
        }
    }

    public static boolean checkRestriction(SchemaTypeImpl sType) {
        if (sType.getDerivationType() == 1 && !sType.isSimpleType()) {
            StscState state = StscState.get();
            XmlObject location = sType.getParseObject();
            SchemaType baseType = sType.getBaseType();
            if (baseType.isSimpleType()) {
                state.error("The base type of a complex type restriction must be a complex type.", 45, location);
                return false;
            }
            block0 : switch (sType.getContentType()) {
                case 2: {
                    switch (baseType.getContentType()) {
                        case 2: {
                            break block0;
                        }
                        case 4: {
                            if (baseType.getContentModel() == null || baseType.getContentModel().isSkippable()) break block0;
                            state.error("A type with a simple content model can only restrict a mixed content model that has skippable elements.", 45, location);
                            return false;
                        }
                    }
                    state.error("A type with a simple content model can only restrict a simple or mixed content model.", 45, location);
                    return false;
                }
                case 1: {
                    switch (baseType.getContentType()) {
                        case 1: {
                            break block0;
                        }
                        case 3: 
                        case 4: {
                            if (baseType.getContentModel() == null || baseType.getContentModel().isSkippable()) break block0;
                            state.error("A type with an empty content model can only restrict a content model that has skippable elements.", 45, location);
                            return false;
                        }
                    }
                    state.error("A type with an empty content model cannot restrict a type with a simple content model.", 45, location);
                    return false;
                }
                case 4: {
                    if (baseType.getContentType() != 4) {
                        state.error("A type with a mixed content model can only restrict another type with a mixed content model.", 45, location);
                        return false;
                    }
                }
                case 3: {
                    if (baseType.getContentType() == 1) {
                        state.error("A type with element or mixed content cannot restrict an empty type.", 45, location);
                        return false;
                    }
                    if (baseType.getContentType() == 2) {
                        state.error("A type with element or mixed content cannot restrict a simple type.", 45, location);
                        return false;
                    }
                    SchemaParticle baseModel = baseType.getContentModel();
                    SchemaParticle derivedModel = sType.getContentModel();
                    if (!($assertionsDisabled || baseModel != null && derivedModel != null)) {
                        throw new AssertionError();
                    }
                    if (baseModel == null || derivedModel == null) {
                        XBeanDebug.logStackTrace("Null models that weren't caught by EMPTY_CONTENT: " + baseType + " (" + baseModel + "), " + sType + " (" + derivedModel + ")");
                        state.error("Illegal restriction.", 45, location);
                        return false;
                    }
                    ArrayList errors = new ArrayList();
                    boolean isValid = StscChecker.isParticleValidRestriction(baseModel, derivedModel, errors, location);
                    if (isValid) break;
                    if (errors.size() == 0) {
                        state.error("Invalid restriction.", 45, location);
                        break;
                    }
                    state.getErrorListener().add(errors.get(errors.size() - 1));
                }
            }
        }
        return true;
    }

    public static boolean isParticleValidRestriction(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        boolean restrictionValid = false;
        if (baseModel.equals(derivedModel)) {
            restrictionValid = true;
        } else {
            block0 : switch (baseModel.getParticleType()) {
                case 4: {
                    switch (derivedModel.getParticleType()) {
                        case 4: {
                            restrictionValid = StscChecker.nameAndTypeOK((SchemaLocalElement)((Object)baseModel), (SchemaLocalElement)((Object)derivedModel), errors, context);
                            break block0;
                        }
                        case 5: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 1: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 2: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 3: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)XBeanDebug.logStackTrace("Unknown schema type for Derived Type"));
                    }
                    break;
                }
                case 5: {
                    switch (derivedModel.getParticleType()) {
                        case 4: {
                            restrictionValid = StscChecker.nsCompat(baseModel, (SchemaLocalElement)((Object)derivedModel), errors, context);
                            break block0;
                        }
                        case 5: {
                            restrictionValid = StscChecker.nsSubset(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 1: {
                            restrictionValid = StscChecker.nsRecurseCheckCardinality(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 2: {
                            restrictionValid = StscChecker.nsRecurseCheckCardinality(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 3: {
                            restrictionValid = StscChecker.nsRecurseCheckCardinality(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)XBeanDebug.logStackTrace("Unknown schema type for Derived Type"));
                    }
                    break;
                }
                case 1: {
                    switch (derivedModel.getParticleType()) {
                        case 4: {
                            restrictionValid = StscChecker.recurseAsIfGroup(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 5: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 1: {
                            restrictionValid = StscChecker.recurse(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 2: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 3: {
                            restrictionValid = StscChecker.recurseUnordered(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)XBeanDebug.logStackTrace("Unknown schema type for Derived Type"));
                    }
                    break;
                }
                case 2: {
                    switch (derivedModel.getParticleType()) {
                        case 4: {
                            restrictionValid = StscChecker.recurseAsIfGroup(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 5: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 1: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 2: {
                            restrictionValid = StscChecker.recurseLax(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 3: {
                            restrictionValid = StscChecker.mapAndSum(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)XBeanDebug.logStackTrace("Unknown schema type for Derived Type"));
                    }
                    break;
                }
                case 3: {
                    switch (derivedModel.getParticleType()) {
                        case 4: {
                            restrictionValid = StscChecker.recurseAsIfGroup(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                        case 5: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 1: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 2: {
                            errors.add(XmlError.forObject(StscChecker.formatInvalidCombinationError(baseModel, derivedModel), context));
                            restrictionValid = false;
                            break block0;
                        }
                        case 3: {
                            restrictionValid = StscChecker.recurse(baseModel, derivedModel, errors, context);
                            break block0;
                        }
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)XBeanDebug.logStackTrace("Unknown schema type for Derived Type"));
                    }
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)XBeanDebug.logStackTrace("Unknown schema type for Base Type"));
                    }
                    break;
                }
            }
        }
        return restrictionValid;
    }

    private static boolean mapAndSum(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        if (!$assertionsDisabled && baseModel.getParticleType() != 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && derivedModel.getParticleType() != 3) {
            throw new AssertionError();
        }
        boolean mapAndSumValid = true;
        SchemaParticle[] derivedParticleArray = derivedModel.getParticleChildren();
        SchemaParticle[] baseParticleArray = baseModel.getParticleChildren();
        int i = 0;
        while (i < derivedParticleArray.length) {
            SchemaParticle derivedParticle = derivedParticleArray[i];
            boolean foundMatch = false;
            int j = 0;
            while (j < baseParticleArray.length) {
                SchemaParticle baseParticle = baseParticleArray[j];
                if (StscChecker.isParticleValidRestriction(baseParticle, derivedParticle, errors, context)) {
                    foundMatch = true;
                    break;
                }
                ++j;
            }
            if (!foundMatch) {
                mapAndSumValid = false;
                errors.add(XmlError.forObject(StscChecker.formatMappingError(), context));
                break;
            }
            ++i;
        }
        BigInteger derivedRangeMin = derivedModel.getMinOccurs().multiply(BigInteger.valueOf(derivedModel.getParticleChildren().length));
        BigInteger derivedRangeMax = null;
        Object UNBOUNDED = null;
        derivedRangeMax = derivedModel.getMaxOccurs() == UNBOUNDED ? null : derivedModel.getMaxOccurs().multiply(BigInteger.valueOf(derivedModel.getParticleChildren().length));
        if (derivedRangeMin.compareTo(baseModel.getMinOccurs()) < 0) {
            mapAndSumValid = false;
            errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMinErrorChoiceSequence(derivedRangeMin, baseModel), context));
        } else if (baseModel.getMaxOccurs() == UNBOUNDED || derivedRangeMax != UNBOUNDED && derivedRangeMax.compareTo(baseModel.getMaxOccurs()) > 0) {
            mapAndSumValid = false;
            errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMaxErrorChoiceSequence(derivedRangeMax, baseModel), context));
        }
        return mapAndSumValid;
    }

    private static String formatOccurenceRangeMinErrorChoiceSequence(BigInteger derivedRangeMin, SchemaParticle baseModel) {
        return "Invalid Restriction.  The total minOccurs for the derived <sequence>'s elements: " + derivedRangeMin.toString() + "must not be less than the base <choice>'s minOccurs (" + baseModel.getMinOccurs().toString() + ")";
    }

    private static String formatOccurenceRangeMaxErrorChoiceSequence(BigInteger derivedRangeMax, SchemaParticle baseModel) {
        return "Invalid Restriction.  The total maxOccurs for the derived <sequence>'s elements (" + derivedRangeMax.toString() + ") must not be greater than the base <choice>'s maxOccurs (" + StscChecker.printMaxOccurs(baseModel.getMaxOccurs()) + ")";
    }

    private static String formatMappingError() {
        return "Invalid Restriction.  At least one restricted type does not match.";
    }

    private static boolean recurseAsIfGroup(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        if (!($assertionsDisabled || baseModel.getParticleType() == 1 && derivedModel.getParticleType() == 4 || baseModel.getParticleType() == 2 && derivedModel.getParticleType() == 4 || baseModel.getParticleType() == 3 && derivedModel.getParticleType() == 4)) {
            throw new AssertionError();
        }
        SchemaParticleImpl asIfPart = new SchemaParticleImpl();
        asIfPart.setParticleType(baseModel.getParticleType());
        asIfPart.setMinOccurs(BigInteger.ONE);
        asIfPart.setMaxOccurs(BigInteger.ONE);
        asIfPart.setParticleChildren(new SchemaParticle[]{derivedModel});
        return StscChecker.isParticleValidRestriction(baseModel, asIfPart, errors, context);
    }

    private static boolean recurseLax(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        if (!($assertionsDisabled || baseModel.getParticleType() == 2 && derivedModel.getParticleType() == 2)) {
            throw new AssertionError();
        }
        boolean recurseLaxValid = true;
        if (!StscChecker.occurrenceRangeOK(baseModel, derivedModel, errors, context)) {
            return false;
        }
        SchemaParticle[] derivedParticleArray = derivedModel.getParticleChildren();
        SchemaParticle[] baseParticleArray = baseModel.getParticleChildren();
        int i = 0;
        int j = 0;
        while (i < derivedParticleArray.length && j < baseParticleArray.length) {
            SchemaParticle baseParticle = baseParticleArray[j];
            SchemaParticle derivedParticle = derivedParticleArray[i];
            if (StscChecker.isParticleValidRestriction(baseParticle, derivedParticle, errors, context)) {
                ++i;
                ++j;
                continue;
            }
            ++j;
        }
        if (i < derivedParticleArray.length) {
            recurseLaxValid = false;
            String message = "Found derived particles that are not matched in the base content model.";
            errors.add(XmlError.forObject(StscChecker.formatDerivedMappingError(message, baseModel, derivedModel), context));
        }
        return recurseLaxValid;
    }

    private static boolean recurseUnordered(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        if (!($assertionsDisabled || baseModel.getParticleType() == 1 && derivedModel.getParticleType() == 3)) {
            throw new AssertionError();
        }
        boolean recurseUnorderedValid = true;
        if (!StscChecker.occurrenceRangeOK(baseModel, derivedModel, errors, context)) {
            return false;
        }
        SchemaParticle[] baseParticles = baseModel.getParticleChildren();
        HashMap<QName, Object> baseParticleMap = new HashMap<QName, Object>(10);
        Object MAPPED = new Object();
        int i = 0;
        while (i < baseParticles.length) {
            baseParticleMap.put(baseParticles[i].getName(), baseParticles[i]);
            ++i;
        }
        SchemaParticle[] derivedParticles = derivedModel.getParticleChildren();
        int i2 = 0;
        while (i2 < derivedParticles.length) {
            SchemaParticle matchedBaseParticle = (SchemaParticle)baseParticleMap.get(derivedParticles[i2].getName());
            if (matchedBaseParticle == null) {
                recurseUnorderedValid = false;
                errors.add(XmlError.forObject(StscChecker.formatInvalidAllSeqMappingError(), context));
                break;
            }
            if (matchedBaseParticle == MAPPED) {
                recurseUnorderedValid = false;
                errors.add(XmlError.forObject(StscChecker.formatMappedMoreThanOnceError(baseModel, derivedModel), context));
                break;
            }
            if (derivedParticles[i2].getMaxOccurs() == null || derivedParticles[i2].getMaxOccurs().compareTo(BigInteger.ONE) > 0) {
                recurseUnorderedValid = false;
                errors.add(XmlError.forObject(StscChecker.formatAllSeqMaxOccursGreaterThan1Error(derivedParticles[i2]), context));
                break;
            }
            if (!StscChecker.isParticleValidRestriction(matchedBaseParticle, derivedParticles[i2], errors, context)) {
                recurseUnorderedValid = false;
                break;
            }
            baseParticleMap.put(derivedParticles[i2].getName(), MAPPED);
            ++i2;
        }
        if (recurseUnorderedValid) {
            Set baseParticleCollection = baseParticleMap.keySet();
            Iterator iterator = baseParticleCollection.iterator();
            while (iterator.hasNext()) {
                QName baseParticleQName = (QName)iterator.next();
                if (baseParticleMap.get(baseParticleQName) == MAPPED || ((SchemaParticle)baseParticleMap.get(baseParticleQName)).isSkippable()) continue;
                recurseUnorderedValid = false;
                errors.add(XmlError.forObject(StscChecker.formatGroupMappingError(baseModel, derivedModel), context));
            }
        }
        return recurseUnorderedValid;
    }

    private static String formatAllSeqMaxOccursGreaterThan1Error(SchemaParticle derivedModel) {
        return "Invalid Restriction.  The " + StscChecker.printParticle(derivedModel) + " has a maxOccurs great than 1 (" + StscChecker.printMaxOccurs(derivedModel.getMaxOccurs()) + ").  When restricting an <all> with a <sequence>, no <element> can have a maxOccurs > 1";
    }

    private static String formatInvalidAllSeqMappingError() {
        return "Invalid Restriction.  Each element in the derived content model must match an element in the base content model.";
    }

    private static String formatGroupMappingError(SchemaParticle baseModel, SchemaParticle derivedModel) {
        return "Invalid Restriction.  The members of the derived content model must match the members of the base  content model unless the member of the base content model is optional (particle emptiable).";
    }

    private static String formatMappedMoreThanOnceError(SchemaParticle baseModel, SchemaParticle derivedModel) {
        return "Invalid Restriction.  When using a <sequence> to restrict an <all> the elements in the <all> can be mapped only once.  Found element in the <sequence> that maps an element in the <all> more than once.";
    }

    private static boolean recurse(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        boolean recurseValid = true;
        if (!StscChecker.occurrenceRangeOK(baseModel, derivedModel, errors, context)) {
            return false;
        }
        SchemaParticle[] derivedParticleArray = derivedModel.getParticleChildren();
        SchemaParticle[] baseParticleArray = baseModel.getParticleChildren();
        int i = 0;
        int j = 0;
        while (i < derivedParticleArray.length && j < baseParticleArray.length) {
            SchemaParticle baseParticle = baseParticleArray[j];
            SchemaParticle derivedParticle = derivedParticleArray[i];
            if (StscChecker.isParticleValidRestriction(baseParticle, derivedParticle, errors, context)) {
                ++i;
                ++j;
                continue;
            }
            if (baseParticle.isSkippable()) {
                ++j;
                continue;
            }
            recurseValid = false;
            String message = "Found non-optional particle that is not mapped in base content model.";
            errors.add(XmlError.forObject(StscChecker.formatDerivedMappingError(message, baseModel, derivedModel), context));
            break;
        }
        if (i < derivedParticleArray.length) {
            recurseValid = false;
            String message = "Found derived particles that are not matched in the base content model.";
            errors.add(XmlError.forObject(StscChecker.formatDerivedMappingError(message, baseModel, derivedModel), context));
        } else if (j < baseParticleArray.length) {
            int k = j;
            while (k < baseParticleArray.length) {
                if (!baseParticleArray[k].isSkippable()) {
                    recurseValid = false;
                    String message = "Found trailing base particles that are not optional and are not represented in the derived content model.";
                    errors.add(XmlError.forObject(StscChecker.formatDerivedMappingError(message, baseModel, derivedModel), context));
                }
                ++k;
            }
        }
        return recurseValid;
    }

    private static String formatDerivedMappingError(String message, SchemaParticle baseModel, SchemaParticle derivedModel) {
        return "Invalid Restriction.  The derived (restricted) content model must match the base content model unless the part of the base content model that does not match is optional.  A mismatch found between a base " + StscChecker.printParticle(baseModel) + " and a derived " + StscChecker.printParticle(derivedModel) + ".  " + message;
    }

    private static boolean nsRecurseCheckCardinality(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        if (!$assertionsDisabled && baseModel.getParticleType() != 5) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && derivedModel.getParticleType() != 1 && derivedModel.getParticleType() != 2 && derivedModel.getParticleType() != 3) {
            throw new AssertionError();
        }
        boolean nsRecurseCheckCardinality = true;
        SchemaParticleImpl asIfPart = new SchemaParticleImpl();
        asIfPart.setParticleType(baseModel.getParticleType());
        asIfPart.setWildcardProcess(baseModel.getWildcardProcess());
        asIfPart.setWildcardSet(baseModel.getWildcardSet());
        asIfPart.setMinOccurs(BigInteger.ZERO);
        asIfPart.setMaxOccurs(null);
        asIfPart.setTransitionRules(baseModel.getWildcardSet(), true);
        asIfPart.setTransitionNotes(baseModel.getWildcardSet(), true);
        SchemaParticle[] particleChildren = derivedModel.getParticleChildren();
        int i = 0;
        while (i < particleChildren.length) {
            SchemaParticle particle = particleChildren[i];
            switch (particle.getParticleType()) {
                case 4: {
                    nsRecurseCheckCardinality = StscChecker.nsCompat(asIfPart, (SchemaLocalElement)((Object)particle), errors, context);
                    break;
                }
                case 5: {
                    nsRecurseCheckCardinality = StscChecker.nsSubset(asIfPart, particle, errors, context);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    nsRecurseCheckCardinality = StscChecker.nsRecurseCheckCardinality(asIfPart, derivedModel, errors, context);
                }
            }
            if (!nsRecurseCheckCardinality) break;
            ++i;
        }
        if (nsRecurseCheckCardinality) {
            nsRecurseCheckCardinality = StscChecker.checkGroupOccurrenceOK(baseModel, derivedModel, errors, context);
        }
        return nsRecurseCheckCardinality;
    }

    private static boolean checkGroupOccurrenceOK(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        boolean groupOccurrenceOK = true;
        BigInteger minRange = BigInteger.ZERO;
        BigInteger maxRange = BigInteger.ZERO;
        switch (derivedModel.getParticleType()) {
            case 1: 
            case 3: {
                minRange = StscChecker.getEffectiveMinRangeAllSeq(derivedModel);
                maxRange = StscChecker.getEffectiveMaxRangeAllSeq(derivedModel);
                break;
            }
            case 2: {
                minRange = StscChecker.getEffectiveMinRangeChoice(derivedModel);
                maxRange = StscChecker.getEffectiveMaxRangeChoice(derivedModel);
            }
        }
        if (minRange.compareTo(baseModel.getMinOccurs()) < 0) {
            groupOccurrenceOK = false;
            errors.add(XmlError.forObject(StscChecker.formatGroupMinOccursError(derivedModel, baseModel), context));
        }
        Object UNBOUNDED = null;
        if (baseModel.getMaxOccurs() != UNBOUNDED) {
            if (maxRange == UNBOUNDED) {
                groupOccurrenceOK = false;
                errors.add(XmlError.forObject(StscChecker.formatGroupMaxOccursError(derivedModel, baseModel), context));
            } else if (maxRange.compareTo(baseModel.getMaxOccurs()) > 0) {
                groupOccurrenceOK = false;
                errors.add(XmlError.forObject(StscChecker.formatGroupMaxOccursError(derivedModel, baseModel), context));
            }
        }
        return groupOccurrenceOK;
    }

    private static String formatGroupMaxOccursError(SchemaParticle derivedModel, SchemaParticle baseModel) {
        return "Invalid Restriction.  The maxOccurs for the derived group " + StscChecker.printParticle(derivedModel) + " is great than the base maxOccurs of " + StscChecker.printMaxOccurs(baseModel.getMaxOccurs());
    }

    private static String formatGroupMinOccursError(SchemaParticle derivedModel, SchemaParticle baseModel) {
        return "Invalid Restriction.  The minOccurs for the derived group " + StscChecker.printParticle(derivedModel) + " is less than the base minOccurs of " + baseModel.getMinOccurs();
    }

    private static BigInteger getEffectiveMaxRangeChoice(SchemaParticle derivedModel) {
        BigInteger maxRange = BigInteger.ZERO;
        Object UNBOUNDED = null;
        boolean nonZeroParticleChildFound = false;
        BigInteger maxOccursInWildCardOrElement = BigInteger.ZERO;
        BigInteger maxOccursInGroup = BigInteger.ZERO;
        SchemaParticle[] particleChildren = derivedModel.getParticleChildren();
        int i = 0;
        while (i < particleChildren.length) {
            SchemaParticle particle = particleChildren[i];
            switch (particle.getParticleType()) {
                case 4: 
                case 5: {
                    if (particle.getMaxOccurs() == UNBOUNDED) {
                        maxRange = UNBOUNDED;
                        break;
                    }
                    if (particle.getIntMaxOccurs() <= 0) break;
                    nonZeroParticleChildFound = true;
                    if (particle.getMaxOccurs().compareTo(maxOccursInWildCardOrElement) <= 0) break;
                    maxOccursInWildCardOrElement = particle.getMaxOccurs();
                    break;
                }
                case 1: 
                case 3: {
                    maxRange = StscChecker.getEffectiveMaxRangeAllSeq(derivedModel);
                    if (maxRange == UNBOUNDED || maxRange.compareTo(maxOccursInGroup) <= 0) break;
                    maxOccursInGroup = maxRange;
                    break;
                }
                case 2: {
                    maxRange = StscChecker.getEffectiveMaxRangeChoice(derivedModel);
                    if (maxRange == UNBOUNDED || maxRange.compareTo(maxOccursInGroup) <= 0) break;
                    maxOccursInGroup = maxRange;
                }
            }
            if (maxRange == UNBOUNDED) break;
            ++i;
        }
        if (maxRange != UNBOUNDED) {
            maxRange = nonZeroParticleChildFound && derivedModel.getMaxOccurs() == UNBOUNDED ? UNBOUNDED : derivedModel.getMaxOccurs().multiply(maxOccursInWildCardOrElement.add(maxOccursInGroup));
        }
        return maxRange;
    }

    private static BigInteger getEffectiveMaxRangeAllSeq(SchemaParticle derivedModel) {
        BigInteger maxRange = BigInteger.ZERO;
        Object UNBOUNDED = null;
        boolean nonZeroParticleChildFound = false;
        BigInteger maxOccursTotal = BigInteger.ZERO;
        BigInteger maxOccursInGroup = BigInteger.ZERO;
        SchemaParticle[] particleChildren = derivedModel.getParticleChildren();
        int i = 0;
        while (i < particleChildren.length) {
            SchemaParticle particle = particleChildren[i];
            switch (particle.getParticleType()) {
                case 4: 
                case 5: {
                    if (particle.getMaxOccurs() == UNBOUNDED) {
                        maxRange = UNBOUNDED;
                        break;
                    }
                    if (particle.getIntMaxOccurs() <= 0) break;
                    nonZeroParticleChildFound = true;
                    maxOccursTotal = maxOccursTotal.add(particle.getMaxOccurs());
                    break;
                }
                case 1: 
                case 3: {
                    maxRange = StscChecker.getEffectiveMaxRangeAllSeq(derivedModel);
                    if (maxRange == UNBOUNDED || maxRange.compareTo(maxOccursInGroup) <= 0) break;
                    maxOccursInGroup = maxRange;
                    break;
                }
                case 2: {
                    maxRange = StscChecker.getEffectiveMaxRangeChoice(derivedModel);
                    if (maxRange == UNBOUNDED || maxRange.compareTo(maxOccursInGroup) <= 0) break;
                    maxOccursInGroup = maxRange;
                }
            }
            if (maxRange == UNBOUNDED) break;
            ++i;
        }
        if (maxRange != UNBOUNDED) {
            maxRange = nonZeroParticleChildFound && derivedModel.getMaxOccurs() == UNBOUNDED ? UNBOUNDED : derivedModel.getMaxOccurs().multiply(maxOccursTotal.add(maxOccursInGroup));
        }
        return maxRange;
    }

    private static BigInteger getEffectiveMinRangeChoice(SchemaParticle derivedModel) {
        SchemaParticle[] particleChildren = derivedModel.getParticleChildren();
        if (particleChildren.length == 0) {
            return BigInteger.ZERO;
        }
        BigInteger minRange = null;
        int i = 0;
        while (i < particleChildren.length) {
            SchemaParticle particle = particleChildren[i];
            switch (particle.getParticleType()) {
                case 4: 
                case 5: {
                    if (minRange != null && minRange.compareTo(particle.getMinOccurs()) <= 0) break;
                    minRange = particle.getMinOccurs();
                    break;
                }
                case 1: 
                case 3: {
                    BigInteger mrs = StscChecker.getEffectiveMinRangeAllSeq(derivedModel);
                    if (minRange != null && minRange.compareTo(mrs) <= 0) break;
                    minRange = mrs;
                    break;
                }
                case 2: {
                    BigInteger mrc = StscChecker.getEffectiveMinRangeChoice(derivedModel);
                    if (minRange != null && minRange.compareTo(mrc) <= 0) break;
                    minRange = mrc;
                }
            }
            ++i;
        }
        if (minRange == null) {
            minRange = BigInteger.ZERO;
        }
        minRange = derivedModel.getMinOccurs().multiply(minRange);
        return minRange;
    }

    private static BigInteger getEffectiveMinRangeAllSeq(SchemaParticle derivedModel) {
        BigInteger minRange = BigInteger.ZERO;
        SchemaParticle[] particleChildren = derivedModel.getParticleChildren();
        BigInteger particleTotalMinOccurs = BigInteger.ZERO;
        int i = 0;
        while (i < particleChildren.length) {
            SchemaParticle particle = particleChildren[i];
            switch (particle.getParticleType()) {
                case 4: 
                case 5: {
                    particleTotalMinOccurs = particleTotalMinOccurs.add(particle.getMinOccurs());
                    break;
                }
                case 1: 
                case 3: {
                    particleTotalMinOccurs = particleTotalMinOccurs.add(StscChecker.getEffectiveMinRangeAllSeq(derivedModel));
                    break;
                }
                case 2: {
                    particleTotalMinOccurs = particleTotalMinOccurs.add(StscChecker.getEffectiveMinRangeChoice(derivedModel));
                }
            }
            ++i;
        }
        minRange = derivedModel.getMinOccurs().multiply(particleTotalMinOccurs);
        return minRange;
    }

    private static boolean nsSubset(SchemaParticle baseModel, SchemaParticle derivedModel, Collection errors, XmlObject context) {
        if (!$assertionsDisabled && baseModel.getParticleType() != 5) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && derivedModel.getParticleType() != 5) {
            throw new AssertionError();
        }
        boolean nsSubset = false;
        if (StscChecker.occurrenceRangeOK(baseModel, derivedModel, errors, context)) {
            if (baseModel.getWildcardSet().inverse().isDisjoint(derivedModel.getWildcardSet())) {
                nsSubset = true;
            } else {
                nsSubset = false;
                errors.add(XmlError.forObject(StscChecker.formatNSIsNotSubsetError(baseModel, derivedModel), context));
            }
        } else {
            nsSubset = false;
            errors.add(XmlError.forObject(StscChecker.formatNSIsNotSubsetError(baseModel, derivedModel), context));
        }
        return nsSubset;
    }

    private static boolean nsCompat(SchemaParticle baseModel, SchemaLocalElement derivedElement, Collection errors, XmlObject context) {
        if (!$assertionsDisabled && baseModel.getParticleType() != 5) {
            throw new AssertionError();
        }
        boolean nsCompat = false;
        if (baseModel.getWildcardSet().contains(derivedElement.getName())) {
            if (StscChecker.occurrenceRangeOK(baseModel, (SchemaParticle)((Object)derivedElement), errors, context)) {
                nsCompat = true;
            } else {
                errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMinError(baseModel, (SchemaParticle)((Object)derivedElement)), context));
            }
        } else {
            nsCompat = false;
            errors.add(XmlError.forObject(StscChecker.formatNSIsNotSubsetError(baseModel, (SchemaParticle)((Object)derivedElement)), context));
        }
        return nsCompat;
    }

    private static String formatNSIsNotSubsetError(SchemaParticle baseParticle, SchemaParticle derivedParticle) {
        return "Invalid Restriction. The namespace(s) of the derived field: " + StscChecker.printParticle(derivedParticle) + " are not a subset of the namespace(s) of the base field: " + StscChecker.printParticle(baseParticle);
    }

    private static String formatInvalidCombinationError(SchemaParticle baseModel, SchemaParticle derivedModel) {
        return "Invalid Restriction.  The derived content model " + StscChecker.printParticle(derivedModel) + " cannot restrict base content model " + StscChecker.printParticle(baseModel);
    }

    private static boolean nameAndTypeOK(SchemaLocalElement baseElement, SchemaLocalElement derivedElement, Collection errors, XmlObject context) {
        boolean nameAndTypeOK = false;
        if (((SchemaParticle)((Object)baseElement)).canStartWithElement(derivedElement.getName()) && (baseElement.isNillable() || !derivedElement.isNillable()) && StscChecker.occurrenceRangeOK((SchemaParticle)((Object)baseElement), (SchemaParticle)((Object)derivedElement), errors, context) && (nameAndTypeOK = StscChecker.checkFixed(baseElement, derivedElement, errors, context)) && (nameAndTypeOK = StscChecker.checkIdentityConstraints(baseElement, derivedElement, errors, context)) && (nameAndTypeOK = StscChecker.typeDerivationOK(baseElement.getType(), derivedElement.getType(), errors, context))) {
            nameAndTypeOK = StscChecker.blockSetOK(baseElement, derivedElement, errors, context);
        }
        return nameAndTypeOK;
    }

    private static boolean blockSetOK(SchemaLocalElement baseElement, SchemaLocalElement derivedElement, Collection errors, XmlObject context) {
        if (baseElement.blockRestriction() && !derivedElement.blockRestriction()) {
            errors.add(XmlError.forObject("Restriction Invalid.  Derived " + StscChecker.printParticle((SchemaParticle)((Object)derivedElement)) + " does not block restriction as does the base " + StscChecker.printParticle((SchemaParticle)((Object)baseElement)), context));
            return false;
        }
        if (baseElement.blockExtension() && !derivedElement.blockExtension()) {
            errors.add(XmlError.forObject("Restriction Invalid.  Derived " + StscChecker.printParticle((SchemaParticle)((Object)derivedElement)) + " does not block extension as does the base " + StscChecker.printParticle((SchemaParticle)((Object)baseElement)), context));
            return false;
        }
        if (baseElement.blockSubstitution() && !derivedElement.blockSubstitution()) {
            errors.add(XmlError.forObject("Restriction Invalid.  Derived " + StscChecker.printParticle((SchemaParticle)((Object)derivedElement)) + " does not block substitution as does the base " + StscChecker.printParticle((SchemaParticle)((Object)baseElement)), context));
            return false;
        }
        return true;
    }

    private static boolean typeDerivationOK(SchemaType baseType, SchemaType derivedType, Collection errors, XmlObject context) {
        boolean typeDerivationOK = false;
        if (baseType.isAssignableFrom(derivedType)) {
            typeDerivationOK = StscChecker.checkAllDerivationsForRestriction(baseType, derivedType, errors, context);
        } else {
            typeDerivationOK = false;
            errors.add(XmlError.forObject(StscChecker.formatDerivedTypeNotSubTypeError(baseType, derivedType), context));
        }
        return typeDerivationOK;
    }

    private static String formatDerivedTypeNotSubTypeError(SchemaType baseType, SchemaType derivedType) {
        return "Restriction Invalid.  Derived Type: " + StscChecker.printType(derivedType) + " is not a sub-type of Base Type: " + StscChecker.printType(baseType);
    }

    private static boolean checkAllDerivationsForRestriction(SchemaType baseType, SchemaType derivedType, Collection errors, XmlObject context) {
        boolean allDerivationsAreRestrictions = true;
        SchemaType currentType = derivedType;
        while (!baseType.equals(currentType)) {
            if (currentType.getDerivationType() == 1) {
                currentType = currentType.getBaseType();
                continue;
            }
            allDerivationsAreRestrictions = false;
            errors.add(XmlError.forObject(StscChecker.formatAllDerivationsAreNotRestrictionsError(baseType, derivedType, currentType), context));
            break;
        }
        return allDerivationsAreRestrictions;
    }

    private static String formatAllDerivationsAreNotRestrictionsError(SchemaType baseType, SchemaType derivedType, SchemaType currentType) {
        return "Invalid Restriction.  The type " + StscChecker.printType(derivedType) + " derived from base type " + StscChecker.printType(baseType) + " has an intermediary type " + StscChecker.printType(currentType) + "that is not derived by restriction.";
    }

    private static boolean checkIdentityConstraints(SchemaLocalElement baseElement, SchemaLocalElement derivedElement, Collection errors, XmlObject context) {
        boolean identityConstraintsOK = true;
        SchemaIdentityConstraint[] baseConstraints = baseElement.getIdentityConstraints();
        SchemaIdentityConstraint[] derivedConstraints = derivedElement.getIdentityConstraints();
        int i = 0;
        while (i < derivedConstraints.length) {
            SchemaIdentityConstraint derivedConstraint = derivedConstraints[i];
            if (StscChecker.checkForIdentityConstraintExistence(baseConstraints, derivedConstraint)) {
                identityConstraintsOK = false;
                errors.add(XmlError.forObject(StscChecker.formatIdentityConstraintsNotSubsetError(baseElement, derivedElement), context));
                break;
            }
            ++i;
        }
        return identityConstraintsOK;
    }

    private static String formatIdentityConstraintsNotSubsetError(SchemaLocalElement baseElement, SchemaLocalElement derivedElement) {
        return "Restriction Invalid.  The identity constraints for " + StscChecker.printParticle((SchemaParticle)((Object)derivedElement)) + " are not a subset of the identity constraints for " + StscChecker.printParticle((SchemaParticle)((Object)baseElement));
    }

    private static boolean checkForIdentityConstraintExistence(SchemaIdentityConstraint[] baseConstraints, SchemaIdentityConstraint derivedConstraint) {
        boolean identityConstraintExists = false;
        int i = 0;
        while (i < baseConstraints.length) {
            SchemaIdentityConstraint baseConstraint = baseConstraints[i];
            if (baseConstraint.getName().equals(derivedConstraint.getName())) {
                identityConstraintExists = true;
                break;
            }
            ++i;
        }
        return identityConstraintExists;
    }

    private static boolean checkFixed(SchemaLocalElement baseModel, SchemaLocalElement derivedModel, Collection errors, XmlObject context) {
        boolean checkFixed = false;
        if (baseModel.isFixed()) {
            if (baseModel.getDefaultText().equals(derivedModel.getDefaultText())) {
                checkFixed = true;
            } else {
                errors.add(XmlError.forObject(StscChecker.formatInvalidFixedError(baseModel, derivedModel), context));
                checkFixed = false;
            }
        } else {
            checkFixed = true;
        }
        return checkFixed;
    }

    private static String formatInvalidFixedError(SchemaLocalElement baseModel, SchemaLocalElement derivedModel) {
        return "The Derived Content Model on Element: '" + StscChecker.printParticle((SchemaParticle)((Object)derivedModel)) + "' has a fixed value of: '" + derivedModel.getDefaultText() + "' which does not match the Base Content Model: '" + StscChecker.printParticle((SchemaParticle)((Object)baseModel)) + "' what has a fixed value of: '" + baseModel.getDefaultText() + "'";
    }

    private static boolean occurrenceRangeOK(SchemaParticle baseParticle, SchemaParticle derivedParticle, Collection errors, XmlObject context) {
        boolean occurrenceRangeOK = false;
        if (derivedParticle.getMinOccurs().compareTo(baseParticle.getMinOccurs()) >= 0) {
            if (baseParticle.getMaxOccurs() == null) {
                occurrenceRangeOK = true;
            } else if (derivedParticle.getMaxOccurs() != null && baseParticle.getMaxOccurs() != null && derivedParticle.getMaxOccurs().compareTo(baseParticle.getMaxOccurs()) <= 0) {
                occurrenceRangeOK = true;
            } else {
                occurrenceRangeOK = false;
                if (baseParticle.getName() == null || derivedParticle.getName() == null) {
                    errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMaxErrorGroup(baseParticle, derivedParticle), context));
                } else {
                    errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMaxError(baseParticle, derivedParticle), context));
                }
            }
        } else {
            occurrenceRangeOK = false;
            if (baseParticle.getName() == null || derivedParticle.getName() == null) {
                errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMinErrorGroup(baseParticle, derivedParticle), context));
            } else {
                errors.add(XmlError.forObject(StscChecker.formatOccurenceRangeMinError(baseParticle, derivedParticle), context));
            }
        }
        return occurrenceRangeOK;
    }

    private static String formatOccurenceRangeMaxErrorGroup(SchemaParticle baseParticle, SchemaParticle derivedParticle) {
        return "Invalid Restriction.  The maxOccurs for the " + StscChecker.printParticle(derivedParticle) + " (" + StscChecker.printMaxOccurs(derivedParticle.getMaxOccurs()) + ") is greater than than the maxOccurs for the base " + StscChecker.printParticle(baseParticle) + " (" + StscChecker.printMaxOccurs(baseParticle.getMaxOccurs()) + ")";
    }

    private static String formatOccurenceRangeMinErrorGroup(SchemaParticle baseParticle, SchemaParticle derivedParticle) {
        return "Invalid Restriction.  The minOccurs for the " + StscChecker.printParticle(derivedParticle) + " (" + derivedParticle.getMinOccurs().toString() + ") is less than than the minOccurs for the base " + StscChecker.printParticle(baseParticle) + " (" + baseParticle.getMinOccurs().toString() + ")";
    }

    private static String formatOccurenceRangeMinError(SchemaParticle baseField, SchemaParticle derivedField) {
        return "Invalid Restriction.  The minOccurs for the element: '" + StscChecker.printParticle(derivedField) + "' (" + derivedField.getMinOccurs().toString() + ") is less than than the minOccurs for the base element: '" + StscChecker.printParticle(baseField) + "' (" + baseField.getMinOccurs().toString() + ")";
    }

    private static String formatOccurenceRangeMaxError(SchemaParticle baseField, SchemaParticle derivedField) {
        return "Invalid Restriction.  The maxOccurs for the element: '" + StscChecker.printParticle(derivedField) + "' (" + StscChecker.printMaxOccurs(derivedField.getMaxOccurs()) + ") is greater than than the maxOccurs for the base element: '" + StscChecker.printParticle(baseField) + "' (" + StscChecker.printMaxOccurs(baseField.getMaxOccurs()) + ")";
    }

    private static String printParticle(SchemaParticle part) {
        switch (part.getParticleType()) {
            case 1: {
                return "<all>";
            }
            case 2: {
                return "<choice>";
            }
            case 4: {
                return "<element name=\"" + QNameHelper.pretty(part.getName()) + "\">";
            }
            case 3: {
                return "<sequence>";
            }
            case 5: {
                return "<any>";
            }
        }
        return "??";
    }

    private static String printMaxOccurs(BigInteger bi) {
        if (bi == null) {
            return "unbounded";
        }
        return bi.toString();
    }

    private static String printType(SchemaType type) {
        if (type.getName() != null) {
            return QNameHelper.pretty(type.getName());
        }
        return type.toString();
    }

    private static void checkSubstitutionGroups(SchemaGlobalElement[] elts) {
        StscState state = StscState.get();
        int i = 0;
        while (i < elts.length) {
            SchemaGlobalElement elt = elts[i];
            SchemaGlobalElement head = elt.substitutionGroup();
            if (head != null) {
                SchemaType headType = head.getType();
                SchemaType tailType = elt.getType();
                XmlObject parseTree = ((SchemaGlobalElementImpl)elt)._parseObject;
                if (!headType.isAssignableFrom(tailType)) {
                    state.error("Element " + QNameHelper.pretty(elt.getName()) + " must have a type that is derived from the type of its substitution group.", 50, parseTree);
                } else if (head.finalExtension() && head.finalRestriction()) {
                    state.error("Element " + QNameHelper.pretty(elt.getName()) + " cannot be substituted for element with final='#all'", 54, parseTree);
                } else if (!headType.equals(tailType)) {
                    if (head.finalExtension() && tailType.getDerivationType() == 2) {
                        state.error("Element " + QNameHelper.pretty(elt.getName()) + " cannot be substituted for element with final='extension'", 54, parseTree);
                    } else if (head.finalRestriction() && tailType.getDerivationType() == 1) {
                        state.error("Element " + QNameHelper.pretty(elt.getName()) + " cannot be substituted for element with final='restriction'", 54, parseTree);
                    }
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$org$apache$xmlbeans$impl$schema$StscChecker == null ? (class$org$apache$xmlbeans$impl$schema$StscChecker = StscChecker.class$("org.apache.xmlbeans.impl.schema.StscChecker")) : class$org$apache$xmlbeans$impl$schema$StscChecker).desiredAssertionStatus();
    }
}

