/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment == null ? (class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment = ResolverFragment.class$("org.apache.xml.security.utils.resolver.implementations.ResolverFragment")) : class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment).getName());
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$implementations$ResolverFragment;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        String string2 = attr.getNodeValue();
        Document document = attr.getOwnerDocument();
        XMLUtils.circumventBug2650(document);
        Element element = null;
        if (string2.equals("")) {
            log.debug((Object)"ResolverFragment with empty URI (means complete document)");
            element = document.getDocumentElement();
        } else {
            object = string2.substring(1);
            element = IdResolver.getElementById(document, (String)object);
            log.debug((Object)("Try to catch an Element with ID " + (String)object + " and Element was " + element));
        }
        object = this.dereferenceSameDocumentURI(element);
        XMLSignatureInput xMLSignatureInput = new XMLSignatureInput((Set)object);
        log.debug((Object)("We return a nodeset with " + object.size() + " nodes"));
        xMLSignatureInput.setMIMEType("text/xml");
        try {
            URI uRI = new URI(new URI(string), attr.getNodeValue());
            xMLSignatureInput.setSourceURI(uRI.toString());
        }
        catch (URI.MalformedURIException malformedURIException) {
            xMLSignatureInput.setSourceURI(string);
        }
        return xMLSignatureInput;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            log.debug((Object)"Quick fail for null uri");
            return false;
        }
        String string2 = attr.getNodeValue();
        if (string2.equals("") || string2.startsWith("#") && !string2.startsWith("#xpointer(")) {
            log.debug((Object)("State I can resolve reference: \"" + string2 + "\""));
            return true;
        }
        log.debug((Object)("Do not seem to be able to resolve reference: \"" + string2 + "\""));
        return false;
    }

    private Set dereferenceSameDocumentURI(Node node) {
        HashSet hashSet = new HashSet();
        if (node != null) {
            this.nodeSetMinusCommentNodes(node, hashSet, null);
        }
        return hashSet;
    }

    private void nodeSetMinusCommentNodes(Node node, Set set, Node node2) {
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        set.add(namedNodeMap.item(i));
                    }
                }
                set.add(node);
                Node node3 = null;
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.nodeSetMinusCommentNodes(node4, set, node3);
                    node3 = node4;
                }
                break;
            }
            case 3: 
            case 4: {
                if (node2 != null && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    return;
                }
            }
            case 7: {
                set.add(node);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

