/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.helper;

import java.util.Arrays;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class C14nHelper {
    private C14nHelper() {
    }

    public static final Object[] sortAttributes(Object[] objectArray) {
        if (objectArray == null) {
            return new Attr[0];
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        Arrays.sort(objectArray2, new AttrCompare());
        return objectArray2;
    }

    public static final String normalizeAttr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("&#x9;");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("&#xA;");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String normalizeComment(String string) {
        return C14nHelper.normalizeProcessingInstruction(string);
    }

    public static final String normalizeProcessingInstruction(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#xD;");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String normalizeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static boolean namespaceIsRelative(Attr attr) {
        return !C14nHelper.namespaceIsAbsolute(attr);
    }

    public static boolean namespaceIsRelative(String string) {
        return !C14nHelper.namespaceIsAbsolute(string);
    }

    public static boolean namespaceIsAbsolute(Attr attr) {
        return C14nHelper.namespaceIsAbsolute(attr.getValue());
    }

    public static boolean namespaceIsAbsolute(String string) {
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                bl = true;
                continue;
            }
            if (bl || c != '/') continue;
            return false;
        }
        return bl;
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String string = attr.getNodeName();
        boolean bl = string.equals("xmlns");
        boolean bl2 = string.startsWith("xmlns:");
        if ((bl || bl2) && C14nHelper.namespaceIsRelative(attr)) {
            String string2 = attr.getOwnerElement().getTagName();
            String string3 = attr.getValue();
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
    }

    public static void checkTraversability(Document document) throws CanonicalizationException {
        if (!document.isSupported("Traversal", "2.0")) {
            Object[] objectArray = new Object[]{document.getImplementation().getClass().getName()};
            throw new CanonicalizationException("c14n.Canonicalizer.TraversalNotSupported", objectArray);
        }
    }

    public static void checkForRelativeNamespace(Element element) throws CanonicalizationException {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                C14nHelper.assertNotRelativeNS((Attr)namedNodeMap.item(i));
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }
}

