/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X509CertificateResolver
extends KeyResolverSpi {
    static Category cat;
    NodeList _x509CertKeyElements;
    XMLX509Certificate[] _x509certObject;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        cat.debug((Object)("Can I resolve " + element.getTagName() + '?'));
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "X509Data");
        }
        catch (XMLSignatureException xMLSignatureException) {
            cat.debug((Object)"I can't");
            return false;
        }
        try {
            Element element2 = XMLUtils.createDSctx(element.getOwnerDocument(), "ds", "http://www.w3.org/2000/09/xmldsig#");
            this._x509CertKeyElements = XPathAPI.selectNodeList((Node)element, (String)"./ds:X509Certificate", (Node)element2);
            if (this._x509CertKeyElements != null && this._x509CertKeyElements.getLength() > 0) {
                cat.debug((Object)"Yes Sir, I can");
                return true;
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        cat.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            int n;
            if (!(this._x509CertKeyElements != null && this._x509CertKeyElements.getLength() != 0 || (n = this.engineCanResolve(element, string, storageResolver)) != 0 && this._x509CertKeyElements != null && this._x509CertKeyElements.getLength() != 0)) {
                return null;
            }
            this._x509certObject = new XMLX509Certificate[this._x509CertKeyElements.getLength()];
            n = 0;
            while (n < this._x509CertKeyElements.getLength()) {
                this._x509certObject[n] = new XMLX509Certificate((Element)this._x509CertKeyElements.item(n), string);
                ++n;
            }
            n = 0;
            while (n < this._x509certObject.length) {
                X509Certificate x509Certificate = this._x509certObject[n].getX509Certificate();
                if (x509Certificate != null) {
                    return x509Certificate;
                }
                ++n;
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            cat.debug((Object)"XMLSecurityException", (Throwable)xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this._x509CertKeyElements = null;
        this._x509certObject = null;
    }

    public X509CertificateResolver() {
        this.this();
    }

    static {
        Class clazz = class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$keys$keyresolver$implementations$X509CertificateResolver = X509CertificateResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.X509CertificateResolver");
        }
        cat = Category.getInstance((String)clazz.getName());
    }
}

