/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.EncryptionElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CipherValue
extends EncryptionElementProxy {
    public byte[] getCipherText() throws XMLSecurityException {
        NodeList nodeList = this._constructionElement.getChildNodes();
        if (nodeList.getLength() != 1 || nodeList.item(0).getNodeType() != 3) {
            throw new XMLSecurityException("encryption.structure.CipherTextMustContainText");
        }
        Text text = (Text)nodeList.item(0);
        return Base64.decode(text.getData());
    }

    public void setCipherText(byte[] byArray) throws XMLSecurityException {
        while (this._constructionElement.hasChildNodes()) {
            this._constructionElement.removeChild(this._constructionElement.getLastChild());
        }
        Text text = this._doc.createTextNode(Base64.encode(byArray));
        this._constructionElement.appendChild(text);
    }

    public String getBaseLocalName() {
        return "CipherValue";
    }

    public CipherValue(Document document, byte[] byArray) throws XMLSecurityException {
        super(document);
        this.setCipherText(byArray);
    }

    public CipherValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }
}

