/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MessageDigestAlgorithm
extends Algorithm {
    static Category cat;
    public static final String ALGO_ID_DIGEST_NOT_RECOMMENDED_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String ALGO_ID_DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String ALGO_ID_DIGEST_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String ALGO_ID_DIGEST_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String ALGO_ID_DIGEST_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String ALGO_ID_DIGEST_RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    MessageDigest algorithm;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$MessageDigestAlgorithm;

    public static MessageDigestAlgorithm getInstance(Document document, String string) throws XMLSignatureException {
        MessageDigest messageDigest;
        JCEMapper.ProviderIdClass providerIdClass = JCEMapper.translateURItoJCEID(string);
        try {
            messageDigest = MessageDigest.getInstance(providerIdClass.getAlgorithmID(), providerIdClass.getProviderId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{providerIdClass.getAlgorithmID(), noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{providerIdClass.getProviderId(), noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        return new MessageDigestAlgorithm(document, messageDigest, string);
    }

    public MessageDigest getAlgorithm() {
        return this.algorithm;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return MessageDigest.isEqual(byArray, byArray2);
    }

    public byte[] digest() {
        return this.algorithm.digest();
    }

    public byte[] digest(byte[] byArray) {
        return this.algorithm.digest(byArray);
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        return this.algorithm.digest(byArray, n, n2);
    }

    public String getJCEAlgorithmString() {
        return this.algorithm.getAlgorithm();
    }

    public Provider getJCEProvider() {
        return this.algorithm.getProvider();
    }

    public int getDigestLength() {
        return this.algorithm.getDigestLength();
    }

    public void reset() {
        this.algorithm.reset();
    }

    public void update(byte[] byArray) {
        this.algorithm.update(byArray);
    }

    public void update(byte by) {
        this.algorithm.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.algorithm.update(byArray, n, n2);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "DigestMethod";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.algorithm = null;
    }

    private MessageDigestAlgorithm(Document document, MessageDigest messageDigest, String string) {
        super(document, string);
        this.this();
        this.algorithm = messageDigest;
    }

    static {
        Class clazz = class$org$apache$xml$security$algorithms$MessageDigestAlgorithm;
        if (clazz == null) {
            clazz = class$org$apache$xml$security$algorithms$MessageDigestAlgorithm = MessageDigestAlgorithm.class$("org.apache.xml.security.algorithms.MessageDigestAlgorithm");
        }
        cat = Category.getInstance((String)clazz.getName());
    }
}

