/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.java.DefaultJavaService;
import org.codehaus.xfire.java.Invoker;
import org.codehaus.xfire.java.JavaService;
import org.codehaus.xfire.transport.Session;

public class JavaInvoker
implements Invoker {
    private static final Log logger = LogFactory.getLog((String)JavaInvoker.class.getName());
    private Object appObj;

    public Object invoke(Method method, Object[] params, MessageContext context) throws XFireFault {
        try {
            Object serviceObject = this.getServiceObject(context);
            return method.invoke(serviceObject, params);
        }
        catch (IllegalArgumentException e) {
            throw new XFireFault("Illegal argument.", (Throwable)e, "Sender");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof XFireFault) {
                throw (XFireFault)t;
            }
            if (t instanceof Exception) {
                logger.warn((Object)"Error invoking service.", t);
                throw new XFireFault(t, "Sender");
            }
            logger.warn((Object)"Error invoking service.", (Throwable)e);
            throw new XFireRuntimeException("Error invoking service.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Couldn't access service object.", (Throwable)e, "Receiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getServiceObject(MessageContext context) throws XFireFault {
        JavaService service = (JavaService)context.getService();
        int scope = service.getScope();
        if (scope == 1) {
            if (this.appObj == null) {
                Class clazz = DefaultJavaService.class;
                synchronized (clazz) {
                    this.appObj = this.createServiceObject(service);
                }
            }
            return this.appObj;
        }
        if (scope == 2) {
            String key;
            Session session = context.getSession();
            Object sessObj = session.get((Object)(key = "service." + service.getName()));
            if (sessObj == null) {
                Class clazz = DefaultJavaService.class;
                synchronized (clazz) {
                    sessObj = this.createServiceObject(service);
                    session.put((Object)key, sessObj);
                }
            }
            return sessObj;
        }
        if (scope == 3) {
            return this.createServiceObject(service);
        }
        throw new UnsupportedOperationException("Scope " + scope + " is invalid.");
    }

    public Object createServiceObject(JavaService service) throws XFireFault {
        try {
            return service.getServiceClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate service object.", (Throwable)e, "Receiver");
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Couldn't access service object.", (Throwable)e, "Receiver");
        }
    }
}

