/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.mapping;

import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.codehaus.xfire.AbstractXFireComponent;
import org.codehaus.xfire.java.JavaServiceHandler;
import org.codehaus.xfire.java.mapping.AutoTypeMapping;
import org.codehaus.xfire.java.mapping.CustomTypeMapping;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.type.BooleanType;
import org.codehaus.xfire.java.type.DoubleType;
import org.codehaus.xfire.java.type.FloatType;
import org.codehaus.xfire.java.type.IntType;
import org.codehaus.xfire.java.type.LongType;
import org.codehaus.xfire.java.type.StringType;
import org.codehaus.xfire.soap.Soap11;

public class DefaultTypeMappingRegistry
extends AbstractXFireComponent
implements TypeMappingRegistry {
    private static Logger logger = Logger.getLogger((String)JavaServiceHandler.class.getName());
    private static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
    private static final QName XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long");
    private static final QName XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float");
    private static final QName XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double");
    private static final QName XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int");
    private static final QName XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    private static final String ENCODED_NS = Soap11.getInstance().getSoapEncodingStyle();
    private static final QName ENCODED_STRING = new QName(ENCODED_NS, "string");
    private static final QName ENCODED_LONG = new QName(ENCODED_NS, "long");
    private static final QName ENCODED_FLOAT = new QName(ENCODED_NS, "float");
    private static final QName ENCODED_DOUBLE = new QName(ENCODED_NS, "double");
    private static final QName ENCODED_INT = new QName(ENCODED_NS, "int");
    private static final QName ENCODED_BOOLEAN = new QName(ENCODED_NS, "boolean");
    private static final StringType STRING_TYPE = new StringType();
    private static final LongType LONG_TYPE = new LongType();
    private static final FloatType FLOAT_TYPE = new FloatType();
    private static final DoubleType DOUBLE_TYPE = new DoubleType();
    private static final IntType INT_TYPE = new IntType();
    private static final BooleanType BOOLEAN_TYPE = new BooleanType();
    private Hashtable registry = new Hashtable();
    private TypeMapping defaultTM;

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        TypeMapping previous = (TypeMapping)this.registry.get(encodingStyleURI);
        mapping.setEncodingStyleURI(encodingStyleURI);
        this.registry.put(encodingStyleURI, mapping);
        return previous;
    }

    public void registerDefault(TypeMapping mapping) {
        this.defaultTM = mapping;
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.defaultTM;
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return this.registry.keySet().toArray(new String[0]);
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        return (TypeMapping)this.registry.get(encodingStyleURI);
    }

    public TypeMapping createTypeMapping(boolean autoTypes) {
        return this.createTypeMapping(this.getDefaultTypeMapping(), autoTypes);
    }

    public TypeMapping createTypeMapping(String parentNamespace, boolean autoTypes) {
        return this.createTypeMapping(this.getTypeMapping(parentNamespace), autoTypes);
    }

    protected TypeMapping createTypeMapping(TypeMapping parent, boolean autoTypes) {
        if (autoTypes) {
            return new AutoTypeMapping(parent);
        }
        return new CustomTypeMapping(parent);
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        TypeMapping tm = (TypeMapping)this.registry.get(encodingStyleURI);
        this.registry.remove(encodingStyleURI);
        return tm;
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        int n = 0;
        Iterator itr = this.registry.values().iterator();
        while (itr.hasNext()) {
            if (!itr.next().equals(mapping)) continue;
            itr.remove();
            ++n;
        }
        return n > 0;
    }

    public void clear() {
        this.registry.clear();
    }

    public TypeMapping createDefaultMappings() {
        TypeMapping tm = this.createTypeMapping(false);
        tm.register(Boolean.TYPE, XSD_BOOLEAN, BOOLEAN_TYPE);
        tm.register(Integer.TYPE, XSD_INT, INT_TYPE);
        tm.register(Double.TYPE, XSD_DOUBLE, DOUBLE_TYPE);
        tm.register(Float.TYPE, XSD_FLOAT, FLOAT_TYPE);
        tm.register(Long.TYPE, XSD_LONG, LONG_TYPE);
        tm.register(String.class, XSD_STRING, STRING_TYPE);
        tm.register(Boolean.class, XSD_BOOLEAN, BOOLEAN_TYPE);
        tm.register(Integer.class, XSD_INT, INT_TYPE);
        tm.register(Double.class, XSD_DOUBLE, DOUBLE_TYPE);
        tm.register(Float.class, XSD_FLOAT, FLOAT_TYPE);
        tm.register(Long.class, XSD_LONG, LONG_TYPE);
        this.register("http://www.w3.org/2001/XMLSchema", tm);
        TypeMapping soapTM = this.createTypeMapping(tm, false);
        soapTM.register(Boolean.TYPE, ENCODED_BOOLEAN, BOOLEAN_TYPE);
        soapTM.register(Integer.TYPE, ENCODED_INT, INT_TYPE);
        soapTM.register(Double.TYPE, ENCODED_DOUBLE, DOUBLE_TYPE);
        soapTM.register(Float.TYPE, ENCODED_FLOAT, FLOAT_TYPE);
        soapTM.register(Long.TYPE, ENCODED_LONG, LONG_TYPE);
        soapTM.register(String.class, ENCODED_STRING, STRING_TYPE);
        soapTM.register(Boolean.class, ENCODED_BOOLEAN, BOOLEAN_TYPE);
        soapTM.register(Integer.class, ENCODED_INT, INT_TYPE);
        soapTM.register(Double.class, ENCODED_DOUBLE, DOUBLE_TYPE);
        soapTM.register(Float.class, ENCODED_FLOAT, FLOAT_TYPE);
        soapTM.register(Long.class, ENCODED_LONG, LONG_TYPE);
        soapTM.register(Boolean.TYPE, XSD_BOOLEAN, BOOLEAN_TYPE);
        soapTM.register(Integer.TYPE, XSD_INT, INT_TYPE);
        soapTM.register(Double.TYPE, XSD_DOUBLE, DOUBLE_TYPE);
        soapTM.register(Float.TYPE, XSD_FLOAT, FLOAT_TYPE);
        soapTM.register(Long.TYPE, XSD_LONG, LONG_TYPE);
        soapTM.register(String.class, XSD_STRING, STRING_TYPE);
        soapTM.register(Boolean.class, XSD_BOOLEAN, BOOLEAN_TYPE);
        soapTM.register(Integer.class, XSD_INT, INT_TYPE);
        soapTM.register(Double.class, XSD_DOUBLE, DOUBLE_TYPE);
        soapTM.register(Float.class, XSD_FLOAT, FLOAT_TYPE);
        soapTM.register(Long.class, XSD_LONG, LONG_TYPE);
        this.register(ENCODED_NS, soapTM);
        return tm;
    }
}

