/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.mapping;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.codehaus.xfire.java.ServiceHelper;
import org.codehaus.xfire.java.mapping.CustomTypeMapping;
import org.codehaus.xfire.java.mapping.TypeMapping;
import org.codehaus.xfire.java.type.ArrayType;
import org.codehaus.xfire.java.type.BeanType;
import org.codehaus.xfire.java.type.Type;

public class AutoTypeMapping
extends CustomTypeMapping {
    public AutoTypeMapping(TypeMapping defaultTM) {
        super(defaultTM);
    }

    public AutoTypeMapping() {
    }

    public Type getType(Class javaType, QName xmlType) {
        Type type = super.getType(javaType, xmlType);
        if (type == null) {
            this.register(javaType, xmlType, this.findTypeClass(javaType));
            type = super.getType(javaType, xmlType);
        }
        return type;
    }

    private Type findTypeClass(Class javaType) {
        if (javaType.isArray() || javaType.isAssignableFrom(Collection.class)) {
            return new ArrayType();
        }
        return new BeanType();
    }

    public Type getType(Class javaType) {
        Type type = super.getType(javaType);
        if (type == null) {
            QName qname = this.createQName(javaType);
            this.register(javaType, qname, this.findTypeClass(javaType));
            type = super.getType(javaType, qname);
        }
        return type;
    }

    private QName createQName(Class javaType) {
        String clsName = javaType.getName();
        if (clsName.startsWith("[L")) {
            clsName = clsName.substring(2, clsName.length() - 1);
        }
        String ns = ServiceHelper.makeNamespaceFromClassName(clsName, "http");
        String localName = null;
        if (javaType.isArray() || javaType.isAssignableFrom(Collection.class)) {
            localName = "ArrayOf" + clsName.substring(clsName.lastIndexOf(".") + 1);
            if (javaType.isArray()) {
                Type type = this.getType(javaType.getComponentType());
                ns = type.isComplex() ? type.getSchemaType().getNamespaceURI() : this.getEncodingStyleURI();
            }
        } else {
            localName = clsName.substring(clsName.lastIndexOf(".") + 1);
        }
        return new QName(ns, localName);
    }
}

