/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.util.DateUtils;
import org.dom4j.Element;

public class LiteralReader
implements MessageReader {
    private Element root;

    public LiteralReader(Element root) {
        this.root = root;
    }

    public String getValue() {
        return this.root.getText();
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.getValue());
    }

    public Date getValueAsDate() {
        return DateUtils.parseDate((String)this.getValue());
    }

    public Date getValueAsDateTime() {
        return DateUtils.parseDateTime((String)this.getValue());
    }

    public Element getElement() {
        return this.root;
    }

    public Calendar getValueAsCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDateTime((String)this.getValue()));
        return calendar;
    }

    public MessageReader getReader(String name) {
        Element child = this.getElement().element(name);
        return new LiteralReader(child);
    }

    public List getReaders() {
        ArrayList<LiteralReader> readers = new ArrayList<LiteralReader>();
        Iterator itr = this.getElement().elementIterator();
        while (itr.hasNext()) {
            readers.add(new LiteralReader((Element)itr.next()));
        }
        return readers;
    }

    public List getReaders(String name) {
        ArrayList<LiteralReader> readers = new ArrayList<LiteralReader>();
        Iterator itr = this.getElement().elementIterator(name);
        while (itr.hasNext()) {
            readers.add(new LiteralReader((Element)itr.next()));
        }
        return readers;
    }

    public long getValueAsLong() {
        return Long.parseLong(this.getValue());
    }

    public double getValueAsDouble() {
        return Double.parseDouble(this.getValue());
    }

    public float getValueAsFloat() {
        return Float.parseFloat(this.getValue());
    }

    public boolean getValueAsBoolean() {
        return Boolean.valueOf(this.getValue());
    }
}

