/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import org.codehaus.xfire.service.MessageService;
import org.codehaus.xfire.service.object.Invoker;
import org.codehaus.xfire.service.object.ObjectService;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.type.TypeMapping;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;

public class DefaultObjectService
extends MessageService
implements ObjectService {
    private TypeMapping typeMapping;
    private List allowedMethods = new ArrayList();
    private Class serviceClass;
    private Hashtable operations = new Hashtable();
    private WSDLBuilder wsdlBuilder;
    private boolean autoTyped = false;
    private int scope = 1;
    private String encodingStyleURI;
    private Invoker invoker;

    public void setServiceClass(String className) throws ClassNotFoundException {
        this.setServiceClass(this.loadClass(className));
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void addOperation(Operation op) {
        this.operations.put(op.getName(), op);
    }

    private boolean isAllowed(String methodName) {
        return this.allowedMethods.isEmpty() || this.allowedMethods.contains(methodName);
    }

    public Operation getOperation(String localName) {
        return (Operation)this.operations.get(localName);
    }

    public Collection getOperations() {
        return this.operations.values();
    }

    protected Map getOperationsMap() {
        return this.operations;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException cnf2) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
    }

    public WSDLWriter getWSDLWriter() throws WSDLException {
        WSDLBuilder b;
        WSDLWriter writer = super.getWSDLWriter();
        if (writer == null && (b = this.getWSDLBuilder()) != null) {
            return this.getWSDLBuilder().createWSDLWriter(this);
        }
        return writer;
    }

    public boolean isAutoTyped() {
        return this.autoTyped;
    }

    public void setAutoTyped(boolean autoTyped) {
        this.autoTyped = autoTyped;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public WSDLBuilder getWSDLBuilder() {
        return this.wsdlBuilder;
    }

    public void setWSDLBuilder(WSDLBuilder wsdlBuilder) {
        this.wsdlBuilder = wsdlBuilder;
    }

    public String getEncodingStyleURI() {
        return this.encodingStyleURI;
    }

    public void setEncodingStyleURI(String encodingStyleURI) {
        this.encodingStyleURI = encodingStyleURI;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }
}

