/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.message.bridge;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.message.bridge.AbstractMessageBridge;
import org.codehaus.xfire.message.stax.ElementReader;
import org.codehaus.xfire.message.stax.ElementWriter;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.util.DepthXMLStreamReader;

public class RPCEncodedBridge
extends AbstractMessageBridge {
    public RPCEncodedBridge(MessageContext context) {
        super(context);
    }

    public List read() throws XFireFault {
        int index;
        ArrayList<Object> parameters = new ArrayList<Object>();
        ElementReader reader = new ElementReader(new DepthXMLStreamReader(this.getRequestReader()));
        if (!reader.hasMoreElementReaders()) {
            throw new XFireFault("There must be a method name element.", "Sender");
        }
        MessageReader methodReader = reader.getNextElementReader();
        String opName = methodReader.getLocalName();
        Operation operation = this.getService().getOperation(opName);
        if (operation == null && (index = opName.indexOf("Request")) > 0) {
            operation = this.getService().getOperation(opName.substring(0, index));
        }
        this.setOperation(operation);
        Operation op = this.getOperation();
        if (op == null) {
            throw new XFireFault("Invalid operation: " + opName, "Sender");
        }
        while (methodReader.hasMoreElementReaders()) {
            MessageReader cReader = methodReader.getNextElementReader();
            Parameter p = op.getInParameter(cReader.getName());
            if (p == null) {
                throw new XFireFault("No such IN parameter: " + cReader.getName(), "Sender");
            }
            parameters.add(p.read(cReader, this.getContext()));
        }
        return parameters;
    }

    public void write(Object[] values) throws XFireFault {
        String name = this.getOperation().getName() + "Response";
        ElementWriter writer = new ElementWriter(this.getResponseWriter(), name, this.getService().getDefaultNamespace());
        int i = 0;
        Iterator itr = this.getOperation().getOutParameters().iterator();
        while (itr.hasNext()) {
            Parameter outParam = (Parameter)itr.next();
            outParam.write(values[i], writer, this.getContext());
            ++i;
        }
        writer.close();
    }
}

