/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.message.AbstractMessageBridge;
import org.codehaus.xfire.message.LiteralReader;
import org.codehaus.xfire.message.LiteralWriter;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.util.DepthXMLStreamReader;

public class RPCEncodedBridge
extends AbstractMessageBridge {
    public RPCEncodedBridge(MessageContext context) {
        super(context);
    }

    public List read() throws XFireFault {
        int index;
        ArrayList<Object> parameters = new ArrayList<Object>();
        LiteralReader reader = new LiteralReader(new DepthXMLStreamReader(this.getRequestReader()));
        if (!reader.hasMoreChildReaders()) {
            throw new XFireFault("There must be a method name element.", "Sender");
        }
        MessageReader methodReader = reader.getNextChildReader();
        String opName = methodReader.getLocalName();
        Operation operation = this.getService().getOperation(opName);
        if (operation == null && (index = opName.indexOf("Request")) > 0) {
            operation = this.getService().getOperation(opName.substring(0, index));
        }
        this.setOperation(operation);
        Operation op = this.getOperation();
        if (op == null) {
            throw new XFireFault("Invalid operation: " + opName, "Sender");
        }
        while (methodReader.hasMoreChildReaders()) {
            MessageReader cReader = methodReader.getNextChildReader();
            Parameter p = op.getInParameter(cReader.getName());
            if (p == null) {
                throw new XFireFault("No such IN parameter: " + cReader.getName(), "Sender");
            }
            parameters.add(p.read(cReader, this.getContext()));
        }
        return parameters;
    }

    public void write(Object[] values) throws XFireFault {
        String name = this.getOperation().getName() + "Response";
        LiteralWriter writer = new LiteralWriter(this.getResponseWriter(), name, this.getService().getDefaultNamespace());
        int i = 0;
        Iterator itr = this.getOperation().getOutParameters().iterator();
        while (itr.hasNext()) {
            Parameter outParam = (Parameter)itr.next();
            outParam.write(values[i], writer, this.getContext());
            ++i;
        }
        writer.close();
    }
}

